/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.tez.common.TezUtilsInternal;
import org.apache.tez.common.counters.AbstractCounter;
import org.apache.tez.common.counters.TaskCounter;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;

public class TezCountersDelegate
extends TezCounters {
    private final String groupModifier;
    private final TezCounters original;

    public TezCountersDelegate(TezCounters original, String taskVertexName, String edgeVertexName, String type) {
        this.original = original;
        this.groupModifier = TezUtilsInternal.cleanVertexName((String)taskVertexName) + "_" + type + "_" + TezUtilsInternal.cleanVertexName((String)edgeVertexName);
    }

    public TezCounter findCounter(String groupName, String counterName) {
        String simpleGroupName = groupName.equals(TaskCounter.class.getName()) ? TaskCounter.class.getSimpleName() : groupName;
        String modifiedGroupName = simpleGroupName + "_" + this.groupModifier;
        TezCounter modifiedGroupCounter = this.original.findCounter(modifiedGroupName, counterName);
        TezCounter originalGroupCounter = this.original.findCounter(groupName, counterName);
        return new CompositeCounter(modifiedGroupCounter, originalGroupCounter);
    }

    private static class CompositeCounter
    extends AbstractCounter {
        TezCounter modifiedCounter;
        TezCounter originalCounter;

        public CompositeCounter(TezCounter modifiedCounter, TezCounter originalCounter) {
            this.modifiedCounter = modifiedCounter;
            this.originalCounter = originalCounter;
        }

        public String getName() {
            return this.modifiedCounter.getName();
        }

        public String getDisplayName() {
            return this.modifiedCounter.getName();
        }

        public long getValue() {
            return this.modifiedCounter.getValue();
        }

        public void setValue(long value) {
            this.modifiedCounter.setValue(value);
            this.originalCounter.setValue(value);
        }

        public void increment(long increment) {
            this.modifiedCounter.increment(increment);
            this.originalCounter.increment(increment);
        }

        public TezCounter getUnderlyingCounter() {
            return this;
        }

        public void write(DataOutput dataOutput) throws IOException {
            assert (false) : "shouldn't be called";
        }

        public void readFields(DataInput dataInput) throws IOException {
            assert (false) : "shouldn't be called";
        }
    }
}

