/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.EntityDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.runtime.InputReadyTracker;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.ExecutionContext;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.InputStatisticsReporter;
import org.apache.tez.runtime.api.LogicalInput;
import org.apache.tez.runtime.api.ObjectRegistry;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.impl.EventMetaData;
import org.apache.tez.runtime.api.impl.TezCountersDelegate;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.runtime.api.impl.TezTaskContextImpl;
import org.apache.tez.runtime.api.impl.TezUmbilical;
import org.apache.tez.runtime.common.resources.MemoryDistributor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TezInputContextImpl
extends TezTaskContextImpl
implements InputContext {
    private static final Logger LOG = LoggerFactory.getLogger(TezInputContextImpl.class);
    private volatile UserPayload userPayload;
    private final String sourceVertexName;
    private final EventMetaData sourceInfo;
    private final int inputIndex;
    private final Map<String, LogicalInput> inputs;
    private volatile InputReadyTracker inputReadyTracker;
    private final InputStatisticsReporterImpl statsReporter;

    @InterfaceAudience.Private
    public TezInputContextImpl(Configuration conf, String[] workDirs, int appAttemptNumber, TezUmbilical tezUmbilical, String dagName, String taskVertexName, String sourceVertexName, int vertexParallelism, TezTaskAttemptID taskAttemptID, int inputIndex, @Nullable UserPayload userPayload, LogicalIOProcessorRuntimeTask runtimeTask, Map<String, ByteBuffer> serviceConsumerMetadata, Map<String, String> auxServiceEnv, MemoryDistributor memDist, InputDescriptor inputDescriptor, Map<String, LogicalInput> inputs, InputReadyTracker inputReadyTracker, ObjectRegistry objectRegistry, ExecutionContext ExecutionContext2, long memAvailable) {
        super(conf, workDirs, appAttemptNumber, dagName, taskVertexName, vertexParallelism, taskAttemptID, TezInputContextImpl.wrapCounters(runtimeTask, taskVertexName, sourceVertexName, conf), runtimeTask, tezUmbilical, serviceConsumerMetadata, auxServiceEnv, memDist, (EntityDescriptor<?>)inputDescriptor, objectRegistry, ExecutionContext2, memAvailable);
        Preconditions.checkNotNull((Object)inputIndex, (Object)"inputIndex is null");
        Preconditions.checkNotNull((Object)sourceVertexName, (Object)"sourceVertexName is null");
        Preconditions.checkNotNull(inputs, (Object)"input map is null");
        Preconditions.checkNotNull((Object)inputReadyTracker, (Object)"inputReadyTracker is null");
        this.userPayload = userPayload;
        this.inputIndex = inputIndex;
        this.sourceVertexName = sourceVertexName;
        this.sourceInfo = new EventMetaData(EventMetaData.EventProducerConsumerType.INPUT, taskVertexName, sourceVertexName, taskAttemptID);
        this.inputs = inputs;
        this.inputReadyTracker = inputReadyTracker;
        runtimeTask.getTaskStatistics().addIO(sourceVertexName);
        this.statsReporter = new InputStatisticsReporterImpl();
    }

    private static TezCounters wrapCounters(LogicalIOProcessorRuntimeTask task, String taskVertexName, String edgeVertexName, Configuration conf) {
        TezCounters tezCounters = task.addAndGetTezCounter(edgeVertexName);
        if (conf.getBoolean("tez.task.generate.counters.per.io", false)) {
            return new TezCountersDelegate(tezCounters, taskVertexName, edgeVertexName, "INPUT");
        }
        return tezCounters;
    }

    public void sendEvents(List<Event> events) {
        Preconditions.checkNotNull(events, (Object)"events are null");
        ArrayList<TezEvent> tezEvents = new ArrayList<TezEvent>(events.size());
        for (Event e : events) {
            TezEvent tEvt = new TezEvent(e, this.sourceInfo);
            tezEvents.add(tEvt);
        }
        this.tezUmbilical.addEvents(tezEvents);
    }

    public UserPayload getUserPayload() {
        return this.userPayload;
    }

    public int getInputIndex() {
        return this.inputIndex;
    }

    public String getSourceVertexName() {
        return this.sourceVertexName;
    }

    public void fatalError(Throwable exception, String message) {
        super.signalFatalError(exception, message, this.sourceInfo);
    }

    public void reportFailure(TaskFailureType taskFailureType, @Nullable Throwable exception, @Nullable String message) {
        super.signalFailure(taskFailureType, exception, message, this.sourceInfo);
    }

    public void killSelf(@Nullable Throwable exception, @Nullable String message) {
        super.signalKillSelf(exception, message, this.sourceInfo);
    }

    public void inputIsReady() {
        if (this.inputReadyTracker != null) {
            this.inputReadyTracker.setInputIsReady((Input)this.inputs.get(this.sourceVertexName));
        } else {
            LOG.warn("Ignoring Input Ready notification since the Task has already been closed");
        }
    }

    public InputStatisticsReporter getStatisticsReporter() {
        return this.statsReporter;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.userPayload = null;
        this.inputReadyTracker = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Cleared TezInputContextImpl related information");
        }
    }

    class InputStatisticsReporterImpl
    implements InputStatisticsReporter {
        InputStatisticsReporterImpl() {
        }

        public synchronized void reportDataSize(long size) {
            TezInputContextImpl.this.runtimeTask.getTaskStatistics().getIOStatistics().get(TezInputContextImpl.this.sourceVertexName).setDataSize(size);
        }

        public void reportItemsProcessed(long items) {
            TezInputContextImpl.this.runtimeTask.getTaskStatistics().getIOStatistics().get(TezInputContextImpl.this.sourceVertexName).setItemsProcessed(items);
        }
    }
}

