/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.runtime.api.impl;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.InputReadyTracker;
import org.apache.tez.runtime.LogicalIOProcessorRuntimeTask;
import org.apache.tez.runtime.api.Input;
import org.apache.tez.runtime.api.MergedInputContext;
import org.apache.tez.runtime.api.MergedLogicalInput;

public class TezMergedInputContextImpl
implements MergedInputContext {
    private final UserPayload userPayload;
    private final String groupInputName;
    private final Map<String, MergedLogicalInput> groupInputsMap;
    private final InputReadyTracker inputReadyTracker;
    private final String[] workDirs;
    private final LogicalIOProcessorRuntimeTask runtimeTask;

    public TezMergedInputContextImpl(@Nullable UserPayload userPayload, String groupInputName, Map<String, MergedLogicalInput> groupInputsMap, InputReadyTracker inputReadyTracker, String[] workDirs, LogicalIOProcessorRuntimeTask runtimeTask) {
        Preconditions.checkNotNull((Object)groupInputName, (Object)"groupInputName is null");
        Preconditions.checkNotNull(groupInputsMap, (Object)"input-group map is null");
        Preconditions.checkNotNull((Object)inputReadyTracker, (Object)"inputReadyTracker is null");
        this.groupInputName = groupInputName;
        this.groupInputsMap = groupInputsMap;
        this.userPayload = userPayload;
        this.inputReadyTracker = inputReadyTracker;
        this.workDirs = workDirs;
        this.runtimeTask = runtimeTask;
    }

    public UserPayload getUserPayload() {
        return this.userPayload;
    }

    public void inputIsReady() {
        this.inputReadyTracker.setInputIsReady((Input)this.groupInputsMap.get(this.groupInputName));
    }

    public String[] getWorkDirs() {
        return Arrays.copyOf(this.workDirs, this.workDirs.length);
    }

    public final void notifyProgress() {
        this.runtimeTask.notifyProgressInvocation();
    }
}

