/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.test.TestInput;
import org.apache.tez.test.TestOutput;
import org.apache.tez.test.TestProcessor;

public final class SimpleTestDAG3Vertices {
    static Resource defaultResource = Resource.newInstance((int)100, (int)0);
    public static String TEZ_SIMPLE_DAG_NUM_TASKS = "tez.simple-test-dag-3-vertices.num-tasks";
    public static int TEZ_SIMPLE_DAG_NUM_TASKS_DEFAULT = 2;

    private SimpleTestDAG3Vertices() {
    }

    public static DAG createDAG(String name, Configuration conf) throws Exception {
        UserPayload payload = null;
        int taskCount = TEZ_SIMPLE_DAG_NUM_TASKS_DEFAULT;
        if (conf != null) {
            taskCount = conf.getInt(TEZ_SIMPLE_DAG_NUM_TASKS, TEZ_SIMPLE_DAG_NUM_TASKS_DEFAULT);
            payload = TezUtils.createUserPayloadFromConf((Configuration)conf);
        }
        DAG dag = DAG.create((String)name);
        Vertex v1 = Vertex.create((String)"v1", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)taskCount, (Resource)defaultResource);
        Vertex v2 = Vertex.create((String)"v2", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)taskCount, (Resource)defaultResource);
        Vertex v3 = Vertex.create((String)"v3", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)taskCount, (Resource)defaultResource);
        dag.addVertex(v1).addVertex(v2).addEdge(Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)TestOutput.getOutputDesc(payload), (InputDescriptor)TestInput.getInputDesc(payload))));
        dag.addVertex(v3).addEdge(Edge.create((Vertex)v2, (Vertex)v3, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)EdgeProperty.DataMovementType.SCATTER_GATHER, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)TestOutput.getOutputDesc(payload), (InputDescriptor)TestInput.getInputDesc(payload))));
        return dag;
    }

    public static DAG createDAG(Configuration conf) throws Exception {
        return SimpleTestDAG3Vertices.createDAG("SimpleTestDAG3Vertices", conf);
    }
}

