/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.runtime.api.AbstractLogicalInput;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.InputContext;
import org.apache.tez.runtime.api.Reader;
import org.apache.tez.runtime.api.TaskFailureType;
import org.apache.tez.runtime.api.events.DataMovementEvent;
import org.apache.tez.runtime.api.events.InputFailedEvent;
import org.apache.tez.runtime.api.events.InputReadErrorEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInput
extends AbstractLogicalInput {
    private static final Logger LOG = LoggerFactory.getLogger(TestInput.class);
    public static final String COUNTER_NAME = "TestInput";
    Configuration conf;
    int numCompletedInputs = 0;
    int[] completedInputVersion;
    AtomicInteger inputReady = new AtomicInteger(-1);
    int lastInputReadyValue = -1;
    int failingInputUpto = 0;
    boolean doFail = false;
    boolean doRandomFail = false;
    float randomFailProbability = 0.0f;
    boolean doFailAndExit = false;
    Set<Integer> failingTaskIndices = Sets.newHashSet();
    Set<Integer> failingTaskAttempts = Sets.newHashSet();
    Set<Integer> failingInputIndices = Sets.newHashSet();
    Integer failAll = new Integer(-1);
    int[] inputValues;
    public static String TEZ_FAILING_INPUT_DO_FAIL = "tez.failing-input.do-fail";
    public static String TEZ_FAILING_INPUT_DO_RANDOM_FAIL = "tez.failing-input.do-random-fail";
    public static String TEZ_FAILING_INPUT_RANDOM_FAIL_PROBABILITY = "tez.failing-input.random-fail-probability";
    public static String TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT = "tez.failing-input.do-fail-and-exit";
    public static String TEZ_FAILING_INPUT_FAILING_INPUT_INDEX = "tez.failing-input.failing-input-index";
    public static String TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT = "tez.failing-input.failing-upto-input-attempt";
    public static String TEZ_FAILING_INPUT_FAILING_TASK_INDEX = "tez.failing-input.failing-task-index";
    public static String TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT = "tez.failing-input.failing-task-attempt";

    public TestInput(InputContext inputContext, int numPhysicalInputs) {
        super(inputContext, numPhysicalInputs);
        this.completedInputVersion = new int[numPhysicalInputs];
        this.inputValues = new int[numPhysicalInputs];
        for (int i = 0; i < numPhysicalInputs; ++i) {
            this.completedInputVersion[i] = -1;
            this.inputValues[i] = -1;
        }
    }

    public static InputDescriptor getInputDesc(UserPayload payload) {
        InputDescriptor desc = InputDescriptor.create((String)TestInput.class.getName());
        if (payload != null) {
            desc.setUserPayload(payload);
        }
        return desc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int doRead() {
        boolean done = true;
        do {
            LinkedList events;
            done = true;
            AtomicInteger atomicInteger = this.inputReady;
            synchronized (atomicInteger) {
                while (this.inputReady.get() <= this.lastInputReadyValue) {
                    try {
                        LOG.info("Waiting for inputReady: " + this.inputReady.get() + " last: " + this.lastInputReadyValue);
                        this.inputReady.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                this.lastInputReadyValue = this.inputReady.get();
                LOG.info("Done for inputReady: " + this.lastInputReadyValue);
            }
            if (!this.doRandomFail) {
                if (!this.doFail) continue;
                if ((this.failingTaskIndices.contains(this.failAll) || this.failingTaskIndices.contains(this.getContext().getTaskIndex())) && (this.failingTaskAttempts.contains(this.failAll) || this.failingTaskAttempts.contains(this.getContext().getTaskAttemptNumber())) && this.lastInputReadyValue <= this.failingInputUpto) {
                    events = Lists.newLinkedList();
                    if (this.failingInputIndices.contains(this.failAll)) {
                        for (int i = 0; i < this.getNumPhysicalInputs(); ++i) {
                            String msg = "FailingInput: " + this.getContext().getUniqueIdentifier() + " index: " + i + " version: " + this.lastInputReadyValue;
                            events.add(InputReadErrorEvent.create((String)msg, (int)i, (int)this.lastInputReadyValue, (int)1, (boolean)false, (boolean)false, (String)"localhost"));
                            LOG.info("Failing input: " + msg);
                        }
                    } else {
                        for (Integer index : this.failingInputIndices) {
                            if (index >= this.getNumPhysicalInputs()) {
                                this.throwException("InputIndex: " + index + " should be less than numInputs: " + this.getNumPhysicalInputs());
                            }
                            if (this.completedInputVersion[index] < this.lastInputReadyValue) continue;
                            String msg = "FailingInput: " + this.getContext().getUniqueIdentifier() + " index: " + index + " version: " + this.lastInputReadyValue;
                            events.add(InputReadErrorEvent.create((String)msg, (int)index, (int)this.lastInputReadyValue, (int)1, (boolean)false, (boolean)false, (String)"localhost"));
                            LOG.info("Failing input: " + msg);
                        }
                    }
                    this.getContext().sendEvents((List)events);
                    if (this.doFailAndExit) {
                        String msg = "FailingInput exiting: " + this.getContext().getUniqueIdentifier();
                        LOG.info(msg);
                        this.throwException(msg);
                        continue;
                    }
                    try {
                        while (this.lastInputReadyValue == this.inputReady.get()) {
                            Thread.sleep(500L);
                            this.getContext().sendEvents((List)events);
                        }
                    }
                    catch (InterruptedException e) {
                        LOG.info("Interrupted while sending events", (Throwable)e);
                    }
                    done = false;
                    continue;
                }
                if (!this.failingTaskIndices.contains(this.failAll) && !this.failingTaskIndices.contains(this.getContext().getTaskIndex())) continue;
                boolean previousAttemptReadFailed = false;
                if (this.failingTaskAttempts.contains(this.failAll)) {
                    previousAttemptReadFailed = true;
                } else {
                    for (int i = 0; i < this.getContext().getTaskAttemptNumber(); ++i) {
                        if (!this.failingTaskAttempts.contains(new Integer(i))) continue;
                        previousAttemptReadFailed = true;
                        break;
                    }
                }
                if (!previousAttemptReadFailed || this.lastInputReadyValue > this.failingInputUpto) continue;
                LOG.info("Previous task attempt failed and input version less than failing upto version");
                done = false;
                continue;
            }
            events = Lists.newLinkedList();
            for (int index = 0; index < this.getNumPhysicalInputs(); ++index) {
                int sourceInputVersion = this.completedInputVersion[index];
                int maxFailedAttempt = this.conf.getInt("tez.am.task.max.failed.attempts", 4);
                if (sourceInputVersion >= maxFailedAttempt - 1) continue;
                float rollNumber = (float)Math.random();
                String msg = "FailingInput random fail turned on.Do a roll:" + this.getContext().getUniqueIdentifier() + " index: " + index + " version: " + sourceInputVersion + " rollNumber: " + rollNumber + " randomFailProbability " + this.randomFailProbability;
                LOG.info(msg);
                if (!(rollNumber < this.randomFailProbability)) continue;
                msg = "FailingInput: rollNumber < randomFailProbability. Do fail." + this.getContext().getUniqueIdentifier() + " index: " + index + " version: " + sourceInputVersion;
                LOG.info(msg);
                events.add(InputReadErrorEvent.create((String)msg, (int)index, (int)sourceInputVersion, (int)1, (boolean)false, (boolean)false, (String)"localhost"));
            }
            this.getContext().sendEvents((List)events);
        } while (!done);
        int sum = 0;
        for (int i = 0; i < this.getNumPhysicalInputs(); ++i) {
            if (this.inputValues[i] == -1) {
                this.throwException("Invalid input value : " + i);
            }
            sum += this.inputValues[i];
        }
        return sum;
    }

    void throwException(String msg) {
        RuntimeException e = new RuntimeException(msg);
        this.getContext().reportFailure(TaskFailureType.NON_FATAL, (Throwable)e, msg);
        throw e;
    }

    public static String getVertexConfName(String confName, String vertexName) {
        return confName + "." + vertexName;
    }

    public List<Event> initialize() throws Exception {
        this.getContext().requestInitialMemory(0L, null);
        this.getContext().inputIsReady();
        if (this.getContext().getUserPayload() != null && this.getContext().getUserPayload().hasPayload()) {
            String vName = this.getContext().getTaskVertexName();
            this.conf = TezUtils.createConfFromUserPayload((UserPayload)this.getContext().getUserPayload());
            this.doFail = this.conf.getBoolean(TestInput.getVertexConfName(TEZ_FAILING_INPUT_DO_FAIL, vName), false);
            this.doFailAndExit = this.conf.getBoolean(TestInput.getVertexConfName(TEZ_FAILING_INPUT_DO_FAIL_AND_EXIT, vName), false);
            LOG.info("doFail: " + this.doFail + " doFailAndExit: " + this.doFailAndExit);
            if (this.doFail) {
                for (String failingIndex : this.conf.getTrimmedStringCollection(TestInput.getVertexConfName(TEZ_FAILING_INPUT_FAILING_TASK_INDEX, vName))) {
                    LOG.info("Adding failing task index: " + failingIndex);
                    this.failingTaskIndices.add(Integer.valueOf(failingIndex));
                }
                for (String failingIndex : this.conf.getTrimmedStringCollection(TestInput.getVertexConfName(TEZ_FAILING_INPUT_FAILING_TASK_ATTEMPT, vName))) {
                    LOG.info("Adding failing task attempt: " + failingIndex);
                    this.failingTaskAttempts.add(Integer.valueOf(failingIndex));
                }
                this.failingInputUpto = this.conf.getInt(TestInput.getVertexConfName(TEZ_FAILING_INPUT_FAILING_UPTO_INPUT_ATTEMPT, vName), 0);
                LOG.info("Adding failing input upto: " + this.failingInputUpto);
                for (String failingIndex : this.conf.getTrimmedStringCollection(TestInput.getVertexConfName(TEZ_FAILING_INPUT_FAILING_INPUT_INDEX, vName))) {
                    LOG.info("Adding failing input index: " + failingIndex);
                    this.failingInputIndices.add(Integer.valueOf(failingIndex));
                }
            }
            this.doRandomFail = this.conf.getBoolean(TEZ_FAILING_INPUT_DO_RANDOM_FAIL, false);
            this.randomFailProbability = this.conf.getFloat(TEZ_FAILING_INPUT_RANDOM_FAIL_PROBABILITY, 0.0f);
            LOG.info("doRandomFail: " + this.doRandomFail);
            LOG.info("randomFailProbability: " + this.randomFailProbability);
        }
        return Collections.emptyList();
    }

    public void start() {
    }

    public Reader getReader() throws Exception {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(List<Event> inputEvents) throws Exception {
        for (Event event : inputEvents) {
            if (event instanceof DataMovementEvent) {
                DataMovementEvent dmEvent = (DataMovementEvent)event;
                ++this.numCompletedInputs;
                LOG.info(this.getContext().getInputOutputVertexNames() + " Received DataMovement event sourceId : " + dmEvent.getSourceIndex() + " targetId: " + dmEvent.getTargetIndex() + " version: " + dmEvent.getVersion() + " numInputs: " + this.getNumPhysicalInputs() + " numCompletedInputs: " + this.numCompletedInputs);
                this.completedInputVersion[dmEvent.getTargetIndex()] = dmEvent.getVersion();
                this.inputValues[dmEvent.getTargetIndex()] = dmEvent.getUserPayload().getInt();
                continue;
            }
            if (!(event instanceof InputFailedEvent)) continue;
            InputFailedEvent ifEvent = (InputFailedEvent)event;
            if (this.completedInputVersion[ifEvent.getTargetIndex()] == ifEvent.getVersion()) {
                --this.numCompletedInputs;
            }
            LOG.info("Received InputFailed event targetId: " + ifEvent.getTargetIndex() + " version: " + ifEvent.getVersion() + " numInputs: " + this.getNumPhysicalInputs() + " numCompletedInputs: " + this.numCompletedInputs);
        }
        if (this.numCompletedInputs == this.getNumPhysicalInputs()) {
            int maxInputVersionSeen = -1;
            for (int i = 0; i < this.getNumPhysicalInputs(); ++i) {
                if (this.completedInputVersion[i] < 0) {
                    LOG.info("Not received completion for input " + i);
                    return;
                }
                if (maxInputVersionSeen >= this.completedInputVersion[i]) continue;
                maxInputVersionSeen = this.completedInputVersion[i];
            }
            LOG.info("Received all inputs");
            AtomicInteger atomicInteger = this.inputReady;
            synchronized (atomicInteger) {
                this.inputReady.set(maxInputVersionSeen);
                LOG.info("Notifying done with " + maxInputVersionSeen);
                this.inputReady.notifyAll();
            }
        }
    }

    public List<Event> close() throws Exception {
        this.getContext().getCounters().findCounter(COUNTER_NAME, COUNTER_NAME).increment(1L);
        return null;
    }
}

