/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test.dag;

import java.io.IOException;
import java.util.function.BiConsumer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.tez.common.TezUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.Edge;
import org.apache.tez.dag.api.EdgeProperty;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.ProcessorDescriptor;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.Vertex;
import org.apache.tez.test.TestInput;
import org.apache.tez.test.TestOutput;
import org.apache.tez.test.TestProcessor;

public class FailingDagBuilder {
    private static final Resource DEFAULT_RESOURCE = Resource.newInstance((int)100, (int)0);
    private final Levels levels;
    private String name;
    private Configuration conf;

    public FailingDagBuilder(Levels levels) {
        this.levels = levels;
        this.name = levels.defaultName;
    }

    public FailingDagBuilder withConf(Configuration config) {
        this.conf = config;
        return this;
    }

    public FailingDagBuilder withName(String dagName) {
        this.name = dagName;
        return this;
    }

    public DAG build() throws IOException {
        UserPayload payload = UserPayload.create(null);
        if (this.conf != null) {
            payload = TezUtils.createUserPayloadFromConf((Configuration)this.conf);
        }
        DAG dag = DAG.create((String)this.name);
        this.levels.levelAdder.accept(dag, payload);
        return dag;
    }

    public static enum Levels {
        TWO("TwoLevelsFailingDAG", (dag, payload) -> {
            Vertex l1v1 = Vertex.create((String)"l1v1", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)1, (Resource)DEFAULT_RESOURCE);
            Vertex l2v1 = Vertex.create((String)"l2v1", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)1, (Resource)DEFAULT_RESOURCE);
            Levels.addVerticesAndEdgeInternal(dag, l1v1, l2v1, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Vertex l1v2 = Vertex.create((String)"l1v2", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)2, (Resource)DEFAULT_RESOURCE);
            Vertex l2v2 = Vertex.create((String)"l2v2", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)3, (Resource)DEFAULT_RESOURCE);
            Levels.addVerticesAndEdgeInternal(dag, l1v2, l2v2, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Vertex l1v3 = Vertex.create((String)"l1v3", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)3, (Resource)DEFAULT_RESOURCE);
            Vertex l2v3 = Vertex.create((String)"l2v3", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)2, (Resource)DEFAULT_RESOURCE);
            Levels.addVerticesAndEdgeInternal(dag, l1v3, l2v3, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Vertex l1v4 = Vertex.create((String)"l1v4", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)2, (Resource)DEFAULT_RESOURCE);
            Vertex l2v4 = Vertex.create((String)"l2v4", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)3, (Resource)DEFAULT_RESOURCE);
            Levels.addVerticesAndEdgeInternal(dag, l1v4, l2v4, EdgeProperty.DataMovementType.BROADCAST, payload);
        }),
        THREE("ThreeLevelsFailingDAG", (dag, payload) -> {
            Levels.TWO.levelAdder.accept((DAG)dag, (UserPayload)payload);
            Vertex l3v1 = Vertex.create((String)"l3v1", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)4, (Resource)DEFAULT_RESOURCE);
            dag.addVertex(l3v1);
            Levels.addEdge(dag, dag.getVertex("l2v1"), l3v1, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Levels.addEdge(dag, dag.getVertex("l2v2"), l3v1, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Vertex l3v2 = Vertex.create((String)"l3v2", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)4, (Resource)DEFAULT_RESOURCE);
            dag.addVertex(l3v2);
            Levels.addEdge(dag, dag.getVertex("l2v2"), l3v2, EdgeProperty.DataMovementType.BROADCAST, payload);
            Levels.addEdge(dag, dag.getVertex("l2v3"), l3v2, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Levels.addEdge(dag, dag.getVertex("l2v4"), l3v2, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
        }),
        SIX("SixLevelsFailingDAG", (dag, payload) -> {
            Levels.THREE.levelAdder.accept((DAG)dag, (UserPayload)payload);
            Vertex l4v1 = Vertex.create((String)"l4v1", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)10, (Resource)DEFAULT_RESOURCE);
            dag.addVertex(l4v1);
            Levels.addEdge(dag, dag.getVertex("l3v1"), l4v1, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Levels.addEdge(dag, dag.getVertex("l3v2"), l4v1, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Vertex l5v1 = Vertex.create((String)"l5v1", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)2, (Resource)DEFAULT_RESOURCE);
            dag.addVertex(l5v1);
            Levels.addEdge(dag, l4v1, l5v1, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Vertex l5v2 = Vertex.create((String)"l5v2", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)4, (Resource)DEFAULT_RESOURCE);
            dag.addVertex(l5v2);
            Levels.addEdge(dag, l4v1, l5v2, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Vertex l5v3 = Vertex.create((String)"l5v3", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)1, (Resource)DEFAULT_RESOURCE);
            dag.addVertex(l5v3);
            Levels.addEdge(dag, l4v1, l5v3, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Vertex l6v1 = Vertex.create((String)"l6v1", (ProcessorDescriptor)TestProcessor.getProcDesc(payload), (int)4, (Resource)DEFAULT_RESOURCE);
            dag.addVertex(l6v1);
            Levels.addEdge(dag, l5v1, l6v1, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Levels.addEdge(dag, l5v2, l6v1, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
            Levels.addEdge(dag, l5v3, l6v1, EdgeProperty.DataMovementType.SCATTER_GATHER, payload);
        });

        private final String defaultName;
        private final BiConsumer<DAG, UserPayload> levelAdder;

        private Levels(String defaultName, BiConsumer<DAG, UserPayload> levelAdder) {
            this.defaultName = defaultName;
            this.levelAdder = levelAdder;
        }

        private static void addVerticesAndEdgeInternal(DAG dag, Vertex v1, Vertex v2, EdgeProperty.DataMovementType dataMovementType, UserPayload payload) {
            dag.addVertex(v1).addVertex(v2);
            Levels.addEdge(dag, v1, v2, dataMovementType, payload);
        }

        private static void addEdge(DAG dag, Vertex v1, Vertex v2, EdgeProperty.DataMovementType dataMovementType, UserPayload payload) {
            dag.addEdge(Edge.create((Vertex)v1, (Vertex)v2, (EdgeProperty)EdgeProperty.create((EdgeProperty.DataMovementType)dataMovementType, (EdgeProperty.DataSourceType)EdgeProperty.DataSourceType.PERSISTED, (EdgeProperty.SchedulingType)EdgeProperty.SchedulingType.SEQUENTIAL, (OutputDescriptor)TestOutput.getOutputDesc(payload), (InputDescriptor)TestInput.getInputDesc(payload))));
        }
    }
}

