/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.tez.client.TezClient;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSinkDescriptor;
import org.apache.tez.dag.api.OutputCommitterDescriptor;
import org.apache.tez.dag.api.OutputDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.UserPayload;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.test.MiniTezCluster;
import org.apache.tez.test.dag.MultiAttemptDAG;
import org.apache.tez.test.dag.SimpleVTestDAG;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDAGRecovery2 {
    private static final Logger LOG = LoggerFactory.getLogger(TestDAGRecovery2.class);
    private static Configuration conf = new Configuration();
    private static MiniTezCluster miniTezCluster = null;
    private static String TEST_ROOT_DIR = "target/" + TestDAGRecovery2.class.getName() + "-tmpDir";
    private static MiniDFSCluster dfsCluster = null;
    private static TezClient tezSession = null;
    private static FileSystem remoteFs = null;

    @BeforeClass
    public static void beforeClass() throws Exception {
        LOG.info("Starting mini clusters");
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (miniTezCluster == null) {
            miniTezCluster = new MiniTezCluster(TestDAGRecovery2.class.getName(), 1, 1, 1);
            Configuration miniTezconf = new Configuration(conf);
            miniTezconf.setInt("yarn.resourcemanager.am.max-attempts", 4);
            miniTezconf.set("fs.defaultFS", remoteFs.getUri().toString());
            miniTezCluster.init(miniTezconf);
            miniTezCluster.start();
        }
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        if (tezSession != null) {
            try {
                LOG.info("Stopping Tez Session");
                tezSession.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (miniTezCluster != null) {
            try {
                LOG.info("Stopping MiniTezCluster");
                miniTezCluster.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (dfsCluster != null) {
            try {
                LOG.info("Stopping DFSCluster");
                dfsCluster.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private TezConfiguration createSessionConfig(Path remoteStagingDir) {
        TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
        tezConf.setInt("tez.dag.recovery.max.unflushed.events", 10);
        tezConf.set("tez.am.log.level", "DEBUG");
        tezConf.set("tez.staging-dir", remoteStagingDir.toString());
        tezConf.setBoolean("tez.am.node-blacklisting.enabled", false);
        tezConf.setInt("tez.am.max.app.attempts", 4);
        tezConf.setInt("tez.am.resource.memory.mb", 500);
        tezConf.set("tez.am.launch.cmd-opts", " -Xmx256m");
        tezConf.setBoolean("tez.am.mode.session", true);
        return tezConf;
    }

    @Before
    public void setup() throws Exception {
        Path remoteStagingDir = remoteFs.makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
        TezClientUtils.ensureStagingDirExists((Configuration)conf, (Path)remoteStagingDir);
        TezConfiguration tezConf = this.createSessionConfig(remoteStagingDir);
        tezSession = TezClient.create((String)"TestDAGRecovery2", (TezConfiguration)tezConf);
        tezSession.start();
    }

    @After
    public void teardown() throws InterruptedException {
        if (tezSession != null) {
            try {
                LOG.info("Stopping Tez Session");
                tezSession.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        tezSession = null;
    }

    void runDAGAndVerify(DAG dag, DAGStatus.State finalState) throws Exception {
        this.runDAGAndVerify(dag, finalState, tezSession);
    }

    void runDAGAndVerify(DAG dag, DAGStatus.State finalState, TezClient session) throws Exception {
        session.waitTillReady();
        DAGClient dagClient = session.submitDAG(dag);
        DAGStatus dagStatus = dagClient.getDAGStatus(null);
        while (!dagStatus.isCompleted()) {
            LOG.info("Waiting for dag to complete. Sleeping for 500ms. DAG name: " + dag.getName() + " DAG appContext: " + dagClient.getExecutionContext() + " Current state: " + dagStatus.getState());
            Thread.sleep(100L);
            dagStatus = dagClient.getDAGStatus(null);
        }
        Assert.assertEquals((Object)finalState, (Object)dagStatus.getState());
    }

    @Test(timeout=120000L)
    public void testFailingCommitter() throws Exception {
        DAG dag = SimpleVTestDAG.createDAG("FailingCommitterDAG", null);
        OutputDescriptor od = OutputDescriptor.create((String)MultiAttemptDAG.NoOpOutput.class.getName());
        od.setUserPayload(UserPayload.create((ByteBuffer)ByteBuffer.wrap(new MultiAttemptDAG.FailingOutputCommitter.FailingOutputCommitterConfig(true).toUserPayload())));
        OutputCommitterDescriptor ocd = OutputCommitterDescriptor.create((String)MultiAttemptDAG.FailingOutputCommitter.class.getName());
        dag.getVertex("v3").addDataSink("FailingOutput", DataSinkDescriptor.create((OutputDescriptor)od, (OutputCommitterDescriptor)ocd, null));
        this.runDAGAndVerify(dag, DAGStatus.State.FAILED);
    }

    @Test(timeout=120000L)
    public void testSessionDisableMultiAttempts() throws Exception {
        tezSession.stop();
        Path remoteStagingDir = remoteFs.makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
        TezClientUtils.ensureStagingDirExists((Configuration)conf, (Path)remoteStagingDir);
        TezConfiguration tezConf = this.createSessionConfig(remoteStagingDir);
        tezConf.setBoolean("tez.am.mode.session", true);
        tezConf.setBoolean("tez.dag.recovery.enabled", false);
        TezClient session = TezClient.create((String)"TestDAGRecovery2SingleAttemptOnly", (TezConfiguration)tezConf);
        session.start();
        DAG dag = MultiAttemptDAG.createDAG("TestSingleAttemptDAG", null);
        this.runDAGAndVerify(dag, DAGStatus.State.FAILED, session);
        session.stop();
    }
}

