/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.tez.common.counters.TezCounters;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.oldrecords.TaskState;
import org.apache.tez.dag.app.RecoveryParser;
import org.apache.tez.dag.app.dag.DAGState;
import org.apache.tez.dag.app.dag.VertexState;
import org.apache.tez.dag.app.dag.impl.VertexStats;
import org.apache.tez.dag.history.HistoryEvent;
import org.apache.tez.dag.history.HistoryEventType;
import org.apache.tez.dag.history.events.DAGFinishedEvent;
import org.apache.tez.dag.history.events.DAGInitializedEvent;
import org.apache.tez.dag.history.events.DAGStartedEvent;
import org.apache.tez.dag.history.events.TaskAttemptStartedEvent;
import org.apache.tez.dag.history.events.TaskFinishedEvent;
import org.apache.tez.dag.history.events.TaskStartedEvent;
import org.apache.tez.dag.history.events.VertexConfigurationDoneEvent;
import org.apache.tez.dag.history.events.VertexFinishedEvent;
import org.apache.tez.dag.history.events.VertexInitializedEvent;
import org.apache.tez.dag.history.events.VertexStartedEvent;
import org.apache.tez.dag.records.TezDAGID;
import org.apache.tez.dag.records.TezTaskAttemptID;
import org.apache.tez.dag.records.TezTaskID;
import org.apache.tez.dag.records.TezVertexID;
import org.apache.tez.examples.HashJoinExample;
import org.apache.tez.examples.OrderedWordCount;
import org.apache.tez.runtime.api.Event;
import org.apache.tez.runtime.api.events.InputDataInformationEvent;
import org.apache.tez.runtime.api.impl.TezEvent;
import org.apache.tez.test.MiniTezCluster;
import org.apache.tez.test.RecoveryServiceWithEventHandlingHook;
import org.apache.tez.test.TestTezJobs;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestRecovery {
    private static final Logger LOG = LoggerFactory.getLogger(TestRecovery.class);
    private static Configuration conf = new Configuration();
    private static MiniTezCluster miniTezCluster = null;
    private static String TEST_ROOT_DIR = "target/" + TestRecovery.class.getName() + "-tmpDir";
    private static MiniDFSCluster dfsCluster = null;
    private static FileSystem remoteFs = null;

    @BeforeClass
    public static void beforeClass() throws Exception {
        LOG.info("Starting mini clusters");
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (miniTezCluster == null) {
            miniTezCluster = new MiniTezCluster(TestRecovery.class.getName(), 1, 1, 1);
            Configuration miniTezconf = new Configuration(conf);
            miniTezconf.setInt("yarn.resourcemanager.am.max-attempts", 4);
            miniTezconf.set("fs.defaultFS", remoteFs.getUri().toString());
            miniTezCluster.init(miniTezconf);
            miniTezCluster.start();
        }
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        if (miniTezCluster != null) {
            try {
                LOG.info("Stopping MiniTezCluster");
                miniTezCluster.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (dfsCluster != null) {
            try {
                LOG.info("Stopping DFSCluster");
                dfsCluster.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Test(timeout=1800000L)
    public void testRecovery_OrderedWordCount() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexId0 = TezVertexID.getInstance((TezDAGID)dagId, (int)0);
        TezVertexID vertexId1 = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        TezVertexID vertexId2 = TezVertexID.getInstance((TezDAGID)dagId, (int)2);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), (int)1);
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)10);
        ArrayList initGeneratedEvents = Lists.newArrayList((Object[])new TezEvent[]{new TezEvent((Event)InputDataInformationEvent.createWithObjectPayload((int)0, (Object)new Object()), null)});
        ArrayList shutdownConditions = Lists.newArrayList((Object[])new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition[]{new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new DAGInitializedEvent(dagId, 0L, "username", "dagName", null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new DAGStartedEvent(dagId, 0L, "username", "dagName")), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new DAGFinishedEvent(dagId, 0L, 0L, DAGState.SUCCEEDED, "", new TezCounters(), "username", "dagName", new HashMap(), ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexInitializedEvent(vertexId0, "Tokenizer", 0L, 0L, 0, "", null, (List)initGeneratedEvents, null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexInitializedEvent(vertexId1, "Summation", 0L, 0L, 0, "", null, null, null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexInitializedEvent(vertexId2, "Sorter", 0L, 0L, 0, "", null, null, null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexConfigurationDoneEvent(vertexId0, 0L, 2, null, null, null, true)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexConfigurationDoneEvent(vertexId1, 0L, 2, null, null, null, true)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexConfigurationDoneEvent(vertexId2, 0L, 2, null, null, null, true)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexStartedEvent(vertexId0, 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexStartedEvent(vertexId1, 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexStartedEvent(vertexId2, 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexFinishedEvent(vertexId0, "vertexName", 1, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", new TezCounters(), new VertexStats(), new HashMap(), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexFinishedEvent(vertexId1, "vertexName", 1, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", new TezCounters(), new VertexStats(), new HashMap(), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexFinishedEvent(vertexId2, "vertexName", 1, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", new TezCounters(), new VertexStats(), new HashMap(), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)vertexId0, (int)0), "vertexName", 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)vertexId1, (int)0), "vertexName", 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)vertexId2, (int)0), "vertexName", 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)vertexId0, (int)0), "vertexName", 0L, 0L, null, TaskState.SUCCEEDED, "", new TezCounters(), 0)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)vertexId1, (int)0), "vertexName", 0L, 0L, null, TaskState.SUCCEEDED, "", new TezCounters(), 0)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)vertexId2, (int)0), "vertexName", 0L, 0L, null, TaskState.SUCCEEDED, "", new TezCounters(), 0)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexId0, (int)0), (int)0), "vertexName", 0L, containerId, nodeId, "", "", "")), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexId1, (int)0), (int)0), "vertexName", 0L, containerId, nodeId, "", "", "")), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexId2, (int)0), (int)0), "vertexName", 0L, containerId, nodeId, "", "", ""))});
        Random rand = new Random();
        for (int i = 0; i < shutdownConditions.size(); ++i) {
            if (!(rand.nextDouble() < 0.5)) continue;
            this.testOrderedWordCount((RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition)shutdownConditions.get(i), true, ((RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition)shutdownConditions.get(i)).getHistoryEvent().getEventType() == HistoryEventType.VERTEX_STARTED);
        }
    }

    private void testOrderedWordCount(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition shutdownCondition, boolean enableAutoParallelism, boolean generateSplitInClient) throws Exception {
        LOG.info("shutdownCondition:" + shutdownCondition.getEventType() + ", event=" + shutdownCondition.getEvent());
        String inputDirStr = "/tmp/owc-input/";
        Path inputDir = new Path(inputDirStr);
        Path stagingDirPath = new Path("/tmp/owc-staging-dir");
        remoteFs.mkdirs(inputDir);
        remoteFs.mkdirs(stagingDirPath);
        TestTezJobs.generateOrderedWordCountInput(inputDir, remoteFs);
        String outputDirStr = "/tmp/owc-output/";
        Path outputDir = new Path(outputDirStr);
        TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
        tezConf.setInt("tez.am.max.app.attempts", 4);
        tezConf.set("tez.test.recovery-service-class", RecoveryServiceWithEventHandlingHook.class.getName());
        tezConf.set("tez.test.am.recovery_service.hook", RecoveryServiceWithEventHandlingHook.SimpleRecoveryEventHook.class.getName());
        tezConf.set("tez.test.recovery.simple_shutdown_condition", shutdownCondition.serialize());
        tezConf.setBoolean("tez.shuffle-vertex-manager.enable.auto-parallel", enableAutoParallelism);
        tezConf.setBoolean("tez.test.recovery.drain_event", false);
        tezConf.set("tez.staging-dir", stagingDirPath.toString());
        tezConf.setBoolean("tez.am.staging.scratch-data.auto-delete", false);
        tezConf.set("tez.am.log.level", "INFO;org.apache.tez=DEBUG");
        OrderedWordCount job = new OrderedWordCount();
        if (generateSplitInClient) {
            Assert.assertTrue((String)"OrderedWordCount failed", (job.run(tezConf, new String[]{"-generateSplitInClient", inputDirStr, outputDirStr, "5"}, null) == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"OrderedWordCount failed", (job.run(tezConf, new String[]{inputDirStr, outputDirStr, "5"}, null) == 0 ? 1 : 0) != 0);
        }
        TestTezJobs.verifyOutput(outputDir, remoteFs);
        List historyEventsOfAttempt1 = RecoveryParser.readRecoveryEvents((TezConfiguration)tezConf, (ApplicationId)job.getAppId(), (int)1);
        HistoryEvent lastEvent = (HistoryEvent)historyEventsOfAttempt1.get(historyEventsOfAttempt1.size() - 1);
        Assert.assertEquals((Object)shutdownCondition.getEvent().getEventType(), (Object)lastEvent.getEventType());
        Assert.assertTrue((boolean)shutdownCondition.match(lastEvent));
    }

    private void testOrderedWordCountMultipleRoundRecoverying(RecoveryServiceWithEventHandlingHook.MultipleRoundShutdownCondition shutdownCondition, boolean enableAutoParallelism, boolean generateSplitInClient) throws Exception {
        for (int i = 0; i < shutdownCondition.size(); ++i) {
            RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition condition = shutdownCondition.getSimpleShutdownCondition(i);
            LOG.info("ShutdownCondition:" + condition.getEventType() + ", event=" + condition.getEvent());
        }
        String inputDirStr = "/tmp/owc-input/";
        Path inputDir = new Path(inputDirStr);
        Path stagingDirPath = new Path("/tmp/owc-staging-dir");
        remoteFs.mkdirs(inputDir);
        remoteFs.mkdirs(stagingDirPath);
        TestTezJobs.generateOrderedWordCountInput(inputDir, remoteFs);
        String outputDirStr = "/tmp/owc-output/";
        Path outputDir = new Path(outputDirStr);
        TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
        tezConf.setInt("tez.am.max.app.attempts", 4);
        tezConf.set("tez.test.recovery-service-class", RecoveryServiceWithEventHandlingHook.class.getName());
        tezConf.set("tez.test.am.recovery_service.hook", RecoveryServiceWithEventHandlingHook.MultipleRoundRecoveryEventHook.class.getName());
        tezConf.set("tez.test.recovery.multiple_round_shutdown_condition", shutdownCondition.serialize());
        tezConf.setBoolean("tez.shuffle-vertex-manager.enable.auto-parallel", enableAutoParallelism);
        tezConf.setBoolean("tez.test.recovery.drain_event", false);
        tezConf.set("tez.staging-dir", stagingDirPath.toString());
        tezConf.setBoolean("tez.am.staging.scratch-data.auto-delete", false);
        OrderedWordCount job = new OrderedWordCount();
        if (generateSplitInClient) {
            Assert.assertTrue((String)"OrderedWordCount failed", (job.run(tezConf, new String[]{"-generateSplitInClient", inputDirStr, outputDirStr, "5"}, null) == 0 ? 1 : 0) != 0);
        } else {
            Assert.assertTrue((String)"OrderedWordCount failed", (job.run(tezConf, new String[]{inputDirStr, outputDirStr, "5"}, null) == 0 ? 1 : 0) != 0);
        }
        TestTezJobs.verifyOutput(outputDir, remoteFs);
    }

    @Test(timeout=1800000L)
    public void testRecovery_HashJoin() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexId0 = TezVertexID.getInstance((TezDAGID)dagId, (int)0);
        TezVertexID vertexId1 = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        TezVertexID vertexId2 = TezVertexID.getInstance((TezDAGID)dagId, (int)2);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), (int)1);
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)10);
        ArrayList initGeneratedEvents = Lists.newArrayList((Object[])new TezEvent[]{new TezEvent((Event)InputDataInformationEvent.createWithObjectPayload((int)0, (Object)new Object()), null)});
        ArrayList shutdownConditions = Lists.newArrayList((Object[])new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition[]{new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new DAGInitializedEvent(dagId, 0L, "username", "dagName", null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new DAGStartedEvent(dagId, 0L, "username", "dagName")), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new DAGFinishedEvent(dagId, 0L, 0L, DAGState.SUCCEEDED, "", new TezCounters(), "username", "dagName", new HashMap(), ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexInitializedEvent(vertexId0, "hashSide", 0L, 0L, 0, "", null, (List)initGeneratedEvents, null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexInitializedEvent(vertexId1, "streamingSide", 0L, 0L, 0, "", null, null, null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexInitializedEvent(vertexId2, "joiner", 0L, 0L, 0, "", null, null, null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexStartedEvent(vertexId0, 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexStartedEvent(vertexId1, 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexStartedEvent(vertexId2, 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexConfigurationDoneEvent(vertexId0, 0L, 2, null, null, null, true)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexConfigurationDoneEvent(vertexId1, 0L, 2, null, null, null, true)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexConfigurationDoneEvent(vertexId2, 0L, 2, null, null, null, true)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexFinishedEvent(vertexId0, "vertexName", 1, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", new TezCounters(), new VertexStats(), new HashMap(), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexFinishedEvent(vertexId1, "vertexName", 1, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", new TezCounters(), new VertexStats(), new HashMap(), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexFinishedEvent(vertexId2, "vertexName", 1, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", new TezCounters(), new VertexStats(), new HashMap(), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)vertexId0, (int)0), "vertexName", 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)vertexId1, (int)0), "vertexName", 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)vertexId2, (int)0), "vertexName", 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)vertexId0, (int)0), "vertexName", 0L, 0L, null, TaskState.SUCCEEDED, "", new TezCounters(), 0)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)vertexId1, (int)0), "vertexName", 0L, 0L, null, TaskState.SUCCEEDED, "", new TezCounters(), 0)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)vertexId2, (int)0), "vertexName", 0L, 0L, null, TaskState.SUCCEEDED, "", new TezCounters(), 0)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexId0, (int)0), (int)0), "vertexName", 0L, containerId, nodeId, "", "", "")), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexId1, (int)0), (int)0), "vertexName", 0L, containerId, nodeId, "", "", "")), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexId2, (int)0), (int)0), "vertexName", 0L, containerId, nodeId, "", "", ""))});
        Random rand = new Random();
        for (int i = 0; i < shutdownConditions.size(); ++i) {
            if (!(rand.nextDouble() < 0.5)) continue;
            this.testHashJoinExample((RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition)shutdownConditions.get(i), true, ((RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition)shutdownConditions.get(i)).getHistoryEvent().getEventType() == HistoryEventType.VERTEX_STARTED);
        }
    }

    private void testHashJoinExample(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition shutdownCondition, boolean enableAutoParallelism, boolean generateSplitInClient) throws Exception {
        String line;
        HashJoinExample hashJoinExample = new HashJoinExample();
        TezConfiguration tezConf = new TezConfiguration(miniTezCluster.getConfig());
        tezConf.setInt("tez.am.max.app.attempts", 4);
        tezConf.set("tez.test.recovery-service-class", RecoveryServiceWithEventHandlingHook.class.getName());
        tezConf.set("tez.test.am.recovery_service.hook", RecoveryServiceWithEventHandlingHook.SimpleRecoveryEventHook.class.getName());
        tezConf.set("tez.test.recovery.simple_shutdown_condition", shutdownCondition.serialize());
        tezConf.setBoolean("tez.shuffle-vertex-manager.enable.auto-parallel", enableAutoParallelism);
        tezConf.setBoolean("tez.test.recovery.drain_event", false);
        tezConf.setBoolean("tez.am.staging.scratch-data.auto-delete", false);
        tezConf.set("tez.am.log.level", "INFO;org.apache.tez=DEBUG");
        hashJoinExample.setConf((Configuration)tezConf);
        Path stagingDirPath = new Path("/tmp/tez-staging-dir");
        Path inPath1 = new Path("/tmp/hashJoin/inPath1");
        Path inPath2 = new Path("/tmp/hashJoin/inPath2");
        Path outPath = new Path("/tmp/hashJoin/outPath");
        remoteFs.delete(outPath, true);
        remoteFs.mkdirs(inPath1);
        remoteFs.mkdirs(inPath2);
        remoteFs.mkdirs(stagingDirPath);
        HashSet<String> expectedResult = new HashSet<String>();
        FSDataOutputStream out1 = remoteFs.create(new Path(inPath1, "file"));
        FSDataOutputStream out2 = remoteFs.create(new Path(inPath2, "file"));
        BufferedWriter writer1 = new BufferedWriter(new OutputStreamWriter((OutputStream)out1));
        BufferedWriter writer2 = new BufferedWriter(new OutputStreamWriter((OutputStream)out2));
        for (int i = 0; i < 20; ++i) {
            String term = "term" + i;
            writer1.write(term);
            writer1.newLine();
            if (i % 2 != 0) continue;
            writer2.write(term);
            writer2.newLine();
            expectedResult.add(term);
        }
        writer1.close();
        writer2.close();
        out1.close();
        out2.close();
        String[] args = null;
        args = generateSplitInClient ? new String[]{"-Dtez.staging-dir=" + stagingDirPath.toString(), "-generateSplitInClient", inPath1.toString(), inPath2.toString(), "1", outPath.toString()} : new String[]{"-Dtez.staging-dir=" + stagingDirPath.toString(), inPath1.toString(), inPath2.toString(), "1", outPath.toString()};
        Assert.assertEquals((long)0L, (long)hashJoinExample.run(args));
        FileStatus[] statuses = remoteFs.listStatus(outPath, new PathFilter(){

            public boolean accept(Path p) {
                String name = p.getName();
                return !name.startsWith("_") && !name.startsWith(".");
            }
        });
        Assert.assertEquals((long)1L, (long)statuses.length);
        FSDataInputStream inStream = remoteFs.open(statuses[0].getPath());
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)inStream));
        while ((line = reader.readLine()) != null) {
            Assert.assertTrue((boolean)expectedResult.remove(line));
        }
        reader.close();
        inStream.close();
        Assert.assertEquals((long)0L, (long)expectedResult.size());
        List historyEventsOfAttempt1 = RecoveryParser.readRecoveryEvents((TezConfiguration)tezConf, (ApplicationId)hashJoinExample.getAppId(), (int)1);
        HistoryEvent lastEvent = (HistoryEvent)historyEventsOfAttempt1.get(historyEventsOfAttempt1.size() - 1);
        Assert.assertEquals((Object)shutdownCondition.getEvent().getEventType(), (Object)lastEvent.getEventType());
        Assert.assertTrue((boolean)shutdownCondition.match(lastEvent));
    }

    @Test(timeout=1800000L)
    public void testTwoRoundsRecoverying() throws Exception {
        ApplicationId appId = ApplicationId.newInstance((long)System.currentTimeMillis(), (int)1);
        TezDAGID dagId = TezDAGID.getInstance((ApplicationId)appId, (int)1);
        TezVertexID vertexId0 = TezVertexID.getInstance((TezDAGID)dagId, (int)0);
        TezVertexID vertexId1 = TezVertexID.getInstance((TezDAGID)dagId, (int)1);
        TezVertexID vertexId2 = TezVertexID.getInstance((TezDAGID)dagId, (int)2);
        ContainerId containerId = ContainerId.newInstance((ApplicationAttemptId)ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), (int)1);
        NodeId nodeId = NodeId.newInstance((String)"localhost", (int)10);
        ArrayList initGeneratedEvents = Lists.newArrayList((Object[])new TezEvent[]{new TezEvent((Event)InputDataInformationEvent.createWithObjectPayload((int)0, (Object)new Object()), null)});
        ArrayList shutdownConditions = Lists.newArrayList((Object[])new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition[]{new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new DAGInitializedEvent(dagId, 0L, "username", "dagName", null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new DAGStartedEvent(dagId, 0L, "username", "dagName")), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexInitializedEvent(vertexId0, "Tokenizer", 0L, 0L, 0, "", null, (List)initGeneratedEvents, null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexStartedEvent(vertexId0, 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexConfigurationDoneEvent(vertexId0, 0L, 2, null, null, null, true)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskStartedEvent(TezTaskID.getInstance((TezVertexID)vertexId0, (int)0), "vertexName", 0L, 0L)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskAttemptStartedEvent(TezTaskAttemptID.getInstance((TezTaskID)TezTaskID.getInstance((TezVertexID)vertexId0, (int)0), (int)0), "vertexName", 0L, containerId, nodeId, "", "", "")), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new TaskFinishedEvent(TezTaskID.getInstance((TezVertexID)vertexId0, (int)0), "vertexName", 0L, 0L, null, TaskState.SUCCEEDED, "", new TezCounters(), 0)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexFinishedEvent(vertexId0, "vertexName", 1, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", new TezCounters(), new VertexStats(), new HashMap(), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexFinishedEvent(vertexId1, "vertexName", 1, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", new TezCounters(), new VertexStats(), new HashMap(), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new VertexFinishedEvent(vertexId2, "vertexName", 1, 0L, 0L, 0L, 0L, 0L, VertexState.SUCCEEDED, "", new TezCounters(), new VertexStats(), new HashMap(), null)), new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition.TIMING.POST, (HistoryEvent)new DAGFinishedEvent(dagId, 0L, 0L, DAGState.SUCCEEDED, "", new TezCounters(), "username", "dagName", new HashMap(), ApplicationAttemptId.newInstance((ApplicationId)appId, (int)1), null))});
        Random rand = new Random();
        for (int i = 0; i < shutdownConditions.size() - 1; ++i) {
            int nextSimpleConditionIndex;
            if (!(rand.nextDouble() < 0.5) || (nextSimpleConditionIndex = i + 1 + rand.nextInt(shutdownConditions.size() - i - 1)) != shutdownConditions.size() - 1) continue;
            this.testOrderedWordCountMultipleRoundRecoverying(new RecoveryServiceWithEventHandlingHook.MultipleRoundShutdownCondition(Lists.newArrayList((Object[])new RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition[]{(RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition)shutdownConditions.get(i), (RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition)shutdownConditions.get(nextSimpleConditionIndex)})), true, ((RecoveryServiceWithEventHandlingHook.SimpleShutdownCondition)shutdownConditions.get(i)).getHistoryEvent().getEventType() == HistoryEventType.VERTEX_STARTED);
        }
    }
}

