/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.test;

import java.io.IOException;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.tez.client.TezClient;
import org.apache.tez.client.TezClientUtils;
import org.apache.tez.dag.api.DAG;
import org.apache.tez.dag.api.DataSourceDescriptor;
import org.apache.tez.dag.api.InputDescriptor;
import org.apache.tez.dag.api.InputInitializerDescriptor;
import org.apache.tez.dag.api.TezConfiguration;
import org.apache.tez.dag.api.client.DAGClient;
import org.apache.tez.dag.api.client.DAGStatus;
import org.apache.tez.test.MiniTezCluster;
import org.apache.tez.test.dag.MultiAttemptDAG;
import org.apache.tez.test.dag.SimpleVTestDAG;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestDAGRecovery {
    private static final Logger LOG = LoggerFactory.getLogger(TestDAGRecovery.class);
    private static Configuration conf = new Configuration();
    private static MiniTezCluster miniTezCluster = null;
    private static String TEST_ROOT_DIR = "target/" + TestDAGRecovery.class.getName() + "-tmpDir";
    private static MiniDFSCluster dfsCluster = null;
    private static TezClient tezSession = null;
    private static FileSystem remoteFs = null;
    private static TezConfiguration tezConf = null;

    @BeforeClass
    public static void beforeClass() throws Exception {
        LOG.info("Starting mini clusters");
        try {
            conf.set("hdfs.minidfs.basedir", TEST_ROOT_DIR);
            dfsCluster = new MiniDFSCluster.Builder(conf).numDataNodes(3).format(true).racks(null).build();
            remoteFs = dfsCluster.getFileSystem();
        }
        catch (IOException io) {
            throw new RuntimeException("problem starting mini dfs cluster", io);
        }
        if (miniTezCluster == null) {
            miniTezCluster = new MiniTezCluster(TestDAGRecovery.class.getName(), 1, 1, 1);
            Configuration miniTezconf = new Configuration(conf);
            miniTezconf.setInt("yarn.resourcemanager.am.max-attempts", 4);
            miniTezconf.set("fs.defaultFS", remoteFs.getUri().toString());
            miniTezconf.setLong("tez.am.sleep.time.before.exit.millis", 500L);
            miniTezCluster.init(miniTezconf);
            miniTezCluster.start();
        }
    }

    @AfterClass
    public static void afterClass() throws InterruptedException {
        if (tezSession != null) {
            try {
                LOG.info("Stopping Tez Session");
                tezSession.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (miniTezCluster != null) {
            try {
                LOG.info("Stopping MiniTezCluster");
                miniTezCluster.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (dfsCluster != null) {
            try {
                LOG.info("Stopping DFSCluster");
                dfsCluster.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Before
    public void setup() throws Exception {
        LOG.info("Starting session");
        Path remoteStagingDir = remoteFs.makeQualified(new Path(TEST_ROOT_DIR, String.valueOf(new Random().nextInt(100000))));
        TezClientUtils.ensureStagingDirExists((Configuration)conf, (Path)remoteStagingDir);
        tezConf = new TezConfiguration(miniTezCluster.getConfig());
        tezConf.setInt("tez.dag.recovery.max.unflushed.events", 0);
        tezConf.set("tez.am.log.level", "INFO");
        tezConf.set("tez.staging-dir", remoteStagingDir.toString());
        tezConf.setBoolean("tez.am.node-blacklisting.enabled", false);
        tezConf.setInt("tez.am.max.app.attempts", 4);
        tezConf.setInt("tez.am.resource.memory.mb", 500);
        tezConf.set("tez.am.launch.cmd-opts", " -Xmx256m");
        tezConf.setBoolean("tez.am.mode.session", true);
        tezConf.set("tez.am.staging.scratch-data.auto-delete", "false");
        tezSession = TezClient.create((String)"TestDAGRecovery", (TezConfiguration)tezConf);
        tezSession.start();
    }

    @After
    public void teardown() throws InterruptedException {
        if (tezSession != null) {
            try {
                LOG.info("Stopping Tez Session");
                tezSession.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        tezSession = null;
    }

    void runDAGAndVerify(DAG dag, DAGStatus.State finalState) throws Exception {
        tezSession.waitTillReady();
        DAGClient dagClient = tezSession.submitDAG(dag);
        DAGStatus dagStatus = dagClient.getDAGStatus(null);
        while (!dagStatus.isCompleted()) {
            LOG.info("Waiting for dag to complete. Sleeping for 500ms. DAG name: " + dag.getName() + " DAG appContext: " + dagClient.getExecutionContext() + " Current state: " + dagStatus.getState());
            Thread.sleep(100L);
            dagStatus = dagClient.getDAGStatus(null);
        }
        Assert.assertEquals((Object)finalState, (Object)dagStatus.getState());
    }

    @Test(timeout=120000L)
    public void testBasicRecovery() throws Exception {
        DAG dag = MultiAttemptDAG.createDAG("TestBasicRecovery", null);
        DataSourceDescriptor dataSource = DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)MultiAttemptDAG.NoOpInput.class.getName()), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)MultiAttemptDAG.TestRootInputInitializer.class.getName()), null);
        dag.getVertex("v1").addDataSource("Input", dataSource);
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }

    @Test(timeout=120000L)
    public void testDelayedInit() throws Exception {
        DAG dag = SimpleVTestDAG.createDAG("DelayedInitDAG", null);
        dag.getVertex("v1").addDataSource("i1", DataSourceDescriptor.create((InputDescriptor)InputDescriptor.create((String)MultiAttemptDAG.NoOpInput.class.getName()), (InputInitializerDescriptor)InputInitializerDescriptor.create((String)MultiAttemptDAG.FailingInputInitializer.class.getName()), null));
        this.runDAGAndVerify(dag, DAGStatus.State.SUCCEEDED);
    }
}

