/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.tika.mime.Clause;
import org.apache.tika.mime.MimeTypeException;

class MagicMatch
implements Clause {
    private static final Hex HEX_CODEC = new Hex();
    private int offsetStart;
    private int offsetEnd;
    private String type;
    private BigInteger mask;
    private BigInteger value;
    private int length;

    MagicMatch(int offsetStart, int offsetEnd, String type, String mask, String value) throws MimeTypeException {
        this.offsetStart = offsetStart;
        this.offsetEnd = offsetEnd;
        this.type = type;
        try {
            byte[] decoded = this.decodeValue(type, value);
            this.length = decoded.length;
            this.value = new BigInteger(decoded);
            if (mask != null) {
                this.mask = new BigInteger(this.decodeValue(type, mask));
                this.value = this.value.and(this.mask);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MimeTypeException(e);
        }
    }

    private byte[] decodeValue(String type, String value) throws DecoderException {
        if (value == null || type == null) {
            return null;
        }
        byte[] decoded = null;
        String tmpVal = null;
        int radix = 8;
        if (value.startsWith("0x")) {
            tmpVal = value.substring(2);
            radix = 16;
        } else {
            tmpVal = value;
            radix = 8;
        }
        if (type.equals("string")) {
            decoded = this.decodeString(value);
        } else if (type.equals("byte")) {
            decoded = tmpVal.getBytes();
        } else if (type.equals("host16") || type.equals("little16")) {
            int i = Integer.parseInt(tmpVal, radix);
            decoded = new byte[]{(byte)(i >> 8), (byte)(i & 0xFF)};
        } else if (type.equals("big16")) {
            int i = Integer.parseInt(tmpVal, radix);
            decoded = new byte[]{(byte)(i >> 8), (byte)(i & 0xFF)};
        } else if (type.equals("host32") || type.equals("little32")) {
            long i = Long.parseLong(tmpVal, radix);
            decoded = new byte[]{(byte)(i & 0xFFL), (byte)((i & 0xFF00L) >> 8), (byte)((i & 0xFF0000L) >> 16), (byte)((i & 0xFFFFFFFFFF000000L) >> 24)};
        } else if (type.equals("big32")) {
            long i = Long.parseLong(tmpVal, radix);
            decoded = new byte[]{(byte)((i & 0xFFFFFFFFFF000000L) >> 24), (byte)((i & 0xFF0000L) >> 16), (byte)((i & 0xFF00L) >> 8), (byte)(i & 0xFFL)};
        }
        return decoded;
    }

    private byte[] decodeString(String value) throws DecoderException {
        if (value.startsWith("0x")) {
            return HEX_CODEC.decode(value.substring(2).getBytes());
        }
        try {
            ByteArrayOutputStream decoded = new ByteArrayOutputStream();
            for (int i = 0; i < value.length(); ++i) {
                if (value.charAt(i) == '\\') {
                    int j;
                    if (value.charAt(i + 1) == '\\') {
                        decoded.write(92);
                        ++i;
                        continue;
                    }
                    if (value.charAt(i + 1) == 'x') {
                        decoded.write(HEX_CODEC.decode(value.substring(i + 2, i + 4).getBytes()));
                        i += 3;
                        continue;
                    }
                    for (j = i + 1; j < i + 4 && j < value.length() && Character.isDigit(value.charAt(j)); ++j) {
                    }
                    decoded.write(Short.decode("0" + value.substring(i + 1, j)).byteValue());
                    i = j - 1;
                    continue;
                }
                decoded.write(value.charAt(i));
            }
            return decoded.toByteArray();
        }
        catch (Exception e) {
            throw new DecoderException(e.toString() + " for " + value);
        }
    }

    public boolean eval(byte[] data) {
        for (int i = this.offsetStart; i <= this.offsetEnd; ++i) {
            if (data.length < this.length + i) {
                return false;
            }
            byte[] array = new byte[this.length];
            System.arraycopy(data, i, array, 0, this.length);
            BigInteger content = new BigInteger(array);
            if (this.mask != null) {
                content = content.and(this.mask);
            }
            if (!this.value.equals(content)) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.length;
    }

    public String toString() {
        return "[" + this.offsetStart + ":" + this.offsetEnd + "(" + this.type + ")-" + this.mask + "#" + this.value + "]";
    }
}

