/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.util.ArrayList;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.tika.mime.Magic;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.utils.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MimeType
implements Comparable<MimeType> {
    private final MimeTypes registry;
    private final String name;
    private String description = "";
    private MimeType superType = null;
    private final SortedSet<MimeType> subTypes = new TreeSet<MimeType>();
    private final ArrayList<Magic> magics = new ArrayList();
    private final SortedSet<String> aliases = new TreeSet<String>();
    private final ArrayList<RootXML> rootXML = new ArrayList();
    private int minLength = 0;

    public static boolean isValid(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name is missing");
        }
        boolean slash = false;
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (ch <= ' ' || ch >= '\u007f' || ch == '(' || ch == ')' || ch == '<' || ch == '>' || ch == '@' || ch == ',' || ch == ';' || ch == ':' || ch == '\\' || ch == '\"' || ch == '[' || ch == ']' || ch == '?' || ch == '=') {
                return false;
            }
            if (ch != '/') continue;
            if (slash || i == 0 || i + 1 == name.length()) {
                return false;
            }
            slash = true;
        }
        return slash;
    }

    MimeType(MimeTypes registry, String name) {
        if (registry == null) {
            throw new IllegalArgumentException("Registry is missing");
        }
        if (!MimeType.isValid(name) || !name.equals(name.toLowerCase())) {
            throw new IllegalArgumentException("Media type name is invalid");
        }
        this.registry = registry;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MimeType getSuperType() {
        return this.superType;
    }

    public void setSuperType(MimeType type) throws MimeTypeException {
        if (type == null) {
            throw new IllegalArgumentException("MimeType is missing");
        }
        if (type.registry != this.registry) {
            throw new IllegalArgumentException("MimeType is from a different registry");
        }
        if (!this.isDescendantOf(type)) {
            if (this == type) {
                throw new MimeTypeException("Media type can not inherit itself: " + type);
            }
            if (type.isDescendantOf(this)) {
                throw new MimeTypeException("Media type can not inherit its descendant: " + type);
            }
            if (this.superType == null) {
                this.superType = type;
                this.superType.subTypes.add(this);
            } else if (type.isDescendantOf(this.superType)) {
                this.superType.subTypes.remove(this);
                this.superType = type;
                this.superType.subTypes.add(this);
            } else {
                throw new MimeTypeException("Conflicting media type inheritance: " + type);
            }
        }
    }

    public SortedSet<MimeType> getSubTypes() {
        return Collections.unmodifiableSortedSet(this.subTypes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDescendantOf(MimeType type) {
        if (type == null) {
            throw new IllegalArgumentException("MimeType is missing");
        }
        MimeTypes mimeTypes = this.registry;
        synchronized (mimeTypes) {
            MimeType t = this.superType;
            while (t != null) {
                if (t == type) {
                    return true;
                }
                t = t.superType;
            }
            return false;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("Description is missing");
        }
        this.description = description;
    }

    public SortedSet<String> getAliases() {
        return Collections.unmodifiableSortedSet(this.aliases);
    }

    public void addAlias(String alias) throws MimeTypeException {
        if (MimeType.isValid(alias)) {
            if (!this.name.equals(alias = alias.toLowerCase()) && !this.aliases.contains(alias)) {
                this.registry.addAlias(this, alias);
                this.aliases.add(alias);
            }
        } else {
            throw new MimeTypeException("Invalid media type alias: " + alias);
        }
    }

    void addRootXML(String namespaceURI, String localName) {
        this.rootXML.add(new RootXML(this, namespaceURI, localName));
    }

    boolean matchesXML(byte[] data) {
        RootXML xml = null;
        String content = new String(data);
        for (int i = 0; i < this.rootXML.size(); ++i) {
            xml = this.rootXML.get(i);
            if (!xml.matches(content)) continue;
            return true;
        }
        return false;
    }

    boolean hasRootXML() {
        return this.rootXML.size() > 0;
    }

    RootXML[] getRootXMLs() {
        return this.rootXML.toArray(new RootXML[this.rootXML.size()]);
    }

    Magic[] getMagics() {
        return this.magics.toArray(new Magic[this.magics.size()]);
    }

    void addMagic(Magic magic) {
        if (magic == null) {
            return;
        }
        this.magics.add(magic);
    }

    int getMinLength() {
        return this.minLength;
    }

    public boolean hasMagic() {
        return this.magics.size() > 0;
    }

    public boolean matchesMagic(byte[] data) {
        for (int i = 0; i < this.magics.size(); ++i) {
            Magic magic = this.magics.get(i);
            if (!magic.eval(data)) continue;
            return true;
        }
        return false;
    }

    public boolean matches(byte[] data) {
        return this.matchesXML(data) || this.matchesMagic(data);
    }

    @Override
    public int compareTo(MimeType type) {
        if (type == null) {
            throw new IllegalArgumentException("MimeType is missing");
        }
        if (type == this) {
            return 0;
        }
        if (this.isDescendantOf(type)) {
            return 1;
        }
        if (type.isDescendantOf(this)) {
            return -1;
        }
        if (this.superType != null) {
            return this.superType.compareTo(type);
        }
        if (type.superType != null) {
            return this.compareTo(type.superType);
        }
        return this.name.compareTo(type.name);
    }

    public String toString() {
        return this.name;
    }

    class RootXML {
        private static final int PATTERN_FLAGS = 42;
        private MimeType type = null;
        private String namespaceURI = null;
        private String localName = null;
        private Pattern pattern = null;

        RootXML(MimeType type, String namespaceURI, String localName) {
            this.type = type;
            this.namespaceURI = namespaceURI;
            this.localName = localName;
            if (StringUtil.isEmpty(namespaceURI) && StringUtil.isEmpty(localName)) {
                throw new IllegalArgumentException("Both namespaceURI and localName cannot be null");
            }
            String regex = null;
            regex = StringUtil.isEmpty(namespaceURI) ? ".*<" + localName + "[^<>]*>.*" : (StringUtil.isEmpty(localName) ? ".*<[^<>]*\\p{Space}xmlns=[\"']?" + namespaceURI + "[\"']?[^<>]*>.*" : ".*<" + localName + "[^<>]*\\p{Space}xmlns=[\"']?" + namespaceURI + "[\"']?[^<>]*>.*");
            this.pattern = Pattern.compile(regex, 42);
        }

        boolean matches(byte[] data) {
            return this.matches(new String(data));
        }

        boolean matches(String data) {
            return this.pattern.matcher(data).matches();
        }

        MimeType getType() {
            return this.type;
        }

        String getNameSpaceURI() {
            return this.namespaceURI;
        }

        String getLocalName() {
            return this.localName;
        }

        public String toString() {
            return new StringBuffer().append(this.type.getName()).append(", ").append(this.namespaceURI).append(", ").append(this.localName).toString();
        }
    }
}

