/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;

public class ParsingReader
extends Reader {
    private final Parser parser;
    private final PipedReader reader;
    private final PipedWriter writer;
    private final InputStream stream;
    private final Metadata metadata;
    private Throwable throwable;

    private static Metadata getMetadata(String name) {
        Metadata metadata = new Metadata();
        if (name != null && name.length() > 0) {
            metadata.set("resourceName", name);
        }
        return metadata;
    }

    public ParsingReader(InputStream stream) {
        this(new AutoDetectParser(), stream, new Metadata());
    }

    public ParsingReader(InputStream stream, String name) {
        this(new AutoDetectParser(), stream, ParsingReader.getMetadata(name));
    }

    public ParsingReader(File file) throws FileNotFoundException {
        this(new FileInputStream(file), file.getName());
    }

    public ParsingReader(Parser parser, InputStream stream, Metadata metadata) {
        this.parser = parser;
        this.reader = new PipedReader();
        try {
            this.writer = new PipedWriter(this.reader);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.stream = stream;
        this.metadata = metadata;
        String name = metadata.get("resourceName");
        name = name != null ? "Apache Tika: " + name : "Apache Tika";
        new Thread((Runnable)new ParsingThread(), name).start();
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this.throwable instanceof IOException) {
            throw (IOException)this.throwable;
        }
        if (this.throwable != null) {
            IOException exception = new IOException("");
            exception.initCause(this.throwable);
            throw exception;
        }
        return this.reader.read(cbuf, off, len);
    }

    public void close() throws IOException {
        this.reader.close();
    }

    private class ParsingThread
    implements Runnable {
        private ParsingThread() {
        }

        public void run() {
            block7: {
                block6: {
                    try {
                        BodyContentHandler handler = new BodyContentHandler(ParsingReader.this.writer);
                        ParsingReader.this.parser.parse(ParsingReader.this.stream, handler, ParsingReader.this.metadata);
                    }
                    catch (Throwable t) {
                        ParsingReader.this.throwable = t;
                    }
                    try {
                        ParsingReader.this.stream.close();
                    }
                    catch (Throwable t) {
                        if (ParsingReader.this.throwable != null) break block6;
                        ParsingReader.this.throwable = t;
                    }
                }
                try {
                    ParsingReader.this.writer.close();
                }
                catch (Throwable t) {
                    if (ParsingReader.this.throwable != null) break block7;
                    ParsingReader.this.throwable = t;
                }
            }
        }
    }
}

