/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.audio;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AudioParser
implements Parser {
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        this.parse(stream, metadata);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    public void parse(InputStream stream, Metadata metadata) throws IOException, TikaException {
        String type = metadata.get("Content-Type");
        if (type != null) {
            try {
                AudioFileFormat fileFormat = AudioSystem.getAudioFileFormat(stream);
                AudioFormat format = fileFormat.getFormat();
                metadata.set("samplerate", Integer.toString((int)format.getSampleRate()));
                metadata.set("channels", Integer.toString(format.getChannels()));
                metadata.set("bits", Integer.toString(format.getSampleSizeInBits()));
                metadata.set("encoding", format.getEncoding().toString());
                for (Map.Entry<String, Object> entry : format.properties().entrySet()) {
                    metadata.set(entry.getKey(), entry.getValue().toString());
                }
            }
            catch (UnsupportedAudioFileException e) {
                // empty catch block
            }
        }
    }
}

