/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.html;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.html.XHTMLDowngradeHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.sax.TextContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.apache.tika.utils.Utils;
import org.cyberneko.html.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class HtmlParser
implements Parser {
    private static final Map<String, String> SAFE_ELEMENTS = new HashMap<String, String>();
    private static final Set<String> DISCARD_ELEMENTS = new HashSet<String>();

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        stream = new CloseShieldInputStream(stream);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        XPathParser xpath = new XPathParser(null, "");
        Matcher body = xpath.parse("/HTML/BODY//node()");
        Matcher title = xpath.parse("/HTML/HEAD/TITLE//node()");
        Matcher meta = xpath.parse("/HTML/HEAD/META//node()");
        handler = new TeeContentHandler(new MatchingContentHandler(this.getBodyHandler(xhtml), body), new MatchingContentHandler(this.getTitleHandler(metadata), title), new MatchingContentHandler(this.getMetaHandler(metadata), meta));
        xhtml.startDocument();
        SAXParser parser = new SAXParser();
        parser.setContentHandler((ContentHandler)new XHTMLDowngradeHandler(handler));
        parser.parse(new InputSource(Utils.getUTF8Reader(stream, metadata)));
        xhtml.endDocument();
    }

    private ContentHandler getTitleHandler(final Metadata metadata) {
        return new WriteOutContentHandler(){

            public void endElement(String u, String l, String n) {
                metadata.set("title", this.toString());
            }
        };
    }

    private ContentHandler getMetaHandler(final Metadata metadata) {
        return new WriteOutContentHandler(){

            public void startElement(String uri, String local, String name, Attributes atts) throws SAXException {
                if (atts.getValue("http-equiv") != null) {
                    metadata.set(atts.getValue("http-equiv"), atts.getValue("content"));
                }
                if (atts.getValue("name") != null) {
                    metadata.set(atts.getValue("name"), atts.getValue("content"));
                }
            }
        };
    }

    private ContentHandler getBodyHandler(final XHTMLContentHandler xhtml) {
        return new TextContentHandler(xhtml){
            private int discardLevel;
            {
                super(x0);
                this.discardLevel = 0;
            }

            public void startElement(String uri, String local, String name, Attributes atts) throws SAXException {
                if (this.discardLevel != 0) {
                    ++this.discardLevel;
                } else if (DISCARD_ELEMENTS.contains(name)) {
                    this.discardLevel = 1;
                } else if (SAFE_ELEMENTS.containsKey(name)) {
                    xhtml.startElement((String)SAFE_ELEMENTS.get(name));
                } else if ("A".equals(name)) {
                    String href = atts.getValue("href");
                    if (href == null) {
                        href = "";
                    }
                    xhtml.startElement("a", "href", href);
                }
            }

            public void endElement(String uri, String local, String name) throws SAXException {
                if (this.discardLevel != 0) {
                    --this.discardLevel;
                } else if (SAFE_ELEMENTS.containsKey(name)) {
                    xhtml.endElement((String)SAFE_ELEMENTS.get(name));
                } else if ("A".equals(name)) {
                    xhtml.endElement("a");
                }
            }

            public void characters(char[] ch, int start, int length) throws SAXException {
                if (this.discardLevel == 0) {
                    super.characters(ch, start, length);
                }
            }

            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
                if (this.discardLevel == 0) {
                    super.ignorableWhitespace(ch, start, length);
                }
            }
        };
    }

    static {
        SAFE_ELEMENTS.put("P", "p");
        SAFE_ELEMENTS.put("H1", "h1");
        SAFE_ELEMENTS.put("H2", "h2");
        SAFE_ELEMENTS.put("H3", "h3");
        SAFE_ELEMENTS.put("H4", "h4");
        SAFE_ELEMENTS.put("H5", "h5");
        SAFE_ELEMENTS.put("H6", "h6");
        SAFE_ELEMENTS.put("UL", "ul");
        SAFE_ELEMENTS.put("OL", "ol");
        SAFE_ELEMENTS.put("LI", "li");
        SAFE_ELEMENTS.put("DL", "dl");
        SAFE_ELEMENTS.put("DT", "dt");
        SAFE_ELEMENTS.put("DD", "dd");
        SAFE_ELEMENTS.put("PRE", "pre");
        SAFE_ELEMENTS.put("BLOCKQUOTE", "blockquote");
        SAFE_ELEMENTS.put("TABLE", "p");
        DISCARD_ELEMENTS.add("STYLE");
        DISCARD_ELEMENTS.add("SCRIPT");
    }
}

