/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.opendocument;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.opendocument.NSNormalizerContentHandler;
import org.apache.tika.parser.xml.DcXMLParser;
import org.apache.tika.parser.xml.MetadataHandler;
import org.apache.tika.sax.TeeContentHandler;
import org.apache.tika.sax.xpath.CompositeMatcher;
import org.apache.tika.sax.xpath.Matcher;
import org.apache.tika.sax.xpath.MatchingContentHandler;
import org.apache.tika.sax.xpath.XPathParser;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class OpenOfficeMetaParser
extends DcXMLParser {
    private static final XPathParser META_XPATH = new XPathParser("meta", "urn:oasis:names:tc:opendocument:xmlns:meta:1.0");

    private static DefaultHandler getMeta(ContentHandler ch, Metadata md, String name, String element) {
        CompositeMatcher matcher = new CompositeMatcher(META_XPATH.parse("//meta:" + element), META_XPATH.parse("//meta:" + element + "//text()"));
        MatchingContentHandler branch = new MatchingContentHandler(new MetadataHandler(md, name), matcher);
        return new TeeContentHandler(ch, branch);
    }

    private static DefaultHandler getStatistic(ContentHandler ch, Metadata md, String name, String attribute) {
        Matcher matcher = META_XPATH.parse("//meta:document-statistic/@meta:" + attribute);
        MatchingContentHandler branch = new MatchingContentHandler(new MetadataHandler(md, name), matcher);
        return new TeeContentHandler(ch, branch);
    }

    protected DefaultHandler getDefaultHandler(ContentHandler ch, Metadata md) {
        DefaultHandler dh = super.getDefaultHandler(ch, md);
        dh = OpenOfficeMetaParser.getMeta(dh, md, "Keywords", "keyword");
        dh = OpenOfficeMetaParser.getMeta(dh, md, "generator", "generator");
        dh = OpenOfficeMetaParser.getStatistic(dh, md, "nbTab", "table-count");
        dh = OpenOfficeMetaParser.getStatistic(dh, md, "nbObject", "object-count");
        dh = OpenOfficeMetaParser.getStatistic(dh, md, "nbImg", "image-count");
        dh = OpenOfficeMetaParser.getStatistic(dh, md, "nbPage", "page-count");
        dh = OpenOfficeMetaParser.getStatistic(dh, md, "nbPara", "paragraph-count");
        dh = OpenOfficeMetaParser.getStatistic(dh, md, "nbWord", "word-count");
        dh = OpenOfficeMetaParser.getStatistic(dh, md, "nbCharacter", "character-count");
        dh = new NSNormalizerContentHandler(dh);
        return dh;
    }
}

