/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.XHTMLContentHandler;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.util.PDFTextStripper;
import org.pdfbox.util.TextPosition;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

class PDF2XHTML
extends PDFTextStripper {
    private final XHTMLContentHandler handler;

    public static void process(PDDocument document, ContentHandler handler, Metadata metadata) throws SAXException, TikaException {
        try {
            new PDF2XHTML(handler, metadata).getText(document);
        }
        catch (IOException e) {
            if (e.getCause() instanceof SAXException) {
                throw (SAXException)e.getCause();
            }
            throw new TikaException("Unable to extract PDF content", e);
        }
    }

    private PDF2XHTML(ContentHandler handler, Metadata metadata) throws IOException {
        this.handler = new XHTMLContentHandler(handler, metadata);
    }

    protected void startDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.startDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a document", (Throwable)e);
        }
    }

    protected void endDocument(PDDocument pdf) throws IOException {
        try {
            this.handler.endDocument();
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a document", (Throwable)e);
        }
    }

    protected void startPage(PDPage page) throws IOException {
        try {
            this.handler.startElement("div");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a page", (Throwable)e);
        }
    }

    protected void endPage(PDPage page) throws IOException {
        try {
            this.handler.endElement("div");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a page", (Throwable)e);
        }
    }

    protected void startParagraph() throws IOException {
        try {
            this.handler.startElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to start a paragraph", (Throwable)e);
        }
    }

    protected void endParagraph() throws IOException {
        try {
            this.handler.endElement("p");
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to end a paragraph", (Throwable)e);
        }
    }

    protected void writeCharacters(TextPosition text) throws IOException {
        try {
            this.handler.characters(text.getCharacter());
        }
        catch (SAXException e) {
            throw new IOExceptionWithCause("Unable to write a character: " + text.getCharacter(), (Throwable)e);
        }
    }

    public String getWordSeparator() {
        try {
            this.handler.characters(" ");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return super.getWordSeparator();
    }

    public String getLineSeparator() {
        try {
            this.handler.characters("\n");
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return super.getLineSeparator();
    }
}

