/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pdf;

import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.pdf.PDF2XHTML;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentInformation;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class PDFParser
implements Parser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, SAXException, TikaException {
        PDDocument pdfDocument = PDDocument.load((InputStream)stream);
        try {
            if (pdfDocument.isEncrypted()) {
                try {
                    pdfDocument.decrypt("");
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            metadata.add("Content-Type", "application/pdf");
            this.extractMetadata(pdfDocument, metadata);
            PDF2XHTML.process(pdfDocument, handler, metadata);
        }
        finally {
            pdfDocument.close();
        }
    }

    private void extractMetadata(PDDocument document, Metadata metadata) throws TikaException {
        PDDocumentInformation info = document.getDocumentInformation();
        this.addMetadata(metadata, "title", info.getTitle());
        this.addMetadata(metadata, "Author", info.getAuthor());
        this.addMetadata(metadata, "creator", info.getCreator());
        this.addMetadata(metadata, "Keywords", info.getKeywords());
        this.addMetadata(metadata, "producer", info.getProducer());
        this.addMetadata(metadata, "subject", info.getSubject());
        this.addMetadata(metadata, "trapped", info.getTrapped());
        try {
            this.addMetadata(metadata, "created", info.getCreationDate());
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Calendar modified = info.getModificationDate();
            this.addMetadata(metadata, "Last-Modified", modified);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    private void addMetadata(Metadata metadata, String name, String value) {
        if (value != null) {
            metadata.add(name, value);
        }
    }

    private void addMetadata(Metadata metadata, String name, Calendar value) {
        if (value != null) {
            metadata.set(name, value.getTime().toString());
        }
    }
}

