/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.pkg.PackageParser;
import org.apache.tika.parser.pkg.tar.TarEntry;
import org.apache.tika.parser.pkg.tar.TarInputStream;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TarParser
extends PackageParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, TikaException, SAXException {
        metadata.set("Content-Type", "application/x-tar");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        TarInputStream tar = new TarInputStream((InputStream)new CloseShieldInputStream(stream));
        try {
            TarEntry entry = tar.getNextEntry();
            while (entry != null) {
                if (!entry.isDirectory()) {
                    Metadata entrydata = new Metadata();
                    entrydata.set("resourceName", entry.getName());
                    this.parseEntry(tar, xhtml, entrydata);
                }
                entry = tar.getNextEntry();
            }
        }
        finally {
            tar.close();
        }
        xhtml.endDocument();
    }
}

