/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.pkg.PackageParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class ZipParser
extends PackageParser {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata) throws IOException, TikaException, SAXException {
        metadata.set("Content-Type", "application/zip");
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        ZipInputStream zip = new ZipInputStream((InputStream)new CloseShieldInputStream(stream));
        try {
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                Metadata entrydata = new Metadata();
                entrydata.set("resourceName", entry.getName());
                this.parseEntry(zip, xhtml, entrydata);
                entry = zip.getNextEntry();
            }
        }
        finally {
            zip.close();
        }
        xhtml.endDocument();
    }
}

