/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.ContentHandlerDecorator;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XHTMLContentHandler
extends ContentHandlerDecorator {
    public static final String XHTML = "http://www.w3.org/1999/xhtml";
    private final Metadata metadata;
    private boolean started = false;

    public XHTMLContentHandler(ContentHandler handler, Metadata metadata) {
        super(handler);
        this.metadata = metadata;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        this.startPrefixMapping("", XHTML);
    }

    private void lazyStartDocument() throws SAXException {
        if (!this.started) {
            this.started = true;
            this.startElement("html");
            this.startElement("head");
            this.startElement("title");
            String title = this.metadata.get("title");
            if (title != null && title.length() > 0) {
                this.characters(title);
            }
            this.endElement("title");
            this.endElement("head");
            this.startElement("body");
        }
    }

    public void endDocument() throws SAXException {
        this.lazyStartDocument();
        this.endElement("body");
        this.endElement("html");
        this.endPrefixMapping("");
        super.endDocument();
    }

    public void startElement(String uri, String local, String name, Attributes attributes) throws SAXException {
        this.lazyStartDocument();
        super.startElement(uri, local, name, attributes);
    }

    public void startElement(String name) throws SAXException {
        this.startElement(XHTML, name, name, new AttributesImpl());
    }

    public void startElement(String name, String attribute, String value) throws SAXException {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute(XHTML, attribute, attribute, "CDATA", value);
        this.startElement(XHTML, name, name, attributes);
    }

    public void endElement(String name) throws SAXException {
        this.endElement(XHTML, name, name);
    }

    public void characters(String characters) throws SAXException {
        this.characters(characters.toCharArray(), 0, characters.length());
    }

    public void element(String name, String value) throws SAXException {
        this.startElement(name);
        this.characters(value);
        this.endElement(name);
    }
}

