/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.tika.sax.TextContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class XHTMLToTextContentHandler
extends TextContentHandler {
    private String lastLocalName = null;
    private static final char[] NL = new char[]{'\n'};
    private static final char[] TAB = new char[]{'\t'};
    private static final Set<String> HTML_BLOCK_TAGS = new HashSet<String>(Arrays.asList("p", "div", "fieldset", "table", "form", "pre", "blockquote", "address", "ul", "ol", "dl", "li", "dt", "dd", "h1", "h2", "h3", "h4", "h5", "h6", "noscript", "noframes", "hr", "br", "tr"));

    public XHTMLToTextContentHandler(ContentHandler handler) {
        super(handler);
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        if (!"tr".equals(this.lastLocalName) && ("td".equals(localName) || "th".equals(localName))) {
            this.characters(TAB, 0, TAB.length);
        }
        this.lastLocalName = localName;
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (HTML_BLOCK_TAGS.contains(localName)) {
            this.characters(NL, 0, NL.length);
        }
    }
}

