/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.log4j.Logger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;

public class Utils {
    static Logger logger = Logger.getRootLogger();

    public static List unzip(InputStream is) {
        ArrayList<File> res = new ArrayList<File>();
        try {
            ZipInputStream in = new ZipInputStream(is);
            ZipEntry entry = null;
            while ((entry = in.getNextEntry()) != null) {
                int len;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                byte[] buf = new byte[1024];
                while ((len = in.read(buf)) > 0) {
                    stream.write(buf, 0, len);
                }
                ByteArrayInputStream isEntry = new ByteArrayInputStream(stream.toByteArray());
                File file = File.createTempFile("TIKA_unzip_", "_" + entry.getName());
                file.deleteOnExit();
                Utils.saveInputStreamInFile(isEntry, new BufferedOutputStream(new FileOutputStream(file)));
                res.add(file);
                ((InputStream)isEntry).close();
            }
            in.close();
        }
        catch (IOException e) {
            logger.error((Object)e.getMessage());
        }
        return res;
    }

    private static void saveInputStreamInFile(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static Reader getUTF8Reader(InputStream stream, Metadata metadata) throws TikaException, IOException {
        CharsetDetector detector = new CharsetDetector();
        String encoding = metadata.get("Content-Encoding");
        if (encoding != null) {
            detector.setDeclaredEncoding(encoding);
        }
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        detector.setText(stream);
        CharsetMatch match = detector.detect();
        if (match == null) {
            throw new TikaException("Unable to detect character encoding");
        }
        metadata.set("Content-Encoding", match.getName());
        String language = match.getLanguage();
        if (language != null) {
            metadata.set("Content-Language", match.getLanguage());
            metadata.set("language", match.getLanguage());
        }
        return match.getReader();
    }
}

