/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.image;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.poi.util.IOUtils;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TIFF;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSDParser
extends AbstractParser {
    private static final long serialVersionUID = 883387734607994914L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.image("vnd.adobe.photoshop"))));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        ResourceBlock rb;
        byte[] signature = new byte[4];
        IOUtils.readFully(stream, signature);
        if (signature[0] != 56 || signature[1] != 66 || signature[2] != 80 || signature[3] != 83) {
            throw new TikaException("PSD/PSB magic signature invalid");
        }
        int version = EndianUtils.readUShortBE(stream);
        if (version != 1 && version != 2) {
            throw new TikaException("Invalid PSD/PSB version " + version);
        }
        IOUtils.readFully(stream, new byte[6]);
        int numChannels = EndianUtils.readUShortBE(stream);
        int height = EndianUtils.readIntBE(stream);
        int width = EndianUtils.readIntBE(stream);
        metadata.set(TIFF.IMAGE_LENGTH, height);
        metadata.set(TIFF.IMAGE_WIDTH, width);
        int depth = EndianUtils.readUShortBE(stream);
        metadata.set(TIFF.BITS_PER_SAMPLE, Integer.toString(depth));
        int colorMode = EndianUtils.readUShortBE(stream);
        long colorModeSectionSize = EndianUtils.readIntBE(stream);
        stream.skip(colorModeSectionSize);
        long imageResourcesSectionSize = EndianUtils.readIntBE(stream);
        for (long read = 0L; read < imageResourcesSectionSize; read += (long)rb.totalLength) {
            rb = new ResourceBlock(stream);
            if (rb.id != 1008) continue;
            metadata.add(TikaCoreProperties.DESCRIPTION, rb.getDataAsString());
        }
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        xhtml.endDocument();
    }

    private static class ResourceBlock {
        private static final long SIGNATURE = 943868237L;
        private static final int ID_CAPTION = 1008;
        private static final int ID_URL = 1035;
        private static final int ID_EXIF_1 = 1058;
        private static final int ID_EXIF_3 = 1059;
        private static final int ID_XMP = 1060;
        private int id;
        private String name;
        private byte[] data;
        private int totalLength;

        private ResourceBlock(InputStream stream) throws IOException, TikaException {
            long sig = EndianUtils.readIntBE(stream);
            if (sig != 943868237L) {
                throw new TikaException("Invalid Image Resource Block Signature Found, got " + sig + " 0x" + Long.toHexString(sig) + " but the spec defines " + 943868237L);
            }
            this.id = EndianUtils.readUShortBE(stream);
            StringBuffer nameB = new StringBuffer();
            int nameLen = 0;
            while (true) {
                int v = stream.read();
                ++nameLen;
                if (v == 0) {
                    if (nameLen % 2 != 1) break;
                    stream.read();
                    ++nameLen;
                    break;
                }
                nameB.append((char)v);
                this.name = nameB.toString();
            }
            int dataLen = EndianUtils.readIntBE(stream);
            this.totalLength = 6 + nameLen + 4 + dataLen;
            this.data = new byte[dataLen];
            IOUtils.readFully(stream, this.data);
        }

        private String getDataAsString() {
            try {
                return new String(this.data, 0, this.data.length - 1, "ASCII");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Something is very broken in your JVM!");
            }
        }
    }
}

