/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Arrays;
import org.apache.tika.metadata.Metadata;

public class JsonMetadataSerializer
implements JsonSerializer<Metadata> {
    @Override
    public JsonElement serialize(Metadata metadata, Type type, JsonSerializationContext context) {
        if (metadata == null) {
            return new JsonNull();
        }
        String[] names = this.getNames(metadata);
        if (names == null) {
            return new JsonNull();
        }
        JsonObject root = new JsonObject();
        for (String n : names) {
            String[] vals = metadata.getValues(n);
            if (vals == null) continue;
            if (vals.length == 1) {
                root.addProperty(n, vals[0]);
                continue;
            }
            JsonArray jArr = new JsonArray();
            for (int i = 0; i < vals.length; ++i) {
                jArr.add(new JsonPrimitive(vals[i]));
            }
            root.add(n, jArr);
        }
        return root;
    }

    protected String[] getNames(Metadata metadata) {
        Object[] names = metadata.names();
        Arrays.sort(names);
        return names;
    }
}

