/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointIteratorAbstract;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonRect;

public class PointIteratorFiltered
extends PointIteratorAbstract {
    private PointFeatureIterator orgIter;
    private LatLonRect filter_bb;
    private DateRange filter_date;
    private PointFeature pointFeature;
    private boolean finished = false;

    PointIteratorFiltered(PointFeatureIterator orgIter, LatLonRect filter_bb, DateRange filter_date) {
        this.orgIter = orgIter;
        this.filter_bb = filter_bb;
        this.filter_date = filter_date;
    }

    @Override
    public void setBufferSize(int bytes) {
        this.orgIter.setBufferSize(bytes);
    }

    @Override
    public void finish() {
        if (this.finished) {
            return;
        }
        this.orgIter.finish();
        this.finishCalcBounds();
        this.finished = true;
    }

    @Override
    public boolean hasNext() throws IOException {
        boolean done;
        this.pointFeature = this.nextFilteredDataPoint();
        boolean bl = done = this.pointFeature == null;
        if (done) {
            this.finish();
        }
        return !done;
    }

    @Override
    public PointFeature next() throws IOException {
        if (this.pointFeature == null) {
            return null;
        }
        this.calcBounds(this.pointFeature);
        return this.pointFeature;
    }

    private boolean filter(PointFeature pdata) {
        if (this.filter_date != null && !this.filter_date.included(pdata.getObservationTimeAsDate())) {
            return false;
        }
        return this.filter_bb == null || this.filter_bb.contains(pdata.getLocation().getLatitude(), pdata.getLocation().getLongitude());
    }

    private PointFeature nextFilteredDataPoint() throws IOException {
        if (this.orgIter == null) {
            return null;
        }
        if (!this.orgIter.hasNext()) {
            return null;
        }
        PointFeature pdata = this.orgIter.next();
        while (!this.filter(pdata)) {
            if (!this.orgIter.hasNext()) {
                return null;
            }
            pdata = this.orgIter.next();
        }
        return pdata;
    }
}

