/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.code;

import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.renderer.XhtmlRendererFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.AutoDetectReader;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.ccil.cowan.tagsoup.HTMLSchema;
import org.ccil.cowan.tagsoup.Schema;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SourceCodeParser
implements Parser {
    private static final long serialVersionUID = -4543476498190054160L;
    private static final Pattern authorPattern = Pattern.compile("(?im)@author (.*) *$");
    private static final Map<MediaType, String> TYPES_TO_RENDERER = new HashMap<MediaType, String>(){
        private static final long serialVersionUID = -741976157563751152L;
        {
            this.put(MediaType.text("x-c++src"), "cpp");
            this.put(MediaType.text("x-java-source"), "java");
            this.put(MediaType.text("x-groovy"), "groovy");
        }
    };
    private static final ServiceLoader LOADER = new ServiceLoader(SourceCodeParser.class.getClassLoader());
    private static final Schema HTML_SCHEMA = new HTMLSchema();

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return TYPES_TO_RENDERER.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        AutoDetectReader reader = new AutoDetectReader(new CloseShieldInputStream(stream), metadata, context.get(ServiceLoader.class, LOADER));
        try {
            Charset charset = reader.getCharset();
            String mediaType = metadata.get("Content-Type");
            String name = metadata.get("resourceName");
            if (mediaType != null && name != null) {
                String line;
                MediaType type = MediaType.parse(mediaType);
                metadata.set("Content-Type", type.toString());
                metadata.set("Content-Encoding", charset.name());
                StringBuilder out = new StringBuilder();
                int nbLines = 0;
                while ((line = reader.readLine()) != null) {
                    out.append(line + System.getProperty("line.separator"));
                    String author = this.parserAuthor(line);
                    if (author != null) {
                        metadata.add(TikaCoreProperties.CREATOR, author);
                    }
                    ++nbLines;
                }
                metadata.set("LoC", String.valueOf(nbLines));
                Renderer renderer = this.getRenderer(type.toString());
                String codeAsHtml = renderer.highlight(name, out.toString(), charset.name(), false);
                Schema schema = context.get(Schema.class, HTML_SCHEMA);
                org.ccil.cowan.tagsoup.Parser parser = new org.ccil.cowan.tagsoup.Parser();
                parser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", schema);
                parser.setContentHandler(handler);
                parser.parse(new InputSource(new StringReader(codeAsHtml)));
            }
        }
        finally {
            reader.close();
        }
    }

    private Renderer getRenderer(String mimeType) {
        MediaType mt = MediaType.parse(mimeType);
        String type = TYPES_TO_RENDERER.get(mt);
        if (type == null) {
            throw new RuntimeException("unparseable content type " + mimeType);
        }
        return XhtmlRendererFactory.getRenderer(type);
    }

    private String parserAuthor(String line) {
        Matcher m = authorPattern.matcher(line);
        if (m.find()) {
            return m.group(1).trim();
        }
        return null;
    }
}

