/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.mp4.boxes;

import com.drew.lang.SequentialReader;
import com.drew.metadata.mp4.Mp4Directory;
import com.drew.metadata.mp4.boxes.Box;
import com.drew.metadata.mp4.media.Mp4UuidBoxDirectory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.UUID;

public class UuidBox
extends Box {
    private byte[] userData;

    public UuidBox(SequentialReader reader, Box box) throws IOException {
        super(box);
        if (this.type.equals("uuid")) {
            this.usertype = this.getUuid(reader.getBytes(16));
        }
        this.userData = reader.getBytes(reader.available());
    }

    public void addMetadata(Mp4Directory directory) {
        directory.setString(Mp4UuidBoxDirectory.TAG_UUID, this.usertype);
        directory.setByteArray(Mp4UuidBoxDirectory.TAG_USER_DATA, this.userData);
    }

    private String getUuid(byte[] bytes) {
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        UUID uuid = new UUID(bb.getLong(), bb.getLong());
        return uuid.toString();
    }
}

