/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hsmf.extractor;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.poi.extractor.POIOLE2TextExtractor;
import org.apache.poi.hsmf.MAPIMessage;
import org.apache.poi.hsmf.datatypes.AttachmentChunks;
import org.apache.poi.hsmf.datatypes.StringChunk;
import org.apache.poi.hsmf.exceptions.ChunkNotFoundException;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.util.LocaleUtil;
import org.apache.poi.util.StringUtil;

public class OutlookTextExtractor
extends POIOLE2TextExtractor {
    public OutlookTextExtractor(MAPIMessage msg) {
        super(msg);
    }

    public OutlookTextExtractor(DirectoryNode poifsDir) throws IOException {
        this(new MAPIMessage(poifsDir));
    }

    public OutlookTextExtractor(POIFSFileSystem fs) throws IOException {
        this(new MAPIMessage(fs));
    }

    public OutlookTextExtractor(InputStream inp) throws IOException {
        this(new MAPIMessage(inp));
    }

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: OutlookTextExtractor <file> [<file> ...]");
            System.exit(1);
        }
        for (String filename : args) {
            try (POIFSFileSystem poifs = new POIFSFileSystem(new File(filename));
                 OutlookTextExtractor extractor = new OutlookTextExtractor(poifs);){
                System.out.println(extractor.getText());
            }
        }
    }

    public MAPIMessage getMAPIMessage() {
        return (MAPIMessage)this.document;
    }

    @Override
    public String getText() {
        StringUtil.StringsIterator emails;
        MAPIMessage msg = (MAPIMessage)this.document;
        StringBuilder s2 = new StringBuilder();
        msg.guess7BitEncoding();
        try {
            emails = new StringUtil.StringsIterator(msg.getRecipientEmailAddressList());
        }
        catch (ChunkNotFoundException e) {
            emails = new StringUtil.StringsIterator(new String[0]);
        }
        try {
            s2.append("From: " + msg.getDisplayFrom() + "\n");
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        try {
            this.handleEmails(s2, "To", msg.getDisplayTo(), emails);
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        try {
            this.handleEmails(s2, "CC", msg.getDisplayCC(), emails);
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        try {
            this.handleEmails(s2, "BCC", msg.getDisplayBCC(), emails);
        }
        catch (ChunkNotFoundException e) {
            // empty catch block
        }
        try {
            SimpleDateFormat f = new SimpleDateFormat("E, d MMM yyyy HH:mm:ss Z", Locale.ROOT);
            f.setTimeZone(LocaleUtil.getUserTimeZone());
            s2.append("Date: ").append(f.format(msg.getMessageDate().getTime())).append("\n");
        }
        catch (ChunkNotFoundException e) {
            try {
                String[] headers;
                for (String header : headers = msg.getHeaders()) {
                    if (!StringUtil.startsWithIgnoreCase(header, "date:")) continue;
                    s2.append("Date:").append(header, header.indexOf(58) + 1, header.length()).append("\n");
                }
            }
            catch (ChunkNotFoundException chunkNotFoundException) {
                // empty catch block
            }
        }
        try {
            s2.append("Subject: ").append(msg.getSubject()).append("\n");
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        for (AttachmentChunks att : msg.getAttachmentFiles()) {
            String attName;
            StringChunk name = att.getAttachLongFileName();
            if (name == null) {
                name = att.getAttachFileName();
            }
            String string = attName = name == null ? null : name.getValue();
            if (att.getAttachMimeTag() != null && att.getAttachMimeTag().getValue() != null) {
                attName = att.getAttachMimeTag().getValue() + " = " + attName;
            }
            s2.append("Attachment: ").append(attName).append("\n");
        }
        try {
            s2.append("\n").append(msg.getTextBody()).append("\n");
        }
        catch (ChunkNotFoundException chunkNotFoundException) {
            // empty catch block
        }
        return s2.toString();
    }

    protected void handleEmails(StringBuilder s2, String type, String displayText, StringUtil.StringsIterator emails) {
        if (displayText == null || displayText.length() == 0) {
            return;
        }
        String[] names = displayText.split(";\\s*");
        boolean first = true;
        s2.append(type).append(": ");
        for (String name : names) {
            String email;
            if (first) {
                first = false;
            } else {
                s2.append("; ");
            }
            s2.append(name);
            if (!emails.hasNext() || (email = emails.next()).equals(name)) continue;
            s2.append(" <").append(email).append(">");
        }
        s2.append("\n");
    }
}

