/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwmf.draw;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.nio.charset.Charset;
import java.text.AttributedString;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import org.apache.commons.codec.Charsets;
import org.apache.poi.common.usermodel.fonts.FontCharset;
import org.apache.poi.common.usermodel.fonts.FontInfo;
import org.apache.poi.hwmf.draw.HwmfDrawProperties;
import org.apache.poi.hwmf.draw.HwmfImageRenderer;
import org.apache.poi.hwmf.record.HwmfBrushStyle;
import org.apache.poi.hwmf.record.HwmfFont;
import org.apache.poi.hwmf.record.HwmfHatchStyle;
import org.apache.poi.hwmf.record.HwmfMapMode;
import org.apache.poi.hwmf.record.HwmfMisc;
import org.apache.poi.hwmf.record.HwmfObjectTableEntry;
import org.apache.poi.hwmf.record.HwmfPenStyle;
import org.apache.poi.hwmf.record.HwmfRegionMode;
import org.apache.poi.hwmf.record.HwmfText;
import org.apache.poi.sl.draw.BitmapImageRenderer;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawFontManager;
import org.apache.poi.sl.draw.DrawFontManagerDefault;
import org.apache.poi.sl.draw.DrawPictureShape;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LocaleUtil;

public class HwmfGraphics {
    private static final Float[] WEIGHT_MAP = new Float[]{Float.valueOf(900.0f), TextAttribute.WEIGHT_ULTRABOLD, Float.valueOf(800.0f), TextAttribute.WEIGHT_EXTRABOLD, Float.valueOf(750.0f), TextAttribute.WEIGHT_HEAVY, Float.valueOf(700.0f), TextAttribute.WEIGHT_BOLD, Float.valueOf(600.0f), TextAttribute.WEIGHT_DEMIBOLD, Float.valueOf(500.0f), TextAttribute.WEIGHT_MEDIUM, Float.valueOf(450.0f), TextAttribute.WEIGHT_SEMIBOLD, Float.valueOf(400.0f), TextAttribute.WEIGHT_REGULAR, Float.valueOf(300.0f), TextAttribute.WEIGHT_DEMILIGHT, Float.valueOf(200.0f), TextAttribute.WEIGHT_LIGHT, Float.valueOf(1.0f), TextAttribute.WEIGHT_EXTRA_LIGHT};
    private final List<HwmfDrawProperties> propStack = new LinkedList<HwmfDrawProperties>();
    protected HwmfDrawProperties prop;
    protected final Graphics2D graphicsCtx;
    protected final BitSet objectIndexes = new BitSet();
    protected final TreeMap<Integer, HwmfObjectTableEntry> objectTable = new TreeMap();
    private final AffineTransform initialAT = new AffineTransform();
    private static final Charset DEFAULT_CHARSET = LocaleUtil.CHARSET_1252;
    private final Rectangle2D bbox;

    public HwmfGraphics(Graphics2D graphicsCtx, Rectangle2D bbox) {
        this.graphicsCtx = graphicsCtx;
        this.bbox = (Rectangle2D)bbox.clone();
        this.initialAT.setTransform(graphicsCtx.getTransform());
    }

    public HwmfDrawProperties getProperties() {
        if (this.prop == null) {
            this.prop = this.newProperties(null);
        }
        return this.prop;
    }

    protected HwmfDrawProperties newProperties(HwmfDrawProperties oldProps) {
        return oldProps == null ? new HwmfDrawProperties() : new HwmfDrawProperties(oldProps);
    }

    public void draw(Shape shape) {
        HwmfPenStyle ps = this.getProperties().getPenStyle();
        if (ps == null) {
            return;
        }
        HwmfPenStyle.HwmfLineDash lineDash = ps.getLineDash();
        if (lineDash == HwmfPenStyle.HwmfLineDash.NULL) {
            return;
        }
        BasicStroke stroke = this.getStroke();
        if (this.getProperties().getBkMode() == HwmfMisc.WmfSetBkMode.HwmfBkMode.OPAQUE && lineDash != HwmfPenStyle.HwmfLineDash.SOLID && lineDash != HwmfPenStyle.HwmfLineDash.INSIDEFRAME) {
            this.graphicsCtx.setStroke(new BasicStroke(stroke.getLineWidth()));
            this.graphicsCtx.setColor(this.getProperties().getBackgroundColor().getColor());
            this.graphicsCtx.draw(shape);
        }
        this.graphicsCtx.setStroke(stroke);
        this.graphicsCtx.setColor(this.getProperties().getPenColor().getColor());
        this.graphicsCtx.draw(shape);
    }

    public void fill(Shape shape) {
        HwmfDrawProperties prop = this.getProperties();
        Composite old = this.graphicsCtx.getComposite();
        this.graphicsCtx.setComposite(AlphaComposite.getInstance(3));
        if (prop.getBrushStyle() != HwmfBrushStyle.BS_NULL) {
            if (prop.getBkMode() == HwmfMisc.WmfSetBkMode.HwmfBkMode.OPAQUE) {
                this.graphicsCtx.setPaint(prop.getBackgroundColor().getColor());
                this.graphicsCtx.fill(shape);
            }
            this.graphicsCtx.setPaint(this.getFill());
            this.graphicsCtx.fill(shape);
        }
        this.graphicsCtx.setComposite(old);
        this.draw(shape);
    }

    protected BasicStroke getStroke() {
        HwmfDrawProperties prop = this.getProperties();
        HwmfPenStyle ps = prop.getPenStyle();
        float width = (float)prop.getPenWidth();
        if (width == 0.0f) {
            width = 1.0f;
        }
        int cap = ps.getLineCap().awtFlag;
        int join = ps.getLineJoin().awtFlag;
        float miterLimit = (float)prop.getPenMiterLimit();
        float[] dashes = ps.getLineDashes();
        boolean dashAlt = ps.isAlternateDash();
        float dashStart = dashAlt && dashes != null && dashes.length > 1 ? dashes[0] : 0.0f;
        return new BasicStroke(width, cap, join, miterLimit, dashes, dashStart);
    }

    protected Paint getFill() {
        switch (this.getProperties().getBrushStyle()) {
            default: {
                return null;
            }
            case BS_PATTERN: 
            case BS_DIBPATTERN: 
            case BS_DIBPATTERNPT: {
                return this.getPatternPaint();
            }
            case BS_SOLID: {
                return this.getSolidFill();
            }
            case BS_HATCHED: {
                return this.getHatchedFill();
            }
            case BS_LINEAR_GRADIENT: 
        }
        return this.getLinearGradient();
    }

    protected Paint getLinearGradient() {
        return null;
    }

    protected Paint getSolidFill() {
        return this.getProperties().getBrushColor().getColor();
    }

    protected Paint getHatchedFill() {
        int dim = 7;
        int mid = 3;
        BufferedImage bi = new BufferedImage(dim, dim, 6);
        Graphics2D g2 = bi.createGraphics();
        Color c = this.getProperties().getBkMode() == HwmfMisc.WmfSetBkMode.HwmfBkMode.TRANSPARENT ? new Color(0, true) : this.getProperties().getBackgroundColor().getColor();
        g2.setColor(c);
        g2.fillRect(0, 0, dim, dim);
        g2.setColor(this.getProperties().getBrushColor().getColor());
        HwmfHatchStyle h2 = this.getProperties().getBrushHatch();
        if (h2 == HwmfHatchStyle.HS_HORIZONTAL || h2 == HwmfHatchStyle.HS_CROSS) {
            g2.drawLine(0, mid, dim, mid);
        }
        if (h2 == HwmfHatchStyle.HS_VERTICAL || h2 == HwmfHatchStyle.HS_CROSS) {
            g2.drawLine(mid, 0, mid, dim);
        }
        if (h2 == HwmfHatchStyle.HS_FDIAGONAL || h2 == HwmfHatchStyle.HS_DIAGCROSS) {
            g2.drawLine(0, 0, dim, dim);
        }
        if (h2 == HwmfHatchStyle.HS_BDIAGONAL || h2 == HwmfHatchStyle.HS_DIAGCROSS) {
            g2.drawLine(0, dim, dim, 0);
        }
        g2.dispose();
        return new TexturePaint(bi, new Rectangle(0, 0, dim, dim));
    }

    protected Paint getPatternPaint() {
        HwmfDrawProperties prop = this.getProperties();
        ImageRenderer bb = prop.getBrushBitmap();
        if (bb == null) {
            return null;
        }
        Dimension2D dim = bb.getDimension();
        Rectangle2D rect = new Rectangle2D.Double(0.0, 0.0, dim.getWidth(), dim.getHeight());
        rect = prop.getBrushTransform().createTransformedShape(rect).getBounds2D();
        return new TexturePaint(bb.getImage(), rect);
    }

    public void addObjectTableEntry(HwmfObjectTableEntry entry) {
        int objIdx = this.objectIndexes.nextClearBit(0);
        this.objectIndexes.set(objIdx);
        this.objectTable.put(objIdx, entry);
    }

    public void applyObjectTableEntry(int index) {
        HwmfObjectTableEntry ote = this.objectTable.get(index);
        if (ote == null) {
            throw new NoSuchElementException("WMF reference exception - object table entry on index " + index + " was deleted before.");
        }
        ote.applyObject(this);
    }

    public void unsetObjectTableEntry(int index) {
        if (index < 0) {
            throw new IndexOutOfBoundsException("Invalid index: " + index);
        }
        this.objectTable.remove(index);
        this.objectIndexes.clear(index);
    }

    public void saveProperties() {
        HwmfDrawProperties p = this.getProperties();
        assert (p != null);
        p.setTransform(this.graphicsCtx.getTransform());
        p.setClip(this.graphicsCtx.getClip());
        this.propStack.add(p);
        this.prop = this.newProperties(p);
    }

    public void restoreProperties(int index) {
        if (index == 0) {
            return;
        }
        int stackIndex = index;
        if (stackIndex < 0) {
            int curIdx = this.propStack.indexOf(this.getProperties());
            if (curIdx == -1) {
                curIdx = this.propStack.size();
            }
            stackIndex = curIdx + index;
        }
        if (stackIndex == -1) {
            stackIndex = this.propStack.size() - 1;
        }
        for (int i = this.propStack.size() - 1; i >= stackIndex; --i) {
            this.prop = this.propStack.remove(i);
        }
        this.graphicsCtx.setTransform(this.prop.getTransform());
        this.graphicsCtx.setClip(this.prop.getClip());
    }

    public void updateWindowMapMode() {
        Rectangle2D win = this.getProperties().getWindow();
        Rectangle2D view = this.getProperties().getViewport();
        HwmfMapMode mapMode = this.getProperties().getMapMode();
        this.graphicsCtx.setTransform(this.getInitTransform());
        switch (mapMode) {
            default: {
                if (view == null) break;
                this.graphicsCtx.translate(view.getCenterX(), view.getCenterY());
                this.graphicsCtx.scale(view.getWidth() / win.getWidth(), view.getHeight() / win.getHeight());
                this.graphicsCtx.translate(-win.getCenterX(), -win.getCenterY());
                break;
            }
            case MM_ISOTROPIC: {
                this.graphicsCtx.translate(this.bbox.getCenterX(), this.bbox.getCenterY());
                this.graphicsCtx.scale(this.bbox.getWidth() / win.getWidth(), this.bbox.getWidth() / win.getWidth());
                this.graphicsCtx.translate(-win.getCenterX(), -win.getCenterY());
                break;
            }
            case MM_LOMETRIC: 
            case MM_HIMETRIC: 
            case MM_LOENGLISH: 
            case MM_HIENGLISH: 
            case MM_TWIPS: {
                GraphicsConfiguration gc = this.graphicsCtx.getDeviceConfiguration();
                this.graphicsCtx.transform(gc.getNormalizingTransform());
                this.graphicsCtx.scale(1.0 / (double)mapMode.scale, -1.0 / (double)mapMode.scale);
                this.graphicsCtx.translate(-win.getX(), -win.getY());
            }
            case MM_TEXT: 
        }
    }

    public void drawString(byte[] text, int length, Point2D reference) {
        this.drawString(text, length, reference, null, null, null, null, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(byte[] text, int length, Point2D reference, Dimension2D scale, Rectangle2D clip, HwmfText.WmfExtTextOutOptions opts, List<Integer> dx, boolean isUnicode) {
        int trimLen;
        Charset charset;
        HwmfDrawProperties prop = this.getProperties();
        AffineTransform at = this.graphicsCtx.getTransform();
        try {
            at.createInverse();
        }
        catch (NoninvertibleTransformException e) {
            return;
        }
        HwmfFont font = prop.getFont();
        if (font == null || text == null || text.length == 0) {
            return;
        }
        double fontH = this.getFontHeight(font);
        double fontW = fontH / 1.8;
        if (isUnicode) {
            charset = Charsets.UTF_16LE;
        } else {
            charset = font.getCharset().getCharset();
            if (charset == null) {
                charset = DEFAULT_CHARSET;
            }
        }
        for (trimLen = 0; trimLen < text.length; trimLen += 2) {
            if (trimLen == text.length - 1) {
                if (text[trimLen] == 0) break;
                ++trimLen;
                break;
            }
            if (text[trimLen] == -1 && text[trimLen + 1] == -1 || (text[trimLen] & 0xE0) == 0 && text[trimLen + 1] == 0) break;
        }
        String textString = new String(text, 0, trimLen, charset);
        if ((textString = textString.substring(0, Math.min(textString.length(), length))).isEmpty()) {
            return;
        }
        DrawFontManager fontHandler = DrawFactory.getInstance(this.graphicsCtx).getFontManager(this.graphicsCtx);
        FontInfo fontInfo = fontHandler.getMappedFont(this.graphicsCtx, font);
        if (fontInfo.getCharset() == FontCharset.SYMBOL) {
            textString = DrawFontManagerDefault.mapSymbolChars(textString);
        }
        AttributedString as = new AttributedString(textString);
        this.addAttributes(as, font, fontInfo.getTypeface());
        double angle = Math.toRadians((double)(-font.getEscapement()) / 10.0);
        HwmfText.HwmfTextAlignment align = prop.getTextAlignLatin();
        HwmfText.HwmfTextVerticalAlignment valign = prop.getTextVAlignLatin();
        FontRenderContext frc = this.graphicsCtx.getFontRenderContext();
        TextLayout layout = new TextLayout(as.getIterator(), frc);
        Rectangle2D pixelBounds = layout.getBounds();
        AffineTransform tx = new AffineTransform();
        switch (align) {
            default: {
                break;
            }
            case CENTER: {
                tx.translate(-pixelBounds.getWidth() / 2.0, 0.0);
                break;
            }
            case RIGHT: {
                tx.translate(-layout.getAdvance(), 0.0);
            }
        }
        switch (valign) {
            case TOP: {
                tx.translate(0.0, layout.getAscent());
            }
            default: {
                break;
            }
            case BOTTOM: {
                tx.translate(0.0, -(pixelBounds.getHeight() - (double)layout.getDescent()));
            }
        }
        tx.rotate(angle);
        Point2D.Double src = new Point2D.Double();
        Point2D.Double dst = new Point2D.Double();
        tx.transform(src, dst);
        Shape clipShape = this.graphicsCtx.getClip();
        try {
            if (clip != null && !clip.getBounds2D().isEmpty()) {
                this.graphicsCtx.translate(-clip.getCenterX(), -clip.getCenterY());
                this.graphicsCtx.rotate(angle);
                this.graphicsCtx.translate(clip.getCenterX(), clip.getCenterY());
                if (prop.getBkMode() == HwmfMisc.WmfSetBkMode.HwmfBkMode.OPAQUE && opts.isOpaque()) {
                    this.graphicsCtx.setPaint(prop.getBackgroundColor().getColor());
                    this.graphicsCtx.fill(clip);
                }
                if (opts.isClipped()) {
                    this.graphicsCtx.setClip(clip);
                }
                this.graphicsCtx.setTransform(at);
            }
            this.graphicsCtx.translate(reference.getX(), reference.getY());
            this.graphicsCtx.rotate(angle);
            if (scale != null) {
                this.graphicsCtx.scale(scale.getWidth() < 0.0 ? -1.0 : 1.0, scale.getHeight() < 0.0 ? -1.0 : 1.0);
            }
            this.graphicsCtx.translate(((Point2D)dst).getX(), ((Point2D)dst).getY());
            this.graphicsCtx.setColor(prop.getTextColor().getColor());
            this.graphicsCtx.drawString(as.getIterator(), 0, 0);
        }
        finally {
            this.graphicsCtx.setTransform(at);
            this.graphicsCtx.setClip(clipShape);
        }
    }

    private void addAttributes(AttributedString as, HwmfFont font, String typeface) {
        as.addAttribute(TextAttribute.FAMILY, typeface);
        as.addAttribute(TextAttribute.SIZE, this.getFontHeight(font));
        if (font.isStrikeOut()) {
            as.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
        }
        if (font.isUnderline()) {
            as.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        }
        if (font.isItalic()) {
            as.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
        }
        int fw = font.getWeight();
        Float awtFW = TextAttribute.WEIGHT_REGULAR;
        for (int i = 0; i < WEIGHT_MAP.length; i += 2) {
            if (!((float)fw >= WEIGHT_MAP[i].floatValue())) continue;
            awtFW = WEIGHT_MAP[i + 1];
            break;
        }
        as.addAttribute(TextAttribute.WEIGHT, awtFW);
    }

    private double getFontHeight(HwmfFont font) {
        double fontHeight = font.getHeight();
        if (fontHeight == 0.0) {
            return 12.0;
        }
        if (fontHeight < 0.0) {
            return -fontHeight;
        }
        return fontHeight * 3.0 / 4.0;
    }

    public void drawImage(BufferedImage img, Rectangle2D srcBounds, Rectangle2D dstBounds) {
        this.drawImage(new BufferedImageRenderer(img), srcBounds, dstBounds);
    }

    public void drawImage(ImageRenderer img, Rectangle2D srcBounds, Rectangle2D dstBounds) {
        if (srcBounds.isEmpty()) {
            return;
        }
        HwmfDrawProperties prop = this.getProperties();
        switch (prop.getRasterOp()) {
            case D: {
                break;
            }
            case PATCOPY: {
                this.graphicsCtx.setPaint(this.getFill());
                this.graphicsCtx.fill(dstBounds);
                break;
            }
            case BLACKNESS: {
                this.graphicsCtx.setPaint(Color.BLACK);
                this.graphicsCtx.fill(dstBounds);
                break;
            }
            case WHITENESS: {
                this.graphicsCtx.setPaint(Color.WHITE);
                this.graphicsCtx.fill(dstBounds);
                break;
            }
            default: {
                if (img == null) {
                    return;
                }
                Shape oldClip = this.graphicsCtx.getClip();
                AffineTransform oldTrans = this.graphicsCtx.getTransform();
                Rectangle2D normBounds = HwmfGraphics.normalizeRect(dstBounds);
                if (prop.getBkMode() == HwmfMisc.WmfSetBkMode.HwmfBkMode.OPAQUE) {
                    Paint oldPaint = this.graphicsCtx.getPaint();
                    this.graphicsCtx.setPaint(prop.getBackgroundColor().getColor());
                    this.graphicsCtx.fill(dstBounds);
                    this.graphicsCtx.setPaint(oldPaint);
                }
                this.graphicsCtx.translate(normBounds.getCenterX(), normBounds.getCenterY());
                this.graphicsCtx.scale(Math.signum(dstBounds.getWidth()), Math.signum(dstBounds.getHeight()));
                this.graphicsCtx.translate(-normBounds.getCenterX(), -normBounds.getCenterY());
                Composite old = this.graphicsCtx.getComposite();
                this.graphicsCtx.setComposite(AlphaComposite.getInstance(3));
                boolean useDeviceBounds = img instanceof HwmfImageRenderer;
                img.drawImage(this.graphicsCtx, normBounds, HwmfGraphics.getSubImageInsets(srcBounds, useDeviceBounds ? img.getNativeBounds() : img.getBounds()));
                this.graphicsCtx.setComposite(old);
                this.graphicsCtx.setTransform(oldTrans);
                this.graphicsCtx.setClip(oldClip);
            }
        }
    }

    private static Rectangle2D normalizeRect(Rectangle2D dstBounds) {
        return new Rectangle2D.Double(dstBounds.getWidth() >= 0.0 ? dstBounds.getMinX() : dstBounds.getMaxX(), dstBounds.getHeight() >= 0.0 ? dstBounds.getMinY() : dstBounds.getMaxY(), Math.abs(dstBounds.getWidth()), Math.abs(dstBounds.getHeight()));
    }

    private static Insets getSubImageInsets(Rectangle2D srcBounds, Rectangle2D nativeBounds) {
        int left = (int)Math.round((srcBounds.getX() - nativeBounds.getX()) / nativeBounds.getWidth() * 100000.0);
        int top = (int)Math.round((srcBounds.getY() - nativeBounds.getY()) / nativeBounds.getHeight() * 100000.0);
        int right = (int)Math.round((nativeBounds.getMaxX() - srcBounds.getMaxX()) / nativeBounds.getWidth() * 100000.0);
        int bottom = (int)Math.round((nativeBounds.getMaxY() - srcBounds.getMaxY()) / nativeBounds.getHeight() * 100000.0);
        return new Insets(top, left, bottom, right);
    }

    public AffineTransform getInitTransform() {
        return new AffineTransform(this.initialAT);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.graphicsCtx.getTransform());
    }

    public void setTransform(AffineTransform tx) {
        this.graphicsCtx.setTransform(tx);
    }

    public void setClip(Shape clip, HwmfRegionMode regionMode, boolean useInitialAT) {
        Shape newClip;
        Shape oldClip;
        AffineTransform at = this.graphicsCtx.getTransform();
        if (useInitialAT) {
            this.graphicsCtx.setTransform(this.getInitTransform());
        }
        if (!Objects.equals(oldClip = this.graphicsCtx.getClip(), newClip = regionMode.applyOp(oldClip, clip))) {
            this.graphicsCtx.setClip(newClip);
        }
        if (useInitialAT) {
            this.graphicsCtx.setTransform(at);
        }
        this.prop.setClip(this.graphicsCtx.getClip());
    }

    public ImageRenderer getImageRenderer(String contentType) {
        return DrawPictureShape.getImageRenderer(this.graphicsCtx, contentType);
    }

    @Internal
    static class BufferedImageRenderer
    extends BitmapImageRenderer {
        public BufferedImageRenderer(BufferedImage img) {
            this.img = img;
        }
    }

    public static enum FillDrawStyle {
        NONE(FillDrawStyle::fillNone),
        FILL(HwmfGraphics::fill),
        DRAW(HwmfGraphics::draw),
        FILL_DRAW(FillDrawStyle::fillDraw);

        public final BiConsumer<HwmfGraphics, Shape> handler;

        private FillDrawStyle(BiConsumer<HwmfGraphics, Shape> handler) {
            this.handler = handler;
        }

        private static void fillNone(HwmfGraphics g2, Shape s2) {
        }

        private static void fillDraw(HwmfGraphics g2, Shape s2) {
            g2.fill(s2);
            g2.draw(s2);
        }
    }
}

