/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.apple;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.TikaMemoryLimitException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.EndianUtils;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AppleSingleFileParser
extends AbstractParser {
    private static final int MAX_FIELD_LENGTH = 0x40000000;
    private static final int DATA_FORK = 1;
    private static final int RESOURCE_FORK = 2;
    private static final int REAL_NAME = 3;
    private static final int COMMENT = 4;
    private static final int ICON_BW = 5;
    private static final int ICON_COLOR = 6;
    private static final int FILE_DATES_INFO = 8;
    private static final int FINDER_INFO = 9;
    private static final int MACINTOSH_FILE_INFO = 10;
    private static final int PRODOS_FILE_INFO = 11;
    private static final int MSDOS_FILE_INFO = 12;
    private static final int SHORT_NAME = 13;
    private static final int AFP_FILE_INFO = 14;
    private static final int DIRECTORY_ID = 15;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MediaType.application("applefile"));

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        EmbeddedDocumentExtractor ex = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        short numEntries = this.readThroughNumEntries(stream);
        long bytesRead = 26L;
        List<FieldInfo> fieldInfoList = this.getSortedFieldInfoList(stream, numEntries);
        bytesRead += (long)(12 * numEntries);
        Metadata embeddedMetadata = new Metadata();
        bytesRead = this.processFieldEntries(stream, fieldInfoList, embeddedMetadata, bytesRead);
        FieldInfo contentFieldInfo = this.getContentFieldInfo(fieldInfoList);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        if (contentFieldInfo != null) {
            long diff = contentFieldInfo.offset - bytesRead;
            IOUtils.skipFully(stream, diff);
            if (ex.shouldParseEmbedded(embeddedMetadata)) {
                ex.parseEmbedded(new CloseShieldInputStream(stream), xhtml, embeddedMetadata, false);
            }
        }
        xhtml.endDocument();
    }

    private FieldInfo getContentFieldInfo(List<FieldInfo> fieldInfoList) {
        for (FieldInfo fieldInfo : fieldInfoList) {
            if (fieldInfo.entryId != 1L) continue;
            return fieldInfo;
        }
        return null;
    }

    private long processFieldEntries(InputStream stream, List<FieldInfo> fieldInfoList, Metadata embeddedMetadata, long bytesRead) throws IOException, TikaException {
        byte[] buffer = null;
        for (FieldInfo f : fieldInfoList) {
            long diff = f.offset - bytesRead;
            IOUtils.skipFully(stream, diff);
            bytesRead += diff;
            if (f.entryId == 3L) {
                if (f.length > 0x40000000L) {
                    throw new TikaMemoryLimitException(f.length, 0x40000000L);
                }
                buffer = new byte[(int)f.length];
                IOUtils.readFully(stream, buffer);
                bytesRead += f.length;
                String originalFileName = new String(buffer, 0, buffer.length, StandardCharsets.US_ASCII);
                embeddedMetadata.set(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, originalFileName);
                continue;
            }
            if (f.entryId == 1L) continue;
            IOUtils.skipFully(stream, f.length);
            bytesRead += f.length;
        }
        return bytesRead;
    }

    private List<FieldInfo> getSortedFieldInfoList(InputStream stream, short numEntries) throws IOException, TikaException {
        ArrayList<FieldInfo> fieldInfoList = new ArrayList<FieldInfo>(numEntries);
        for (int i = 0; i < numEntries; ++i) {
            fieldInfoList.add(new FieldInfo(EndianUtils.readUIntBE(stream), EndianUtils.readUIntBE(stream), EndianUtils.readUIntBE(stream)));
        }
        if (fieldInfoList.size() == 0) {
            throw new TikaException("AppleSingleFile missing field info");
        }
        fieldInfoList.sort(Comparator.comparingLong(fieldInfo -> ((FieldInfo)fieldInfo).offset));
        return fieldInfoList;
    }

    private short readThroughNumEntries(InputStream stream) throws TikaException, IOException {
        EndianUtils.readIntBE(stream);
        long version = EndianUtils.readIntBE(stream);
        if (version != 131072L) {
            throw new TikaException("Version should have been 0x00020000, but was:" + version);
        }
        IOUtils.skipFully(stream, 16L);
        return EndianUtils.readShortBE(stream);
    }

    private static class FieldInfo {
        private final long entryId;
        private final long offset;
        private final long length;

        private FieldInfo(long entryId, long offset, long length) {
            this.entryId = entryId;
            this.offset = offset;
            this.length = length;
        }
    }
}

