/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.poi.hemf.record.emf.HemfComment;
import org.apache.poi.hemf.record.emf.HemfRecord;
import org.apache.poi.hemf.record.emf.HemfRecordType;
import org.apache.poi.hemf.record.emf.HemfText;
import org.apache.poi.hemf.usermodel.HemfPicture;
import org.apache.poi.util.RecordFormatException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class EMFParser
extends AbstractParser {
    private static final MediaType MEDIA_TYPE = MediaType.image("emf");
    private static final MediaType WMF_MEDIA_TYPE = MediaType.image("wmf");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MEDIA_TYPE);

    private static void handleEmbedded(byte[] data, EmbeddedDocumentExtractor embeddedDocumentExtractor, ContentHandler handler) throws TikaException, SAXException {
        try (TikaInputStream is = TikaInputStream.get(data);){
            Metadata embeddedMetadata = new Metadata();
            if (embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
                embeddedDocumentExtractor.parseEmbedded(is, new EmbeddedContentHandler(handler), embeddedMetadata, false);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        EmbeddedDocumentExtractor embeddedDocumentExtractor = null;
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        try {
            HemfPicture ex = new HemfPicture(stream);
            double lastY = -1.0;
            double lastX = -1.0;
            long fudgeFactorX = 1000L;
            StringBuilder buffer = new StringBuilder();
            for (HemfRecord record : ex) {
                if (record.getEmfRecordType() == HemfRecordType.comment) {
                    HemfComment.EmfCommentData commentData = ((HemfComment.EmfComment)record).getCommentData();
                    if (commentData instanceof HemfComment.EmfCommentDataMultiformats) {
                        if (embeddedDocumentExtractor == null) {
                            embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
                        }
                        this.handleMultiFormats((HemfComment.EmfCommentDataMultiformats)commentData, xhtml, embeddedDocumentExtractor);
                        continue;
                    }
                    if (!(commentData instanceof HemfComment.EmfCommentDataWMF)) continue;
                    if (embeddedDocumentExtractor == null) {
                        embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
                    }
                    this.handleWMF(((HemfComment.EmfCommentDataWMF)commentData).getWMFData(), xhtml, embeddedDocumentExtractor);
                    continue;
                }
                if (!record.getEmfRecordType().equals((Object)HemfRecordType.extTextOutW)) continue;
                HemfText.EmfExtTextOutW extTextOutW = (HemfText.EmfExtTextOutW)record;
                if (lastY > -1.0 && lastY != extTextOutW.getReference().getY()) {
                    xhtml.startElement("p");
                    xhtml.characters(buffer.toString());
                    xhtml.endElement("p");
                    buffer.setLength(0);
                    lastX = -1.0;
                }
                if (lastX > -1.0 && extTextOutW.getReference().getX() - lastX > (double)fudgeFactorX) {
                    buffer.append(" ");
                }
                String txt = extTextOutW.getText();
                buffer.append(txt);
                lastY = extTextOutW.getReference().getY();
                lastX = extTextOutW.getReference().getX();
            }
            if (buffer.length() > 0) {
                xhtml.startElement("p");
                xhtml.characters(buffer.toString());
                xhtml.endElement("p");
            }
        }
        catch (RecordFormatException e) {
            throw new TikaException(e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new TikaException(e.getMessage(), e);
        }
        xhtml.endDocument();
    }

    private void handleWMF(byte[] bytes, ContentHandler contentHandler, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws IOException, SAXException, TikaException {
        Metadata embeddedMetadata = new Metadata();
        embeddedMetadata.set("Content-Type", WMF_MEDIA_TYPE.toString());
        if (embeddedDocumentExtractor.shouldParseEmbedded(embeddedMetadata)) {
            try (TikaInputStream is = TikaInputStream.get(bytes);){
                embeddedDocumentExtractor.parseEmbedded(is, new EmbeddedContentHandler(contentHandler), embeddedMetadata, false);
            }
        }
    }

    private void handleMultiFormats(HemfComment.EmfCommentDataMultiformats commentData, ContentHandler handler, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws IOException, TikaException, SAXException {
        for (HemfComment.EmfCommentDataFormat dataFormat : commentData.getFormats()) {
            EMFParser.handleEmbedded(dataFormat.getRawData(), embeddedDocumentExtractor, handler);
        }
    }
}

