/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.pkg;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.compress.PasswordRequiredException;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveException;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.ArchiveStreamFactory;
import org.apache.commons.compress.archivers.StreamingNotSupportedException;
import org.apache.commons.compress.archivers.ar.ArArchiveInputStream;
import org.apache.commons.compress.archivers.cpio.CpioArchiveInputStream;
import org.apache.commons.compress.archivers.dump.DumpArchiveInputStream;
import org.apache.commons.compress.archivers.jar.JarArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.config.Field;
import org.apache.tika.detect.EncodingDetector;
import org.apache.tika.detect.zip.PackageConstants;
import org.apache.tika.exception.EncryptedDocumentException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractEncodingDetectorParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class PackageParser
extends AbstractEncodingDetectorParser {
    static final Set<MediaType> PACKAGE_SPECIALIZATIONS = PackageParser.loadPackageSpecializations();
    private static final long serialVersionUID = -5331043266963888708L;
    private static final Set<MediaType> SUPPORTED_TYPES = MediaType.set(PackageConstants.ZIP, PackageConstants.JAR, PackageConstants.AR, PackageConstants.ARJ, PackageConstants.CPIO, PackageConstants.DUMP, PackageConstants.TAR, PackageConstants.SEVENZ);
    private static final int MARK_LIMIT = 0x6400000;
    private boolean detectCharsetsInEntryNames = true;

    static final Set<MediaType> loadPackageSpecializations() {
        HashSet<MediaType> zipSpecializations = new HashSet<MediaType>();
        for (String mediaTypeString : new String[]{"application/bizagi-modeler", "application/epub+zip", "application/java-archive", "application/vnd.adobe.air-application-installer-package+zip", "application/vnd.android.package-archive", "application/vnd.apple.iwork", "application/vnd.apple.keynote", "application/vnd.apple.numbers", "application/vnd.apple.pages", "application/vnd.apple.unknown.13", "application/vnd.etsi.asic-e+zip", "application/vnd.etsi.asic-s+zip", "application/vnd.google-earth.kmz", "application/vnd.mindjet.mindmanager", "application/vnd.ms-excel.addin.macroenabled.12", "application/vnd.ms-excel.sheet.binary.macroenabled.12", "application/vnd.ms-excel.sheet.macroenabled.12", "application/vnd.ms-excel.template.macroenabled.12", "application/vnd.ms-powerpoint.addin.macroenabled.12", "application/vnd.ms-powerpoint.presentation.macroenabled.12", "application/vnd.ms-powerpoint.slide.macroenabled.12", "application/vnd.ms-powerpoint.slideshow.macroenabled.12", "application/vnd.ms-powerpoint.template.macroenabled.12", "application/vnd.ms-visio.drawing", "application/vnd.ms-visio.drawing.macroenabled.12", "application/vnd.ms-visio.stencil", "application/vnd.ms-visio.stencil.macroenabled.12", "application/vnd.ms-visio.template", "application/vnd.ms-visio.template.macroenabled.12", "application/vnd.ms-word.document.macroenabled.12", "application/vnd.ms-word.template.macroenabled.12", "application/vnd.ms-xpsdocument", "application/vnd.oasis.opendocument.formula", "application/vnd.openxmlformats-officedocument.presentationml.presentation", "application/vnd.openxmlformats-officedocument.presentationml.slide", "application/vnd.openxmlformats-officedocument.presentationml.slideshow", "application/vnd.openxmlformats-officedocument.presentationml.template", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "application/vnd.openxmlformats-officedocument.spreadsheetml.template", "application/vnd.openxmlformats-officedocument.wordprocessingml.document", "application/vnd.openxmlformats-officedocument.wordprocessingml.template", "application/x-ibooks+zip", "application/x-itunes-ipa", "application/x-tika-iworks-protected", "application/x-tika-java-enterprise-archive", "application/x-tika-java-web-archive", "application/x-tika-ooxml", "application/x-tika-visio-ooxml", "application/x-xliff+zip", "application/x-xmind", "model/vnd.dwfx+xps", "application/vnd.sun.xml.calc", "application/vnd.sun.xml.writer", "application/vnd.sun.xml.writer.template", "application/vnd.sun.xml.draw", "application/vnd.sun.xml.impress", "application/vnd.openofficeorg.autotext", "application/vnd.oasis.opendocument.graphics-template", "application/vnd.oasis.opendocument.text-web", "application/vnd.oasis.opendocument.spreadsheet-template", "application/vnd.oasis.opendocument.graphics", "application/vnd.oasis.opendocument.image-template", "application/vnd.oasis.opendocument.text", "application/vnd.oasis.opendocument.text-template", "application/vnd.oasis.opendocument.presentation", "application/vnd.oasis.opendocument.chart", "application/vnd.openofficeorg.extension", "application/vnd.oasis.opendocument.spreadsheet", "application/vnd.oasis.opendocument.image", "application/vnd.oasis.opendocument.formula-template", "application/vnd.oasis.opendocument.presentation-template", "application/vnd.oasis.opendocument.chart-template", "application/vnd.oasis.opendocument.text-master", "application/x-gtar"}) {
            zipSpecializations.add(MediaType.parse(mediaTypeString));
        }
        return Collections.unmodifiableSet(zipSpecializations);
    }

    @Deprecated
    static MediaType getMediaType(ArchiveInputStream stream) {
        if (stream instanceof JarArchiveInputStream) {
            return PackageConstants.JAR;
        }
        if (stream instanceof ZipArchiveInputStream) {
            return PackageConstants.ZIP;
        }
        if (stream instanceof ArArchiveInputStream) {
            return PackageConstants.AR;
        }
        if (stream instanceof CpioArchiveInputStream) {
            return PackageConstants.CPIO;
        }
        if (stream instanceof DumpArchiveInputStream) {
            return PackageConstants.DUMP;
        }
        if (stream instanceof TarArchiveInputStream) {
            return PackageConstants.TAR;
        }
        if (stream instanceof SevenZWrapper) {
            return PackageConstants.SEVENZ;
        }
        return MediaType.OCTET_STREAM;
    }

    protected static Metadata handleEntryMetadata(String name, Date createAt, Date modifiedAt, Long size, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        Metadata entrydata = new Metadata();
        if (createAt != null) {
            entrydata.set(TikaCoreProperties.CREATED, createAt);
        }
        if (modifiedAt != null) {
            entrydata.set(TikaCoreProperties.MODIFIED, modifiedAt);
        }
        if (size != null) {
            entrydata.set("Content-Length", Long.toString(size));
        }
        if (name != null && name.length() > 0) {
            name = name.replace("\\", "/");
            entrydata.set("resourceName", name);
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "class", "class", "CDATA", "embedded");
            attributes.addAttribute("", "id", "id", "CDATA", name);
            xhtml.startElement("div", attributes);
            xhtml.endElement("div");
            entrydata.set("embeddedRelationshipId", name);
        }
        return entrydata;
    }

    public PackageParser() {
    }

    public PackageParser(EncodingDetector encodingDetector) {
        super(encodingDetector);
    }

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!stream.markSupported()) {
            stream = new BufferedInputStream(stream);
        }
        TemporaryResources tmp = new TemporaryResources();
        ArchiveInputStream ais = null;
        String encoding = null;
        try {
            ArchiveStreamFactory factory = context.get(ArchiveStreamFactory.class, new ArchiveStreamFactory());
            encoding = factory.getEntryEncoding();
            ais = factory.createArchiveInputStream(new CloseShieldInputStream(stream));
        }
        catch (StreamingNotSupportedException sne) {
            if (sne.getFormat().equals("7z")) {
                SevenZFile sevenz;
                stream.reset();
                TikaInputStream tstream = TikaInputStream.get(stream, tmp);
                String password = null;
                PasswordProvider provider = context.get(PasswordProvider.class);
                if (provider != null) {
                    password = provider.getPassword(metadata);
                }
                try {
                    sevenz = password == null ? new SevenZFile(tstream.getFile()) : new SevenZFile(tstream.getFile(), password.toCharArray());
                }
                catch (PasswordRequiredException e) {
                    throw new EncryptedDocumentException(e);
                }
                ais = new SevenZWrapper(sevenz);
            }
            tmp.close();
            throw new TikaException("Unknown non-streaming format " + sne.getFormat(), sne);
        }
        catch (ArchiveException e) {
            tmp.close();
            throw new TikaException("Unable to unpack document stream", e);
        }
        this.updateMediaType(ais, metadata);
        EmbeddedDocumentExtractor extractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        stream.mark(0x6400000);
        AtomicInteger entryCnt = new AtomicInteger();
        try {
            this.parseEntries(ais, metadata, extractor, xhtml, false, entryCnt);
        }
        catch (UnsupportedZipFeatureException zfe) {
            if (zfe.getFeature() == UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR) {
                ais.close();
                stream.reset();
                ais = new ZipArchiveInputStream(new CloseShieldInputStream(stream), encoding, true, true);
                this.parseEntries(ais, metadata, extractor, xhtml, true, entryCnt);
            }
        }
        finally {
            ais.close();
            tmp.close();
            xhtml.endDocument();
        }
    }

    private void parseEntries(ArchiveInputStream ais, Metadata metadata, EmbeddedDocumentExtractor extractor, XHTMLContentHandler xhtml, boolean shouldUseDataDescriptor, AtomicInteger entryCnt) throws TikaException, IOException, SAXException {
        try {
            ArchiveEntry entry = ais.getNextEntry();
            while (entry != null) {
                if (shouldUseDataDescriptor && entryCnt.get() > 0) {
                    entryCnt.decrementAndGet();
                    entry = ais.getNextEntry();
                    continue;
                }
                if (!entry.isDirectory()) {
                    this.parseEntry(ais, entry, extractor, metadata, xhtml);
                }
                if (!shouldUseDataDescriptor) {
                    entryCnt.incrementAndGet();
                }
                entry = ais.getNextEntry();
            }
        }
        catch (UnsupportedZipFeatureException zfe) {
            if (zfe.getFeature() == UnsupportedZipFeatureException.Feature.ENCRYPTION) {
                throw new EncryptedDocumentException(zfe);
            }
            if (zfe.getFeature() == UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR) {
                throw zfe;
            }
            throw new TikaException("UnsupportedZipFeature", zfe);
        }
        catch (PasswordRequiredException pre) {
            throw new EncryptedDocumentException(pre);
        }
    }

    private void updateMediaType(ArchiveInputStream ais, Metadata metadata) {
        MediaType type = PackageParser.getMediaType(ais);
        if (type.equals(MediaType.OCTET_STREAM)) {
            return;
        }
        String incomingContentTypeString = metadata.get("Content-Type");
        if (incomingContentTypeString == null) {
            metadata.set("Content-Type", type.toString());
            return;
        }
        MediaType incomingMediaType = MediaType.parse(incomingContentTypeString);
        if (incomingMediaType == null) {
            metadata.set("Content-Type", type.toString());
            return;
        }
        if (!PACKAGE_SPECIALIZATIONS.contains(incomingMediaType)) {
            metadata.set("Content-Type", type.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEntry(ArchiveInputStream archive, ArchiveEntry entry, EmbeddedDocumentExtractor extractor, Metadata parentMetadata, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        Charset candidate;
        String name = entry.getName();
        if (this.detectCharsetsInEntryNames && entry instanceof ZipArchiveEntry && (candidate = this.getEncodingDetector().detect(new ByteArrayInputStream(((ZipArchiveEntry)entry).getRawName()), parentMetadata)) != null) {
            name = new String(((ZipArchiveEntry)entry).getRawName(), candidate);
        }
        if (archive.canReadEntryData(entry)) {
            Metadata entrydata = PackageParser.handleEntryMetadata(name, null, entry.getLastModifiedDate(), entry.getSize(), xhtml);
            if (extractor.shouldParseEmbedded(entrydata)) {
                TemporaryResources tmp = new TemporaryResources();
                try {
                    TikaInputStream tis = TikaInputStream.get(archive, tmp);
                    extractor.parseEmbedded(tis, xhtml, entrydata, true);
                }
                finally {
                    tmp.dispose();
                }
            }
        } else {
            String string = name = name == null ? "" : name;
            if (entry instanceof ZipArchiveEntry) {
                boolean usesDataDescriptor;
                ZipArchiveEntry zipArchiveEntry = (ZipArchiveEntry)entry;
                boolean usesEncryption = zipArchiveEntry.getGeneralPurposeBit().usesEncryption();
                if (usesEncryption) {
                    EmbeddedDocumentUtil.recordEmbeddedStreamException(new EncryptedDocumentException("stream (" + name + ") is encrypted"), parentMetadata);
                }
                if ((usesDataDescriptor = zipArchiveEntry.getGeneralPurposeBit().usesDataDescriptor()) && zipArchiveEntry.getMethod() == 0) {
                    throw new UnsupportedZipFeatureException(UnsupportedZipFeatureException.Feature.DATA_DESCRIPTOR, zipArchiveEntry);
                }
            } else {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(new TikaException("Can't read archive stream (" + name + ")"), parentMetadata);
            }
            if (name.length() > 0) {
                xhtml.element("p", name);
            }
        }
    }

    @Field
    public void setDetectCharsetsInEntryNames(boolean detectCharsetsInEntryNames) {
        this.detectCharsetsInEntryNames = detectCharsetsInEntryNames;
    }

    private static class SevenZWrapper
    extends ArchiveInputStream {
        private SevenZFile file;

        private SevenZWrapper(SevenZFile file) {
            this.file = file;
        }

        @Override
        public int read() throws IOException {
            return this.file.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.file.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.file.read(b, off, len);
        }

        @Override
        public ArchiveEntry getNextEntry() throws IOException {
            return this.file.getNextEntry();
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }
}

