/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.xml;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.OfflineContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLProfiler
extends AbstractParser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("xml"), MediaType.application("rdf+xml"), MediaType.application("vnd.adobe.xdp+xml"))));
    public static Property ROOT_ENTITY = Property.internalText("xmlprofiler:root_entity");
    public static Property ENTITY_URIS = Property.internalTextBag("xmlprofiler:entity_uris");
    public static Property ENTITY_LOCAL_NAMES = Property.internalTextBag("xmlprofiler:entity_local_names");

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XMLReaderUtils.parseSAX(new CloseShieldInputStream(stream), new OfflineContentHandler(new XMLProfileHandler(metadata)), context);
    }

    private static class XMLProfileHandler
    extends DefaultHandler {
        private final Metadata metadata;
        int starts = 0;
        Map<String, Set> entities = new TreeMap<String, Set>();

        public XMLProfileHandler(Metadata metadata) {
            this.metadata = metadata;
        }

        static String joinWith(String delimiter, Collection<String> strings) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            for (String s2 : strings) {
                if (i > 0) {
                    sb.append(delimiter);
                }
                sb.append(s2);
                ++i;
            }
            return sb.toString();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            if (this.starts == 0) {
                this.metadata.set(ROOT_ENTITY, qName);
            }
            Set localNames = this.entities.computeIfAbsent(uri, k -> new TreeSet());
            localNames.add(localName);
            ++this.starts;
        }

        @Override
        public void endDocument() throws SAXException {
            String[] uris = new String[this.entities.size()];
            String[] localNames = new String[this.entities.size()];
            int i = 0;
            for (Map.Entry<String, Set> e : this.entities.entrySet()) {
                uris[i] = e.getKey();
                localNames[i] = XMLProfileHandler.joinWith(" ", e.getValue());
                ++i;
            }
            this.metadata.set(ENTITY_URIS, uris);
            this.metadata.set(ENTITY_LOCAL_NAMES, localNames);
        }
    }
}

