/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.common;

import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.impl.common.XMLChar;

public class XmlObjectList {
    private final XmlObject[] _objects;

    public XmlObjectList(int objectCount) {
        this._objects = new XmlObject[objectCount];
    }

    public boolean set(XmlObject o, int index) {
        if (this._objects[index] != null) {
            return false;
        }
        this._objects[index] = o;
        return true;
    }

    public boolean filled() {
        for (int i = 0; i < this._objects.length; ++i) {
            if (this._objects[i] != null) continue;
            return false;
        }
        return true;
    }

    public int unfilled() {
        for (int i = 0; i < this._objects.length; ++i) {
            if (this._objects[i] != null) continue;
            return i;
        }
        return -1;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XmlObjectList)) {
            return false;
        }
        XmlObjectList other = (XmlObjectList)o;
        if (other._objects.length != this._objects.length) {
            return false;
        }
        for (int i = 0; i < this._objects.length; ++i) {
            if (this._objects[i] == null || other._objects[i] == null) {
                return false;
            }
            if (this._objects[i].valueEquals(other._objects[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int h2 = 0;
        for (int i = 0; i < this._objects.length; ++i) {
            if (this._objects[i] == null) continue;
            h2 = 31 * h2 + this._objects[i].valueHashCode();
        }
        return h2;
    }

    private static String prettytrim(String s2) {
        int start;
        int end;
        for (end = s2.length(); end > 0 && XMLChar.isSpace(s2.charAt(end - 1)); --end) {
        }
        for (start = 0; start < end && XMLChar.isSpace(s2.charAt(start)); ++start) {
        }
        return s2.substring(start, end);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < this._objects.length; ++i) {
            if (i != 0) {
                b.append(" ");
            }
            b.append(XmlObjectList.prettytrim(((SimpleValue)this._objects[i]).getStringValue()));
        }
        return b.toString();
    }
}

