/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ByteOrderMarkReader;
import com.dd.plist.NSArray;
import com.dd.plist.NSData;
import com.dd.plist.NSDate;
import com.dd.plist.NSDictionary;
import com.dd.plist.NSNumber;
import com.dd.plist.NSObject;
import com.dd.plist.NSString;
import com.dd.plist.PropertyListParser;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.StringCharacterIterator;
import java.util.LinkedList;
import java.util.Objects;

public final class ASCIIPropertyListParser {
    public static final char WHITESPACE_SPACE = ' ';
    public static final char WHITESPACE_TAB = '\t';
    public static final char WHITESPACE_NEWLINE = '\n';
    public static final char WHITESPACE_CARRIAGE_RETURN = '\r';
    public static final char ARRAY_BEGIN_TOKEN = '(';
    public static final char ARRAY_END_TOKEN = ')';
    public static final char ARRAY_ITEM_DELIMITER_TOKEN = ',';
    public static final char DICTIONARY_BEGIN_TOKEN = '{';
    public static final char DICTIONARY_END_TOKEN = '}';
    public static final char DICTIONARY_ASSIGN_TOKEN = '=';
    public static final char DICTIONARY_ITEM_DELIMITER_TOKEN = ';';
    public static final char QUOTEDSTRING_BEGIN_TOKEN = '\"';
    public static final char QUOTEDSTRING_END_TOKEN = '\"';
    public static final char QUOTEDSTRING_ESCAPE_TOKEN = '\\';
    public static final char DATA_BEGIN_TOKEN = '<';
    public static final char DATA_END_TOKEN = '>';
    public static final char DATA_BASE64_BEGIN_TOKEN = '[';
    public static final char DATA_BASE64_END_TOKEN = ']';
    public static final char DATA_GSOBJECT_BEGIN_TOKEN = '*';
    public static final char DATA_GSDATE_BEGIN_TOKEN = 'D';
    public static final char DATA_GSBOOL_BEGIN_TOKEN = 'B';
    public static final char DATA_GSBOOL_TRUE_TOKEN = 'Y';
    public static final char DATA_GSBOOL_FALSE_TOKEN = 'N';
    public static final char DATA_GSINT_BEGIN_TOKEN = 'I';
    public static final char DATA_GSREAL_BEGIN_TOKEN = 'R';
    public static final char DATE_DATE_FIELD_DELIMITER = '-';
    public static final char DATE_TIME_FIELD_DELIMITER = ':';
    public static final char DATE_GS_DATE_TIME_DELIMITER = ' ';
    public static final char DATE_APPLE_DATE_TIME_DELIMITER = 'T';
    public static final char DATE_APPLE_END_TOKEN = 'Z';
    public static final char COMMENT_BEGIN_TOKEN = '/';
    public static final char MULTILINE_COMMENT_SECOND_TOKEN = '*';
    public static final char SINGLELINE_COMMENT_SECOND_TOKEN = '/';
    public static final char MULTILINE_COMMENT_END_TOKEN = '/';
    private final char[] data;
    private int index;

    private ASCIIPropertyListParser(byte[] propertyListContent, String encoding) throws UnsupportedEncodingException {
        this(new String(propertyListContent, encoding).toCharArray());
    }

    private ASCIIPropertyListParser(char[] propertyListContent) {
        this.data = propertyListContent;
    }

    public static NSObject parse(File f) throws IOException, ParseException {
        return ASCIIPropertyListParser.parse(f.toPath());
    }

    public static NSObject parse(File f, String encoding) throws IOException, ParseException {
        return ASCIIPropertyListParser.parse(f.toPath(), encoding);
    }

    public static NSObject parse(Path path, String encoding) throws IOException, ParseException {
        try (InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = ASCIIPropertyListParser.parse(fileInputStream, encoding);
            return nSObject;
        }
    }

    public static NSObject parse(Path path) throws IOException, ParseException {
        try (InputStream fileInputStream = Files.newInputStream(path, new OpenOption[0]);){
            NSObject nSObject = ASCIIPropertyListParser.parse(fileInputStream);
            return nSObject;
        }
    }

    public static NSObject parse(InputStream in) throws ParseException, IOException {
        return ASCIIPropertyListParser.parse(PropertyListParser.readAll(in));
    }

    public static NSObject parse(InputStream in, String encoding) throws ParseException, IOException {
        return ASCIIPropertyListParser.parse(PropertyListParser.readAll(in), encoding);
    }

    public static NSObject parse(Reader reader) throws ParseException, IOException {
        int read;
        Objects.requireNonNull(reader, "The specified reader is null");
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        char[] buf = new char[4096];
        while ((read = reader.read(buf)) >= 0) {
            charArrayWriter.write(buf, 0, read);
        }
        ASCIIPropertyListParser parser = new ASCIIPropertyListParser(charArrayWriter.toCharArray());
        return parser.parse();
    }

    public static NSObject parse(String plistData) throws ParseException {
        ASCIIPropertyListParser parser = new ASCIIPropertyListParser(plistData.toCharArray());
        return parser.parse();
    }

    public static NSObject parse(byte[] bytes) throws ParseException {
        String charset = ByteOrderMarkReader.detect(bytes);
        if (charset == null) {
            charset = "UTF-8";
        }
        try {
            return ASCIIPropertyListParser.parse(bytes, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unsupported property list encoding (" + charset + "): " + e.getMessage());
        }
    }

    public static NSObject parse(byte[] bytes, String encoding) throws ParseException, UnsupportedEncodingException {
        ASCIIPropertyListParser parser = new ASCIIPropertyListParser(bytes, encoding);
        return parser.parse();
    }

    private boolean acceptSequence(char ... sequence) {
        if (this.index + sequence.length > this.data.length) {
            return false;
        }
        for (int i = 0; i < sequence.length; ++i) {
            if (this.data[this.index + i] == sequence[i]) continue;
            return false;
        }
        return true;
    }

    private boolean accept(char ... acceptableSymbols) {
        boolean symbolPresent = false;
        if (this.index < this.data.length) {
            for (char c : acceptableSymbols) {
                if (this.data[this.index] != c) continue;
                symbolPresent = true;
                break;
            }
        }
        return symbolPresent;
    }

    private boolean accept(char acceptableSymbol) {
        return this.index < this.data.length && this.data[this.index] == acceptableSymbol;
    }

    private void expect(char ... expectedSymbols) throws ParseException {
        if (!this.accept(expectedSymbols)) {
            StringBuilder excString = new StringBuilder();
            excString.append("Expected '").append(expectedSymbols[0]).append("'");
            for (int i = 1; i < expectedSymbols.length; ++i) {
                excString.append(" or '").append(expectedSymbols[i]).append("'");
            }
            if (this.index < this.data.length) {
                excString.append(" but found '").append(this.data[this.index]).append("'");
            } else {
                excString.append(" but reached end of input");
            }
            throw new ParseException(excString.toString(), this.index);
        }
    }

    private void expect(char expectedSymbol) throws ParseException {
        if (!this.accept(expectedSymbol)) {
            throw new ParseException(this.index < this.data.length ? "Expected '" + expectedSymbol + "' but found '" + this.data[this.index] + "'" : "Expected '" + expectedSymbol + "' but reached end of input", this.index);
        }
    }

    private void read(char symbol) throws ParseException {
        this.expect(symbol);
        ++this.index;
    }

    private void skip() {
        ++this.index;
    }

    private void skip(int numSymbols) {
        this.index += numSymbols;
    }

    private void skipWhitespacesAndComments() {
        boolean commentSkipped;
        do {
            commentSkipped = false;
            while (this.accept('\r', '\n', ' ', '\t')) {
                this.skip();
            }
            if (this.acceptSequence('/', '/')) {
                this.skip(2);
                this.readInputUntil('\r', '\n');
                commentSkipped = true;
                continue;
            }
            if (!this.acceptSequence('/', '*')) continue;
            this.skip(2);
            while (this.index < this.data.length) {
                if (this.acceptSequence('*', '/')) {
                    this.skip(2);
                    break;
                }
                this.skip();
            }
            commentSkipped = true;
        } while (commentSkipped);
    }

    private String readInputUntil(char ... symbols) {
        StringBuilder strBuf = new StringBuilder();
        while (this.index < this.data.length && !this.accept(symbols)) {
            strBuf.append(this.data[this.index]);
            this.skip();
        }
        return strBuf.toString();
    }

    private String readInputUntil(char symbol) {
        StringBuilder strBuf = new StringBuilder();
        while (this.index < this.data.length && !this.accept(symbol)) {
            strBuf.append(this.data[this.index]);
            this.skip();
        }
        return strBuf.toString();
    }

    public NSObject parse() throws ParseException {
        this.index = 0;
        if (this.data.length == 0) {
            throw new ParseException("The property list is empty.", 0);
        }
        if (this.data[0] == '\ufeff') {
            this.skip(1);
        }
        this.skipWhitespacesAndComments();
        this.expect('{', '(', '/');
        try {
            return this.parseObject();
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            throw new ParseException("Reached end of input unexpectedly.", this.index);
        }
    }

    private NSObject parseObject() throws ParseException {
        switch (this.data[this.index]) {
            case '(': {
                return this.parseArray();
            }
            case '{': {
                return this.parseDictionary();
            }
            case '<': {
                return this.parseData();
            }
            case '\"': {
                String quotedString = this.parseQuotedString();
                if (quotedString.length() == 20 && quotedString.charAt(4) == '-') {
                    try {
                        return new NSDate(quotedString);
                    }
                    catch (Exception ex) {
                        return new NSString(quotedString);
                    }
                }
                return new NSString(quotedString);
            }
        }
        if (this.data[this.index] >= '0' && this.data[this.index] <= '9') {
            return this.parseDateString();
        }
        return new NSString(this.parseString());
    }

    private NSArray parseArray() throws ParseException {
        this.skip();
        this.skipWhitespacesAndComments();
        LinkedList<NSObject> objects = new LinkedList<NSObject>();
        while (!this.accept(')')) {
            objects.add(this.parseObject());
            this.skipWhitespacesAndComments();
            if (!this.accept(',')) break;
            this.skip();
            this.skipWhitespacesAndComments();
        }
        this.read(')');
        return new NSArray(objects.toArray(new NSObject[objects.size()]));
    }

    private NSDictionary parseDictionary() throws ParseException {
        this.skip();
        this.skipWhitespacesAndComments();
        NSDictionary dict = new NSDictionary();
        while (!this.accept('}')) {
            String keyString = this.accept('\"') ? this.parseQuotedString() : this.parseString();
            this.skipWhitespacesAndComments();
            this.read('=');
            this.skipWhitespacesAndComments();
            NSObject object = this.parseObject();
            dict.put(keyString, object);
            this.skipWhitespacesAndComments();
            this.read(';');
            this.skipWhitespacesAndComments();
        }
        this.skip();
        return dict;
    }

    private NSObject parseData() throws ParseException {
        NSObject obj = null;
        this.skip();
        if (this.accept('*')) {
            this.skip();
            this.expect('B', 'D', 'I', 'R');
            if (this.accept('B')) {
                this.skip();
                this.expect('Y', 'N');
                obj = this.accept('Y') ? new NSNumber(true) : new NSNumber(false);
                this.skip();
            } else if (this.accept('D')) {
                this.skip();
                String dateString = this.readInputUntil('>');
                obj = new NSDate(dateString);
            } else if (this.accept('I', 'R')) {
                this.skip();
                String numberString = this.readInputUntil('>');
                try {
                    obj = new NSNumber(numberString);
                }
                catch (IllegalArgumentException ex) {
                    throw new ParseException("The NSNumber object has an invalid format.", this.index);
                }
            }
            this.read('>');
        } else if (this.accept('[')) {
            this.skip();
            int dataStartIndex = this.index;
            String dataString = this.readInputUntil(']');
            try {
                obj = new NSData(dataString);
            }
            catch (IOException e) {
                throw new ParseException("The NSData object could be parsed.", dataStartIndex);
            }
            this.skip();
            this.read('>');
        } else {
            int dataStartIndex = this.index;
            String dataString = this.readInputUntil('>');
            dataString = dataString.replaceAll("\\s+", "");
            int numBytes = dataString.length() / 2;
            byte[] bytes = new byte[numBytes];
            int bi = 0;
            int ci = 0;
            while (bi < bytes.length) {
                int nibble1 = Character.digit(dataString.charAt(ci), 16);
                int nibble2 = Character.digit(dataString.charAt(ci + 1), 16);
                if (nibble1 == -1 || nibble2 == -1) {
                    throw new ParseException("The NSData object contains non-hexadecimal characters.", dataStartIndex);
                }
                bytes[bi] = (byte)(nibble1 << 4 | nibble2);
                ++bi;
                ci += 2;
            }
            obj = new NSData(bytes);
            this.skip();
        }
        return obj;
    }

    private NSObject parseDateString() {
        String numericalString = this.parseString();
        if (numericalString.length() > 4 && numericalString.charAt(4) == '-') {
            try {
                return new NSDate(numericalString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new NSString(numericalString);
    }

    private String parseString() {
        return this.readInputUntil(' ', '\t', '\n', '\r', ',', ';', '=', ')');
    }

    private String parseQuotedString() throws ParseException {
        String unescapedString;
        this.skip();
        StringBuilder stringBuilder = new StringBuilder();
        boolean unescapedBackslash = true;
        while (this.data[this.index] != '\"' || this.data[this.index - 1] == '\\' && unescapedBackslash) {
            stringBuilder.append(this.data[this.index]);
            if (this.accept('\\')) {
                unescapedBackslash = this.data[this.index - 1] != '\\' || !unescapedBackslash;
            }
            this.skip();
        }
        try {
            unescapedString = ASCIIPropertyListParser.parseQuotedString(stringBuilder.toString());
        }
        catch (ParseException ex) {
            throw new ParseException(ex.getMessage(), this.index + ex.getErrorOffset());
        }
        catch (Exception ex) {
            throw new ParseException("A quoted string could not be parsed.", this.index);
        }
        this.skip();
        return unescapedString;
    }

    private static synchronized String parseQuotedString(String s2) throws ParseException {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(s2);
        char c = iterator.current();
        while (iterator.getIndex() < iterator.getEndIndex()) {
            if (c == '\\') {
                result.append(ASCIIPropertyListParser.parseEscapedSequence(iterator));
            } else {
                result.append(c);
            }
            c = iterator.next();
        }
        return result.toString();
    }

    private static char parseEscapedSequence(StringCharacterIterator iterator) throws ParseException {
        char c = iterator.next();
        switch (c) {
            case '\"': 
            case '\'': 
            case '\\': {
                return c;
            }
            case 'b': {
                return '\b';
            }
            case 'n': {
                return '\n';
            }
            case 'r': {
                return '\r';
            }
            case 't': {
                return '\t';
            }
            case 'U': 
            case 'u': {
                String unicodeValue = new String(new char[]{iterator.next(), iterator.next(), iterator.next(), iterator.next()});
                try {
                    return (char)Integer.parseInt(unicodeValue, 16);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("The property list contains a string with an invalid escape sequence: \\" + c + unicodeValue, iterator.getIndex() - 4);
                }
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                String num = new String(new char[]{c, iterator.next(), iterator.next()});
                try {
                    return (char)Integer.parseInt(num, 8);
                }
                catch (NumberFormatException ex) {
                    throw new ParseException("The property list contains a string with an invalid escape sequence: \\" + num, iterator.getIndex() - 2);
                }
            }
        }
        throw new ParseException("The property list contains a string with an invalid escape sequence: \\" + c, iterator.getIndex());
    }
}

