/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.Ole10Native;
import org.apache.poi.poifs.filesystem.Ole10NativeException;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.zip.DefaultZipContainerDetector;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.PasswordProvider;
import org.apache.tika.parser.microsoft.OfficeParser;
import org.apache.tika.parser.microsoft.OfficeParserConfig;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.SAXException;

abstract class AbstractPOIFSExtractor {
    protected final Metadata parentMetadata;
    protected final OfficeParserConfig officeParserConfig;
    protected final ParseContext context;
    private final EmbeddedDocumentUtil embeddedDocumentUtil;
    private PasswordProvider passwordProvider;

    protected AbstractPOIFSExtractor(ParseContext context) {
        this(context, null);
    }

    protected AbstractPOIFSExtractor(ParseContext context, Metadata parentMetadata) {
        this.embeddedDocumentUtil = new EmbeddedDocumentUtil(context);
        this.passwordProvider = context.get(PasswordProvider.class);
        this.officeParserConfig = context.get(OfficeParserConfig.class, new OfficeParserConfig());
        this.parentMetadata = parentMetadata;
        this.context = context;
    }

    protected TikaConfig getTikaConfig() {
        return this.embeddedDocumentUtil.getTikaConfig();
    }

    protected Detector getDetector() {
        return this.embeddedDocumentUtil.getDetector();
    }

    protected MimeTypes getMimeTypes() {
        return this.embeddedDocumentUtil.getMimeTypes();
    }

    protected String getPassword() {
        if (this.passwordProvider != null) {
            return this.passwordProvider.getPassword(this.parentMetadata);
        }
        return null;
    }

    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String relationshipID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedResource(resource, filename, relationshipID, null, mediaType, xhtml, outputHtml);
    }

    protected void handleEmbeddedResource(TikaInputStream resource, String filename, String relationshipID, ClassID storageClassID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedResource(resource, new Metadata(), filename, relationshipID, storageClassID, mediaType, xhtml, outputHtml);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleEmbeddedResource(TikaInputStream resource, Metadata embeddedMetadata, String filename, String relationshipID, ClassID storageClassID, String mediaType, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        try {
            if (filename != null) {
                embeddedMetadata.set("resourceName", filename);
            }
            if (relationshipID != null) {
                embeddedMetadata.set("embeddedRelationshipId", relationshipID);
            }
            if (storageClassID != null) {
                embeddedMetadata.set("embeddedStorageClassId", storageClassID.toString());
            }
            if (mediaType != null) {
                embeddedMetadata.set("Content-Type", mediaType);
            }
            if (this.embeddedDocumentUtil.shouldParseEmbedded(embeddedMetadata)) {
                this.embeddedDocumentUtil.parseEmbedded(resource, xhtml, embeddedMetadata, outputHtml);
            }
        }
        finally {
            resource.close();
        }
    }

    protected void handleEmbeddedOfficeDoc(DirectoryEntry dir, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        this.handleEmbeddedOfficeDoc(dir, null, xhtml, outputHtml);
    }

    protected void handleEmbeddedOfficeDoc(DirectoryEntry dir, String resourceName, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException, TikaException {
        String rName;
        Entry ooxml;
        Entry entry = dir.hasEntry("Package") ? dir.getEntry("Package") : (ooxml = dir.hasEntry("package") ? dir.getEntry("package") : null);
        if (ooxml != null) {
            Metadata metadata = new Metadata();
            metadata.set("Content-Length", Integer.toString(((DocumentEntry)ooxml).getSize()));
            TikaInputStream stream = TikaInputStream.get(new DocumentInputStream((DocumentEntry)ooxml));
            try {
                DefaultZipContainerDetector detector = new DefaultZipContainerDetector();
                MediaType type = null;
                try {
                    type = detector.detect(stream, metadata);
                }
                catch (SecurityException e) {
                    throw e;
                }
                catch (Exception e) {
                    EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
                    if (stream != null) {
                        stream.close();
                    }
                    return;
                }
                this.handleEmbeddedResource(stream, metadata, null, dir.getName(), dir.getStorageClsid(), type.toString(), xhtml, outputHtml);
                return;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {
                        Throwable detector;
                        detector.addSuppressed(throwable);
                    }
                }
            }
        }
        Metadata metadata = new Metadata();
        metadata.set("embeddedRelationshipId", dir.getName());
        if (dir.getStorageClsid() != null) {
            metadata.set("embeddedStorageClassId", dir.getStorageClsid().toString());
        }
        OfficeParser.POIFSDocumentType type = OfficeParser.POIFSDocumentType.detectType(dir);
        String string = rName = resourceName == null ? dir.getName() : resourceName;
        if (type == OfficeParser.POIFSDocumentType.OLE10_NATIVE) {
            this.handleOLENative(dir, type, rName, metadata, xhtml, outputHtml);
        } else if (type == OfficeParser.POIFSDocumentType.COMP_OBJ) {
            this.handleCompObj(dir, type, rName, metadata, xhtml, outputHtml);
        } else {
            metadata.set("Content-Type", type.getType().toString());
            metadata.set("resourceName", rName + '.' + type.getExtension());
            this.parseEmbedded(dir, xhtml, metadata, outputHtml);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCompObj(DirectoryEntry dir, OfficeParser.POIFSDocumentType type, String rName, Metadata metadata, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException {
        DocumentEntry contentsEntry;
        try {
            contentsEntry = (DocumentEntry)dir.getEntry("CONTENTS");
        }
        catch (FileNotFoundException fnfe1) {
            try {
                contentsEntry = (DocumentEntry)dir.getEntry("Contents");
            }
            catch (FileNotFoundException fnfe2) {
                EmbeddedDocumentUtil.recordEmbeddedStreamException(fnfe2, this.parentMetadata);
                return;
            }
        }
        int length = contentsEntry.getSize();
        DocumentInputStream inp = null;
        try {
            inp = new DocumentInputStream(contentsEntry);
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
            return;
        }
        try (TikaInputStream tis = TikaInputStream.get(inp);){
            MediaType mediaType = this.getDetector().detect(tis, metadata);
            String extension = type.getExtension();
            try {
                MimeType mimeType = this.getMimeTypes().forName(mediaType.toString());
                extension = mimeType.getExtension();
            }
            catch (MimeTypeException mimeTypeException) {
                // empty catch block
            }
            metadata.set("Content-Type", mediaType.getType());
            metadata.set("resourceName", rName + extension);
            metadata.set("Content-Length", Integer.toString(length));
            this.parseEmbedded(dir, tis, xhtml, metadata, outputHtml);
        }
        finally {
            inp.close();
        }
    }

    private void handleOLENative(DirectoryEntry dir, OfficeParser.POIFSDocumentType type, String rName, Metadata metadata, XHTMLContentHandler xhtml, boolean outputHtml) throws IOException, SAXException {
        byte[] data = null;
        try {
            Ole10Native ole = Ole10Native.createFromEmbeddedOleObject((DirectoryNode)dir);
            if (ole.getLabel() != null) {
                metadata.set("resourceName", rName + '/' + ole.getLabel());
            } else {
                metadata.add("resourceName", rName);
            }
            if (ole.getCommand() != null) {
                metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getCommand());
            }
            if (ole.getFileName() != null) {
                metadata.add(TikaCoreProperties.ORIGINAL_RESOURCE_NAME, ole.getFileName());
            }
            data = ole.getDataBuffer();
            metadata.set("Content-Length", Integer.toString(data.length));
        }
        catch (Ole10NativeException ole) {
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            EmbeddedDocumentUtil.recordEmbeddedStreamException(e, this.parentMetadata);
            return;
        }
        try (TikaInputStream tis = TikaInputStream.get(data);){
            this.parseEmbedded(dir, tis, xhtml, metadata, outputHtml);
        }
    }

    private void parseEmbedded(DirectoryEntry dir, TikaInputStream tis, XHTMLContentHandler xhtml, Metadata metadata, boolean outputHtml) throws IOException, SAXException {
        if (!this.embeddedDocumentUtil.shouldParseEmbedded(metadata)) {
            return;
        }
        if (dir.getStorageClsid() != null) {
            metadata.set("embeddedStorageClassId", dir.getStorageClsid().toString());
        }
        this.embeddedDocumentUtil.parseEmbedded(tis, xhtml, metadata, outputHtml);
    }

    private void parseEmbedded(DirectoryEntry dir, XHTMLContentHandler xhtml, Metadata metadata, boolean outputHtml) throws IOException, SAXException {
        if (!this.embeddedDocumentUtil.shouldParseEmbedded(metadata)) {
            return;
        }
        try (TikaInputStream tis = TikaInputStream.get(new byte[0]);){
            tis.setOpenContainer(dir);
            if (dir.getStorageClsid() != null) {
                metadata.set("embeddedStorageClassId", dir.getStorageClsid().toString());
            }
            this.embeddedDocumentUtil.parseEmbedded(tis, xhtml, metadata, outputHtml);
        }
    }
}

