/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.tmx;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.tmx.TMXContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.XMLReaderUtils;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class TMXParser
extends AbstractParser {
    private static final long serialVersionUID = 2305588935434276452L;
    private static final MediaType TMX_CONTENT_TYPE = MediaType.application("x-tmx");
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(TMX_CONTENT_TYPE);

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        metadata.set("Content-Type", TMX_CONTENT_TYPE.toString());
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        XMLReaderUtils.parseSAX(CloseShieldInputStream.wrap(stream), (ContentHandler)new TMXContentHandler(xhtml, metadata), context);
    }
}

