/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.warc;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.exception.WriteLimitReachedException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.WARC;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.sax.XHTMLContentHandler;
import org.apache.tika.utils.StringUtils;
import org.netpreserve.jwarc.HttpResponse;
import org.netpreserve.jwarc.WarcPayload;
import org.netpreserve.jwarc.WarcReader;
import org.netpreserve.jwarc.WarcRecord;
import org.netpreserve.jwarc.WarcResponse;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class WARCParser
extends AbstractParser {
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application("warc"))));
    public static String WARC_PREFIX = "warc:";
    public static String WARC_HTTP_PREFIX = WARC_PREFIX + "http:";
    public static String WARC_HTTP_STATUS = WARC_HTTP_PREFIX + "status";
    public static String WARC_HTTP_STATUS_REASON = WARC_HTTP_PREFIX + "status:reason";
    private static String RESPONSE = "response";
    private static String WARCINFO = "warcinfo";

    @Override
    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        EmbeddedDocumentExtractor embeddedDocumentExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor(context);
        try (WarcReader warcreader = new WarcReader(stream);){
            for (WarcRecord record : warcreader) {
                this.processRecord(record, xhtml, metadata, context, embeddedDocumentExtractor);
            }
        }
        finally {
            xhtml.endDocument();
        }
    }

    private void processRecord(WarcRecord record, XHTMLContentHandler xhtml, Metadata metadata, ParseContext context, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws SAXException {
        if (RESPONSE.equals(record.type())) {
            try {
                this.processResponse((WarcResponse)record, xhtml, context, embeddedDocumentExtractor);
            }
            catch (IOException | TikaException e) {
                EmbeddedDocumentUtil.recordException(e, metadata);
            }
            catch (SAXException e) {
                if (WriteLimitReachedException.isWriteLimitReached(e)) {
                    throw e;
                }
                EmbeddedDocumentUtil.recordException(e, metadata);
            }
        } else if (WARCINFO.equals(record.type())) {
            this.processWarcInfo(record, xhtml, context);
        }
    }

    private void processWarcInfo(WarcRecord record, XHTMLContentHandler xhtml, ParseContext context) {
    }

    private void processResponse(WarcResponse warcResponse, XHTMLContentHandler xhtml, ParseContext context, EmbeddedDocumentExtractor embeddedDocumentExtractor) throws IOException, SAXException, TikaException {
        Optional<WarcPayload> optionalPayload = warcResponse.payload();
        if (!optionalPayload.isPresent()) {
            return;
        }
        Metadata metadata = new Metadata();
        this.setNotNull(WARC.WARC_RECORD_CONTENT_TYPE, warcResponse.contentType(), metadata);
        this.setNotNull(WARC.WARC_PAYLOAD_CONTENT_TYPE, warcResponse.payloadType(), metadata);
        this.processWarcMetadata(warcResponse, metadata);
        this.processHttpResponseMetadata(warcResponse.http(), metadata);
        String id = warcResponse.id().toString();
        metadata.set("resourceName", id);
        WarcPayload payload = optionalPayload.get();
        metadata.set(WARC.WARC_RECORD_CONTENT_TYPE, payload.type().toString());
        metadata.set("Content-Length", Long.toString(payload.body().size()));
        if (embeddedDocumentExtractor.shouldParseEmbedded(metadata)) {
            try (TikaInputStream tis = TikaInputStream.get(payload.body().stream());){
                embeddedDocumentExtractor.parseEmbedded(tis, xhtml, metadata, true);
            }
        }
    }

    private void processWarcMetadata(WarcResponse warcResponse, Metadata metadata) {
        for (Map.Entry<String, List<String>> e : warcResponse.headers().map().entrySet()) {
            for (String val : e.getValue()) {
                metadata.add(WARC_PREFIX + e.getKey(), val);
            }
        }
    }

    private void processHttpResponseMetadata(HttpResponse http, Metadata metadata) {
        metadata.set(WARC_HTTP_STATUS, Integer.toString(http.status()));
        if (!StringUtils.isBlank(http.reason())) {
            metadata.set(WARC_HTTP_STATUS_REASON, http.reason());
        }
        for (Map.Entry<String, List<String>> e : http.headers().map().entrySet()) {
            for (String val : e.getValue()) {
                metadata.add(WARC_HTTP_PREFIX + e.getKey(), val);
            }
        }
    }

    private void setNotNull(Property key, org.netpreserve.jwarc.MediaType contentType, Metadata metadata) {
        if (contentType == null) {
            return;
        }
        metadata.set(key, contentType.toString());
    }
}

