/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.fs;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceCrawler;
import org.apache.tika.batch.fs.FSFileResource;

public class FSListCrawler
extends FileResourceCrawler {
    private final BufferedReader reader;
    private final Path root;

    @Deprecated
    public FSListCrawler(ArrayBlockingQueue<FileResource> fileQueue, int numConsumers, File root, File list, String encoding) throws FileNotFoundException, UnsupportedEncodingException {
        super(fileQueue, numConsumers);
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(list), encoding));
        this.root = Paths.get(root.toURI());
    }

    public FSListCrawler(ArrayBlockingQueue<FileResource> fileQueue, int numConsumers, Path root, Path list, Charset charset) throws IOException {
        super(fileQueue, numConsumers);
        this.reader = Files.newBufferedReader(list, charset);
        this.root = root;
    }

    @Override
    public void start() throws InterruptedException {
        String line = this.nextLine();
        while (line != null) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException("file adder interrupted");
            }
            Path f = Paths.get(this.root.toString(), line);
            if (!Files.exists(f, new LinkOption[0])) {
                logger.warn("File doesn't exist:" + f.toAbsolutePath());
                line = this.nextLine();
                continue;
            }
            if (Files.isDirectory(f, new LinkOption[0])) {
                logger.warn("File is a directory:" + f.toAbsolutePath());
                line = this.nextLine();
                continue;
            }
            this.tryToAdd(new FSFileResource(this.root, f));
            line = this.nextLine();
        }
    }

    private String nextLine() {
        String line = null;
        try {
            line = this.reader.readLine();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return line;
    }
}

