/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.io.IOUtils;
import org.apache.tika.batch.BatchProcess;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcessDriverCLI {
    public static final int PROCESS_RESTART_EXIT_CODE = 253;
    public static final int PROCESS_NO_RESTART_EXIT_CODE = 254;
    public static final int PROCESS_COMPLETED_SUCCESSFULLY = 0;
    private static final Logger LOG = LoggerFactory.getLogger(BatchProcessDriverCLI.class);
    private int maxProcessRestarts = -1;
    private long pulseMillis = 1000L;
    private int waitNumLoopsAfterRestartMessage = 60;
    private int loopsAfterRestartMessageReceived = 0;
    private volatile boolean userInterrupted = false;
    private boolean receivedRestartMsg = false;
    private Process process = null;
    private StreamGobbler errorWatcher = null;
    private StreamGobbler outGobbler = null;
    private InterruptWriter interruptWriter = null;
    private final InterruptWatcher interruptWatcher = new InterruptWatcher(System.in);
    private Thread errorWatcherThread = null;
    private Thread outGobblerThread = null;
    private Thread interruptWriterThread = null;
    private final Thread interruptWatcherThread = new Thread(this.interruptWatcher);
    private final String[] commandLine;
    private int numRestarts = 0;
    private boolean redirectForkedProcessToStdOut = true;

    public BatchProcessDriverCLI(String[] commandLine) {
        this.commandLine = this.tryToReadMaxRestarts(commandLine);
    }

    private String[] tryToReadMaxRestarts(String[] commandLine) {
        ArrayList<String> args = new ArrayList<String>();
        for (int i = 0; i < commandLine.length; ++i) {
            String arg = commandLine[i];
            if (arg.equals("-maxRestarts")) {
                if (i == commandLine.length - 1) {
                    throw new IllegalArgumentException("Must specify an integer after \"-maxRestarts\"");
                }
                String restartNumString = commandLine[i + 1];
                try {
                    this.maxProcessRestarts = Integer.parseInt(restartNumString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("Must specify an integer after \"-maxRestarts\" arg.");
                }
                ++i;
                continue;
            }
            args.add(arg);
        }
        return args.toArray(new String[0]);
    }

    public void execute() throws Exception {
        this.interruptWatcherThread.setDaemon(true);
        this.interruptWatcherThread.start();
        LOG.info("about to start driver");
        this.start();
        while (!this.userInterrupted) {
            Integer exit = null;
            try {
                LOG.trace("about to check exit value");
                exit = this.process.exitValue();
                LOG.info("The forked process has finished with an exit value of: {}", (Object)exit);
                this.stop();
            }
            catch (IllegalThreadStateException e) {
                LOG.trace("process has not exited; IllegalThreadStateException");
            }
            LOG.trace("Before sleep: exit={} receivedRestartMsg={}", (Object)exit, (Object)this.receivedRestartMsg);
            try {
                Thread.sleep(this.pulseMillis);
            }
            catch (InterruptedException e) {
                LOG.trace("interrupted exception during sleep");
            }
            LOG.trace("After sleep: exit={} receivedRestartMsg={}", (Object)exit, (Object)this.receivedRestartMsg);
            if (this.receivedRestartMsg && exit == null && this.loopsAfterRestartMessageReceived <= this.waitNumLoopsAfterRestartMessage) {
                ++this.loopsAfterRestartMessageReceived;
                LOG.warn("Must restart, still not exited; loops after restart: {}", (Object)this.loopsAfterRestartMessageReceived);
                continue;
            }
            if (this.loopsAfterRestartMessageReceived > this.waitNumLoopsAfterRestartMessage) {
                LOG.trace("About to try to restart because: exit={} receivedRestartMsg={}", (Object)exit, (Object)this.receivedRestartMsg);
                LOG.warn("Restarting after exceeded wait loops waiting for exit: {}", (Object)this.loopsAfterRestartMessageReceived);
                boolean restarted = this.restart(exit, this.receivedRestartMsg);
                if (restarted) continue;
                break;
            }
            if (exit != null && exit != 254 && exit != 0) {
                boolean restarted;
                LOG.trace("About to try to restart because: exit={} receivedRestartMsg={}", (Object)exit, (Object)this.receivedRestartMsg);
                if (exit == 253) {
                    LOG.info("Restarting on expected restart code");
                } else {
                    LOG.warn("Restarting on unexpected restart code: {}", (Object)exit);
                }
                if (restarted = this.restart(exit, this.receivedRestartMsg)) continue;
                break;
            }
            if (exit == null || exit != 0 && exit != 254) continue;
            LOG.trace("Will not restart: {}", (Object)exit);
            break;
        }
        LOG.trace("about to call shutdown driver now");
        this.shutdownDriverNow();
        LOG.info("Process driver has completed");
    }

    private void shutdownDriverNow() {
        if (this.process != null) {
            for (int i = 0; i < 60; ++i) {
                LOG.trace("trying to shut down: {}", (Object)i);
                try {
                    int exit = this.process.exitValue();
                    LOG.trace("trying to stop: {}", (Object)exit);
                    this.stop();
                    this.interruptWatcherThread.interrupt();
                    return;
                }
                catch (IllegalThreadStateException illegalThreadStateException) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            LOG.error("Process didn't stop after 60 seconds after shutdown. I am forcefully terminating it.");
        }
        this.interruptWatcherThread.interrupt();
    }

    public int getNumRestarts() {
        return this.numRestarts;
    }

    public boolean isUserInterrupted() {
        return this.userInterrupted;
    }

    private boolean restart(Integer exitValue, boolean receivedRestartMsg) throws Exception {
        if (this.maxProcessRestarts > -1 && this.numRestarts >= this.maxProcessRestarts) {
            LOG.warn("Hit the maximum number of process restarts. Driver is shutting down now.");
            this.stop();
            return false;
        }
        LOG.warn("Must restart process (exitValue={} numRestarts={} receivedRestartMessage={})", new Object[]{exitValue, this.numRestarts, receivedRestartMsg});
        this.stop();
        this.start();
        ++this.numRestarts;
        this.loopsAfterRestartMessageReceived = 0;
        return true;
    }

    private void stop() {
        if (this.process != null) {
            LOG.trace("destroying a non-null process");
            this.process.destroyForcibly();
        }
        this.receivedRestartMsg = false;
        this.interruptWriterThread.interrupt();
        this.errorWatcher.stopGobblingAndDie();
        this.outGobbler.stopGobblingAndDie();
        this.errorWatcherThread.interrupt();
        this.outGobblerThread.interrupt();
    }

    private void start() throws Exception {
        ProcessBuilder builder = new ProcessBuilder(this.commandLine);
        builder.directory(Paths.get(".", new String[0]).toFile());
        this.process = builder.start();
        this.errorWatcher = new StreamWatcher(this.process.getErrorStream());
        this.errorWatcherThread = new Thread(this.errorWatcher);
        this.errorWatcherThread.start();
        this.outGobbler = new StreamGobbler(this.process.getInputStream());
        this.outGobblerThread = new Thread(this.outGobbler);
        this.outGobblerThread.start();
        this.interruptWriter = new InterruptWriter(this.process.getOutputStream());
        this.interruptWriterThread = new Thread(this.interruptWriter);
        this.interruptWriterThread.start();
    }

    public void setRedirectForkedProcessToStdOut(boolean redirectForkedProcessToStdOut) {
        this.redirectForkedProcessToStdOut = redirectForkedProcessToStdOut;
    }

    public static void main(String[] args) throws Exception {
        final BatchProcessDriverCLI runner = new BatchProcessDriverCLI(args);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                runner.stop();
            }
        });
        runner.execute();
        System.out.println("FSBatchProcessDriver has gracefully completed");
        System.exit(0);
    }

    private class StreamWatcher
    extends StreamGobbler
    implements Runnable {
        private StreamWatcher(InputStream is) {
            super(is);
        }

        @Override
        public void run() {
            String line = null;
            try {
                LOG.trace("watcher starting to read");
                while ((line = this.reader.readLine()) != null && this.running) {
                    if (line.startsWith(BatchProcess.BATCH_CONSTANTS.BATCH_PROCESS_FATAL_MUST_RESTART.toString())) {
                        BatchProcessDriverCLI.this.receivedRestartMsg = true;
                    }
                    LOG.info("BatchProcess: " + line);
                }
            }
            catch (IOException e) {
                LOG.trace("watcher io exception");
            }
            LOG.trace("watcher done");
        }
    }

    private class StreamGobbler
    implements Runnable {
        protected final BufferedReader reader;
        protected boolean running = true;

        private StreamGobbler(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(is), StandardCharsets.UTF_8));
        }

        @Override
        public void run() {
            String line = null;
            try {
                LOG.trace("gobbler starting to read");
                while ((line = this.reader.readLine()) != null && this.running) {
                    if (!BatchProcessDriverCLI.this.redirectForkedProcessToStdOut) continue;
                    System.out.println("BatchProcess:" + line);
                }
            }
            catch (IOException e) {
                LOG.trace("gobbler io exception");
            }
            LOG.trace("gobbler done");
        }

        private void stopGobblingAndDie() {
            LOG.trace("stop gobbling");
            this.running = false;
            IOUtils.closeQuietly((Reader)this.reader);
        }
    }

    private class InterruptWriter
    implements Runnable {
        private final Writer writer;

        private InterruptWriter(OutputStream os) {
            this.writer = new OutputStreamWriter(os, StandardCharsets.UTF_8);
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Thread.sleep(500L);
                    if (!BatchProcessDriverCLI.this.userInterrupted) continue;
                    this.writer.write(String.format(Locale.ENGLISH, "Ave atque vale!%n", new Object[0]));
                    this.writer.flush();
                }
            }
            catch (IOException iOException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private class InterruptWatcher
    implements Runnable {
        private BufferedReader reader;

        private InterruptWatcher(InputStream is) {
            this.reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));
        }

        @Override
        public void run() {
            try {
                this.reader.readLine();
                BatchProcessDriverCLI.this.userInterrupted = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

