/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch.builders;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilder;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.IOExceptionWithCause;
import org.apache.tika.exception.TikaException;
import org.apache.tika.utils.XMLReaderUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommandLineParserBuilder {
    public Options build(InputStream is) throws IOException {
        Document doc = null;
        try {
            DocumentBuilder docBuilder = XMLReaderUtils.getDocumentBuilder();
            doc = docBuilder.parse(is);
        }
        catch (TikaException | SAXException e) {
            throw new IOExceptionWithCause(e);
        }
        Element docElement = doc.getDocumentElement();
        NodeList children = docElement.getChildNodes();
        Node commandlineNode = null;
        for (int i = 0; i < children.getLength(); ++i) {
            String nodeName;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(nodeName = child.getNodeName()).equals("commandline")) continue;
            commandlineNode = child;
            break;
        }
        Options options = new Options();
        if (commandlineNode == null) {
            return options;
        }
        NodeList optionNodes = commandlineNode.getChildNodes();
        for (int i = 0; i < optionNodes.getLength(); ++i) {
            Option opt;
            Node optionNode = optionNodes.item(i);
            if (optionNode.getNodeType() != 1 || (opt = this.buildOption(optionNode)) == null) continue;
            options.addOption(opt);
        }
        return options;
    }

    private Option buildOption(Node optionNode) {
        NamedNodeMap map = optionNode.getAttributes();
        String opt = this.getString(map, "opt", "");
        String description = this.getString(map, "description", "");
        String longOpt = this.getString(map, "longOpt", "");
        boolean isRequired = this.getBoolean(map, "required", false);
        boolean hasArg = this.getBoolean(map, "hasArg", false);
        if (opt.trim().length() == 0 || description.trim().length() == 0) {
            throw new IllegalArgumentException("Must specify at least option and description");
        }
        Option option = new Option(opt, description);
        if (longOpt.trim().length() > 0) {
            option.setLongOpt(longOpt);
        }
        if (isRequired) {
            option.setRequired(true);
        }
        if (hasArg) {
            option.setArgs(1);
        }
        return option;
    }

    private boolean getBoolean(NamedNodeMap map, String opt, boolean defaultValue) {
        Node n = map.getNamedItem(opt);
        if (n == null) {
            return defaultValue;
        }
        if (n.getNodeValue() == null) {
            return defaultValue;
        }
        if (n.getNodeValue().toLowerCase(Locale.ROOT).equals("true")) {
            return true;
        }
        if (n.getNodeValue().toLowerCase(Locale.ROOT).equals("false")) {
            return false;
        }
        return defaultValue;
    }

    private String getString(NamedNodeMap map, String opt, String defaultVal) {
        Node n = map.getNamedItem(opt);
        if (n == null) {
            return defaultVal;
        }
        String value = n.getNodeValue();
        if (value == null) {
            return defaultVal;
        }
        return value;
    }
}

