/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.LambertAzimuthalEqualArea;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.UtmProjection;

public class M3IOVGGridConvention
extends CoordSysBuilder {
    private static final int GRDDED3 = 1;
    private static final int IDDATA3 = 3;
    private static final int PTRFLY3 = 8;
    private static final int MXLAYS3 = 100;
    private static final int MXVARS3 = 120;
    private static final int NAMLEN3 = 16;
    private static final int LATGRD3 = 1;
    private static final int LAMGRD3 = 2;
    private static final int MERGRD3 = 3;
    private static final int STEGRD3 = 4;
    private static final int UTMGRD3 = 5;
    private static final int POLGRD3 = 6;
    private static final int EQMGRD3 = 7;
    private static final int TRMGRD3 = 8;
    private static final int ALBGRD3 = 9;
    private static final int LEQGRD3 = 10;
    private static final int VGSGPH3 = 1;
    private static final int VGSGPN3 = 2;
    private static final int VGSIGZ3 = 3;
    private static final int VGPRES3 = 4;
    private static final int VGZVAL3 = 5;
    private static final int VGHVAL3 = 6;
    private static final int IMISS3 = -9999;
    private static final double BADVAL3 = -9.999E36;
    private static final double AMISS3 = -9.0E36;
    private static final double SURFACE_PRESSURE_IN_MB = 1012.5;
    private CoordinateTransform ct = null;
    private NetcdfDataset ncd = null;

    public static boolean isMine(NetcdfFile ncFile) {
        return ncFile.findGlobalAttribute("VGLVLS") != null && M3IOVGGridConvention.isValidM3IOFile_(ncFile);
    }

    public M3IOVGGridConvention() {
        this.conventionName = "M3IOVGGrid";
    }

    @Override
    public void augmentDataset(NetcdfDataset ncd, CancelTask cancelTask) {
        this.ncd = ncd;
        this.constructCoordAxes(ncd);
        ncd.finish();
    }

    protected void constructCoordAxes(NetcdfDataset ds) {
        if (null != this.ncd.findVariable("x")) {
            return;
        }
        int gdtyp = this.intAttribute("GDTYP");
        double p_alp = this.doubleAttribute("P_ALP");
        double p_bet = this.doubleAttribute("P_BET");
        double p_gam = this.doubleAttribute("P_GAM");
        double xcent = this.doubleAttribute("XCENT");
        double ycent = this.doubleAttribute("YCENT");
        String xUnits = gdtyp == 1 ? "degrees east" : "m";
        String yUnits = gdtyp == 1 ? "degrees north" : "m";
        LatLonProjection p = null;
        switch (gdtyp) {
            case 1: {
                p = new LatLonProjection();
                break;
            }
            case 2: {
                p = new LambertConformal(ycent, p_gam, p_alp, p_bet);
                break;
            }
            case 3: {
                p = new TransverseMercator(p_alp, p_bet, 1.0);
                break;
            }
            case 4: {
                p = new Stereographic(p_alp, p_bet, 1.0);
                break;
            }
            case 5: {
                p = new UtmProjection(6370000.0, 1.0E30, (int)p_alp, ycent >= 0.0);
                break;
            }
            case 6: {
                p = new Stereographic(ycent, xcent, 1.0);
                break;
            }
            case 7: {
                p = new Mercator(p_gam, p_alp);
                break;
            }
            case 8: {
                p = new TransverseMercator(p_alp, p_gam, 1.0);
                break;
            }
            case 9: {
                p = new AlbersEqualArea(ycent, xcent, p_alp, p_bet);
                break;
            }
            case 10: {
                p = new LambertAzimuthalEqualArea(ycent, xcent, 0.0, 0.0, 6370000.0);
                break;
            }
        }
        if (p != null) {
            this.ct = new ProjectionCT(p.getClassName(), "FGDC", (ProjectionImpl)p);
            VariableDS v = this.makeCoordinateTransformVariable(ds, this.ct);
            v.addAttribute(new Attribute("_CoordinateAxisTypes", "GeoX GeoY"));
            ds.addVariable(null, v);
        }
        this.makeXCoordAxis(ds, xUnits);
        this.makeYCoordAxis(ds, yUnits);
        this.makeZCoordAxis(ds);
        this.makeTimeCoordAxis(ds);
    }

    private void makeXCoordAxis(NetcdfDataset ds, String units) {
        Dimension dim = ds.findDimension("COL");
        String newUnits = units.equals("m") ? "km" : units;
        String desc = "synthesized x coordinate from XORIG, XCELL global attributes";
        CoordinateAxis1D axis = new CoordinateAxis1D(ds, null, "x", DataType.DOUBLE, dim.getName(), newUnits, desc);
        double scale = units.equals("m") ? 0.001 : 1.0;
        double xorig = this.doubleAttribute("XORIG") * scale;
        double xcell = this.doubleAttribute("XCELL") * scale;
        ds.setValues(axis, dim.getLength(), xorig, xcell);
        axis.addAttribute(new Attribute("units", newUnits));
        axis.addAttribute(new Attribute("long_name", desc));
        axis.addAttribute(new Attribute("_CoordinateAxisType", AxisType.GeoX.toString()));
        ds.addCoordinateAxis(axis);
    }

    private void makeYCoordAxis(NetcdfDataset ds, String units) {
        Dimension dim = ds.findDimension("ROW");
        String newUnits = units.equals("m") ? "km" : units;
        String desc = "synthesized y coordinate from YORIG, YCELL global attributes";
        CoordinateAxis1D axis = new CoordinateAxis1D(ds, null, "y", DataType.DOUBLE, dim.getName(), newUnits, desc);
        double scale = units.equals("m") ? 0.001 : 1.0;
        double yorig = this.doubleAttribute("YORIG") * scale;
        double ycell = this.doubleAttribute("YCELL") * scale;
        ds.setValues(axis, dim.getLength(), yorig, ycell);
        axis.addAttribute(new Attribute("units", newUnits));
        axis.addAttribute(new Attribute("long_name", desc));
        axis.addAttribute(new Attribute("_CoordinateAxisType", AxisType.GeoY.toString()));
        ds.addCoordinateAxis(axis);
    }

    private void makeZCoordAxis(NetcdfDataset ds) {
        Dimension dim = ds.findDimension("LAY");
        String desc = "synthesized z coordinate from VGTYP, VGTOP, VGLVLS global attributes";
        CoordinateAxis1D axis = new CoordinateAxis1D(ds, null, "z", DataType.DOUBLE, dim.getName(), "km", desc);
        int vgtyp = this.intAttribute("VGTYP");
        double vgtop = this.doubleAttribute("VGTOP");
        double[] vglvls = this.doubleArrayAttribute("VGLVLS");
        double[] vgLevelsInMeters = M3IOVGGridConvention.convertVGLevels_(vgtyp, vgtop, vglvls);
        int count = vgLevelsInMeters.length;
        ArrayList<String> vgArray = new ArrayList<String>(count);
        for (int index = 0; index < count; ++index) {
            vgArray.add(Double.toString(vgLevelsInMeters[index] * 0.001));
        }
        ds.setValues(axis, vgArray);
        axis.addAttribute(new Attribute("units", "km"));
        axis.addAttribute(new Attribute("long_name", desc));
        axis.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Height.toString()));
        ds.addCoordinateAxis(axis);
    }

    private void makeTimeCoordAxis(NetcdfDataset ds) {
        int hhmmss = this.intAttribute("TSTEP");
        int hh = hhmmss / 10000;
        int hh0000 = hh * 10000;
        int mmss = hhmmss - hh0000;
        int mm = mmss / 100;
        int mm00 = mm * 100;
        int ss = mmss - mm00;
        int mm_hh = 60;
        int ss_mm = 60;
        int totalSeconds = hh * 60 * 60 + mm * 60 + ss;
        int timeSteps = M3IOVGGridConvention.dimension_(ds, "TSTEP");
        ArrayInt.D1 data = new ArrayInt.D1(timeSteps);
        for (int timeStep = 0; timeStep < timeSteps; ++timeStep) {
            data.set(timeStep, timeStep * totalSeconds);
        }
        String desc = "synthesized time coordinate from SDATE, STIME, STEP global attributes";
        String units = this.timeUnits();
        CoordinateAxis1D axis = new CoordinateAxis1D(ds, null, "time", DataType.INT, "TSTEP", units, desc);
        axis.setCachedData(data, true);
        axis.addAttribute(new Attribute("long_name", desc));
        axis.addAttribute(new Attribute("units", units));
        axis.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        ds.addCoordinateAxis(axis);
    }

    private String timeUnits() {
        int yyyddd = this.intAttribute("SDATE");
        int hhmmss = this.intAttribute("STIME");
        int yyyy = yyyddd / 1000;
        int ddd = yyyddd % 1000;
        int hh = hhmmss / 10000;
        int hh0000 = hh * 10000;
        int mmss = hhmmss - hh0000;
        int mm = mmss / 100;
        int mm00 = mm * 100;
        int ss = mmss - mm00;
        GregorianCalendar cal = new GregorianCalendar(new SimpleTimeZone(0, "GMT"));
        cal.clear();
        cal.set(1, yyyy);
        cal.set(6, ddd);
        cal.set(11, hh);
        cal.set(12, mm);
        cal.set(13, ss);
        SimpleDateFormat dateFormatOut = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        dateFormatOut.setTimeZone(TimeZone.getTimeZone("GMT"));
        return "seconds since " + dateFormatOut.format(cal.getTime()) + " UTC";
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getName();
        if (vname.equalsIgnoreCase("x")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("time")) {
            return AxisType.Time;
        }
        if (vname.equalsIgnoreCase("z")) {
            return AxisType.Height;
        }
        return null;
    }

    protected String getZPositive(CoordinateAxis axis) {
        String unit = axis.getUnitsString();
        boolean isup = unit != null && SimpleUnit.isCompatible("m", unit);
        return isup ? "up" : "";
    }

    protected List<CoordinateTransform> getCoordinateTransforms(CoordinateSystem cs) {
        ArrayList<CoordinateTransform> list = new ArrayList<CoordinateTransform>();
        if (cs.getXaxis() != null && cs.getYaxis() != null) {
            list.add(this.ct);
        }
        return list;
    }

    protected boolean hasMissingData(Variable v) {
        return true;
    }

    protected double getMissingDataValue(Variable unused) {
        return -9.999E36;
    }

    private int intAttribute(String name) {
        return M3IOVGGridConvention.intAttribute_(this.ncd, name);
    }

    private double doubleAttribute(String name) {
        return M3IOVGGridConvention.doubleAttribute_(this.ncd, name);
    }

    private double[] doubleArrayAttribute(String name) {
        return M3IOVGGridConvention.doubleArrayAttribute_(this.ncd, name);
    }

    private static int intAttribute_(NetcdfFile ncFile, String name) {
        int result = 0;
        Attribute attribute = ncFile.findGlobalAttribute(name);
        if (attribute != null) {
            result = attribute.getNumericValue().intValue();
        }
        return result;
    }

    private static double doubleAttribute_(NetcdfFile ncFile, String name) {
        double result = 0.0;
        Attribute attribute = ncFile.findGlobalAttribute(name);
        if (attribute != null) {
            result = attribute.getNumericValue().doubleValue();
        }
        return result;
    }

    private static double[] doubleArrayAttribute_(NetcdfFile ncFile, String name) {
        double[] result = null;
        Attribute attribute = ncFile.findGlobalAttribute(name);
        if (attribute != null && attribute.isArray() && attribute.getLength() > 1) {
            int count = attribute.getLength();
            result = new double[count];
            for (int index = 0; index < count; ++index) {
                result[index] = attribute.getNumericValue(index).doubleValue();
            }
        }
        return result;
    }

    private static boolean isValidM3IOFile_(NetcdfFile ncFile) {
        int nlays;
        int[] ftypes = new int[]{1, 3, 8};
        String[] dims = new String[]{"TSTEP", "DATE-TIME", "LAY", "VAR", "ROW", "COL"};
        boolean result = M3IOVGGridConvention.hasDimensions_(ncFile, dims);
        result = result && M3IOVGGridConvention.hasStringAttribute_(ncFile, "EXEC_ID", 80);
        result = result && M3IOVGGridConvention.hasIntAttributeIn_(ncFile, "FTYPE", ftypes);
        result = result && M3IOVGGridConvention.hasYYYYDDDAttribute_(ncFile, "CDATE");
        result = result && M3IOVGGridConvention.hasHHMMSSAttribute_(ncFile, "CTIME");
        result = result && M3IOVGGridConvention.hasYYYYDDDAttribute_(ncFile, "SDATE");
        result = result && M3IOVGGridConvention.hasHHMMSSAttribute_(ncFile, "STIME");
        result = result && M3IOVGGridConvention.hasHHMMSSAttribute_(ncFile, "TSTEP");
        result = result && M3IOVGGridConvention.hasIntAttribute_(ncFile, "NTHIK", 1, Integer.MAX_VALUE);
        result = result && M3IOVGGridConvention.hasIntAttribute_(ncFile, "NCOLS", 1, Integer.MAX_VALUE);
        result = result && M3IOVGGridConvention.hasIntAttribute_(ncFile, "NROWS", 1, Integer.MAX_VALUE);
        result = result && M3IOVGGridConvention.hasIntAttribute_(ncFile, "NLAYS", 1, 100);
        result = result && M3IOVGGridConvention.hasIntAttribute_(ncFile, "NVARS", 1, 120);
        boolean bl = result = result && M3IOVGGridConvention.hasDimension_(ncFile, "TSTEP", 1, Integer.MAX_VALUE);
        if (result) {
            int mxrec = M3IOVGGridConvention.dimension_(ncFile, "TSTEP");
            int nvars = M3IOVGGridConvention.intAttribute_(ncFile, "NVARS");
            nlays = M3IOVGGridConvention.intAttribute_(ncFile, "NLAYS");
            int nrows = M3IOVGGridConvention.intAttribute_(ncFile, "NROWS");
            int ncols = M3IOVGGridConvention.intAttribute_(ncFile, "NCOLS");
            int nthik = M3IOVGGridConvention.intAttribute_(ncFile, "NTHIK");
            int min = Math.min(nrows, ncols);
            int max = 21474836 / nrows;
            result = nthik <= min && ncols <= max;
        }
        int[] gdtypes = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        result = result && M3IOVGGridConvention.hasIntAttributeIn_(ncFile, "GDTYP", gdtypes);
        result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "P_ALP", -90.0, 90.0);
        result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "P_BET", -90.0, 90.0);
        result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "P_GAM", -180.0, 180.0);
        result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "XCENT", -180.0, 180.0);
        result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "YCENT", -90.0, 90.0);
        result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "XORIG", -3.4028234663852886E38, 3.4028234663852886E38);
        result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "YORIG", -3.4028234663852886E38, 3.4028234663852886E38);
        result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "XCELL", 1.4E-45f, 3.4028234663852886E38);
        boolean bl2 = result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "YCELL", 1.4E-45f, 3.4028234663852886E38);
        if (result) {
            int gdtyp = M3IOVGGridConvention.intAttribute_(ncFile, "GDTYP");
            double p_alp = M3IOVGGridConvention.doubleAttribute_(ncFile, "P_ALP");
            double p_bet = M3IOVGGridConvention.doubleAttribute_(ncFile, "P_BET");
            double p_gam = M3IOVGGridConvention.doubleAttribute_(ncFile, "P_GAM");
            double xcent = M3IOVGGridConvention.doubleAttribute_(ncFile, "XCENT");
            double ycent = M3IOVGGridConvention.doubleAttribute_(ncFile, "YCENT");
            double xorig = M3IOVGGridConvention.doubleAttribute_(ncFile, "XORIG");
            double yorig = M3IOVGGridConvention.doubleAttribute_(ncFile, "YORIG");
            double xcell = M3IOVGGridConvention.doubleAttribute_(ncFile, "XCELL");
            double ycell = M3IOVGGridConvention.doubleAttribute_(ncFile, "YCELL");
            int nrows = M3IOVGGridConvention.intAttribute_(ncFile, "NROWS");
            int ncols = M3IOVGGridConvention.intAttribute_(ncFile, "NCOLS");
            result = M3IOVGGridConvention.isValidM3IOProjection_(gdtyp, p_alp, p_bet, p_gam, xcent, ycent, xorig, yorig, xcell, ycell, nrows, ncols);
        }
        int[] vgtypes = new int[]{1, 2, 3, 4, 5, 6};
        result = result && M3IOVGGridConvention.hasIntAttributeIn_(ncFile, "VGTYP", vgtypes);
        result = result && M3IOVGGridConvention.hasDoubleAttribute_(ncFile, "VGTOP", 0.0, 3.4028234663852886E38);
        boolean bl3 = result = result && ncFile.findGlobalAttribute("VGLVLS") != null;
        if (result) {
            nlays = M3IOVGGridConvention.intAttribute_(ncFile, "NLAYS");
            int vgtyp = M3IOVGGridConvention.intAttribute_(ncFile, "VGTYP");
            double vgtop = M3IOVGGridConvention.doubleAttribute_(ncFile, "VGTOP");
            Attribute a = ncFile.findGlobalAttribute("VGLVLS");
            boolean bl4 = result = a != null && a.isArray() && a.getLength() == nlays + 1;
            if (result) {
                double[] vglvls = M3IOVGGridConvention.doubleArrayAttribute_(ncFile, "VGLVLS");
                result = vglvls != null && vglvls.length == nlays + 1;
                result = result && M3IOVGGridConvention.isValidVG_(vgtyp, vgtop, vglvls);
            }
        }
        result = result && M3IOVGGridConvention.hasStringAttribute_(ncFile, "GDNAM", 16);
        result = result && M3IOVGGridConvention.hasStringAttribute_(ncFile, "UPNAM", 16);
        int nvars = M3IOVGGridConvention.intAttribute_(ncFile, "NVARS");
        int varListLen = nvars * 16;
        result = result && M3IOVGGridConvention.hasStringAttribute_(ncFile, "VAR-LIST", varListLen);
        result = result && ncFile.findGlobalAttribute("FILEDESC") != null;
        result = result && ncFile.findGlobalAttribute("HISTORY") != null;
        return result;
    }

    private static boolean hasDimensions_(NetcdfFile ncFile, String[] dims) {
        boolean result = true;
        Iterator<Dimension> iter = ncFile.getDimensions().iterator();
        int count = dims.length;
        int index = 0;
        while (result && iter.hasNext()) {
            Dimension d = iter.next();
            result = index < count && d.getName().equals(dims[index]);
            ++index;
        }
        return result;
    }

    private static boolean hasStringAttribute_(NetcdfFile ncFile, String name, int length) {
        Attribute a = ncFile.findGlobalAttribute(name);
        return a != null && a.isString() && a.getStringValue().length() == length;
    }

    private static boolean hasDoubleAttribute_(NetcdfFile ncFile, String name, double min, double max) {
        boolean result = false;
        Attribute a = ncFile.findGlobalAttribute(name);
        if (a != null) {
            if (a.getDataType() == DataType.FLOAT) {
                float v = a.getNumericValue().floatValue();
                result = (double)v >= min && (double)v <= max;
            } else if (a.getDataType() == DataType.DOUBLE) {
                double v = a.getNumericValue().doubleValue();
                result = v >= min && v <= max;
            }
        }
        return result;
    }

    private static boolean hasDimension_(NetcdfFile ncFile, String name, int min, int max) {
        boolean result = false;
        Dimension d = ncFile.findDimension(name);
        if (d != null) {
            int size = d.getLength();
            result = M3IOVGGridConvention.inRangeI_(size, min, max);
        }
        return result;
    }

    private static int dimension_(NetcdfFile ncFile, String name) {
        Dimension d = ncFile.findDimension(name);
        return d.getLength();
    }

    private static boolean hasIntAttribute_(NetcdfFile ncFile, String name, int min, int max) {
        boolean result = false;
        Attribute a = ncFile.findGlobalAttribute(name);
        if (a != null && a.getDataType() == DataType.INT) {
            int v = a.getNumericValue().intValue();
            result = v >= min && v <= max;
        }
        return result;
    }

    private static boolean hasIntAttributeIn_(NetcdfFile ncFile, String name, int[] match) {
        boolean result = false;
        Attribute a = ncFile.findGlobalAttribute(name);
        if (a != null && a.getDataType() == DataType.INT) {
            int value = a.getNumericValue().intValue();
            int count = match.length;
            for (int index = 0; !result && index < count; ++index) {
                result = value == match[index];
            }
        }
        return result;
    }

    private static boolean hasYYYYDDDAttribute_(NetcdfFile ncFile, String name) {
        boolean result = M3IOVGGridConvention.hasIntAttribute_(ncFile, name, 1001, 9999366);
        if (result) {
            int yyyyddd = M3IOVGGridConvention.intAttribute_(ncFile, name);
            int ddd = yyyyddd - yyyyddd / 1000 * 1000;
            result = M3IOVGGridConvention.inRangeI_(ddd, 1, 366);
        }
        return result;
    }

    private static boolean hasHHMMSSAttribute_(NetcdfFile ncFile, String name) {
        boolean result = M3IOVGGridConvention.hasIntAttribute_(ncFile, name, 0, 235959);
        if (result) {
            int hhmmss = M3IOVGGridConvention.intAttribute_(ncFile, name);
            int hh = hhmmss / 10000;
            result = M3IOVGGridConvention.isValidTimestepSize_(hhmmss) && M3IOVGGridConvention.inRangeI_(hh, 0, 23);
        }
        return result;
    }

    private static boolean isValidTimestepSize_(int hhmmss) {
        int hh = hhmmss / 10000;
        int hh0000 = hh * 10000;
        int mmss = hhmmss - hh0000;
        int mm = mmss / 100;
        int mm00 = mm * 100;
        int ss = mmss - mm00;
        return hh >= 0 && M3IOVGGridConvention.inRangeI_(mm, 0, 59) && M3IOVGGridConvention.inRangeI_(ss, 0, 59);
    }

    private static boolean isValidM3IOProjection_(int gdtyp, double p_alp, double p_bet, double p_gam, double xcent, double ycent, double xorig, double yorig, double xcell, double ycell, int nrows, int ncols) {
        boolean result = false;
        switch (gdtyp) {
            case 1: {
                result = M3IOVGGridConvention.inRange_(xorig, -180.0, 180.0) && M3IOVGGridConvention.inRange_(yorig, -90.0, 90.0) && M3IOVGGridConvention.inRange_(xcell, 0.0, 360.0) && M3IOVGGridConvention.inRange_(ycell, 0.0, 180.0) && M3IOVGGridConvention.inRange_(xorig + (double)ncols * xcell, -180.0, 540.0) && M3IOVGGridConvention.inRange_(yorig + (double)nrows * ycell, -90.0, 90.0);
                break;
            }
            case 2: {
                result = M3IOVGGridConvention.inRange_(p_alp, -90.0, 90.0) && M3IOVGGridConvention.inRange_(p_bet, p_alp, p_alp > 0.0 ? 90.0 : 0.0) && M3IOVGGridConvention.inRange_(p_gam, -180.0, 180.0) && M3IOVGGridConvention.inRange_(xcent, -180.0, 180.0) && M3IOVGGridConvention.inRange_(ycent, -90.0, 90.0);
                break;
            }
            case 3: {
                result = M3IOVGGridConvention.inRange_(p_alp, -90.0, 90.0) && M3IOVGGridConvention.inRange_(p_bet, -180.0, 180.0) && p_gam == 0.0 && M3IOVGGridConvention.inRange_(xcent, -180.0, 180.0) && M3IOVGGridConvention.inRange_(ycent, -90.0, 90.0);
                break;
            }
            case 4: {
                result = M3IOVGGridConvention.inRange_(p_alp, -90.0, 90.0) && M3IOVGGridConvention.inRange_(p_bet, p_alp, p_alp > 0.0 ? 90.0 : 0.0) && M3IOVGGridConvention.inRange_(p_gam, -180.0, 180.0);
                break;
            }
            case 5: {
                result = M3IOVGGridConvention.inRange_(p_alp, 1.0, 60.0);
                break;
            }
            case 6: {
                result = (p_alp == -1.0 || p_alp == 1.0) && M3IOVGGridConvention.inRange_(p_bet, -90.0, 90.0) && M3IOVGGridConvention.inRange_(p_gam, -180.0, 180.0) && M3IOVGGridConvention.inRange_(xcent, -180.0, 180.0) && M3IOVGGridConvention.inRange_(ycent, -90.0, 90.0);
                break;
            }
            case 7: {
                result = M3IOVGGridConvention.inRange_(p_alp, -90.0, 90.0) && p_gam == xcent && M3IOVGGridConvention.inRange_(xcent, -180.0, 180.0) && M3IOVGGridConvention.inRange_(ycent, -90.0, 90.0);
                break;
            }
            case 8: {
                result = M3IOVGGridConvention.inRange_(p_alp, -90.0, 90.0) && p_gam == xcent && M3IOVGGridConvention.inRange_(xcent, -180.0, 180.0) && M3IOVGGridConvention.inRange_(ycent, -90.0, 90.0);
                break;
            }
            case 9: {
                result = M3IOVGGridConvention.inRange_(p_alp, -90.0, 90.0) && M3IOVGGridConvention.inRange_(p_bet, p_alp, p_alp > 0.0 ? 90.0 : 0.0) && p_gam == xcent && M3IOVGGridConvention.inRange_(xcent, -180.0, 180.0) && M3IOVGGridConvention.inRange_(ycent, -90.0, 90.0);
            }
            case 10: {
                result = M3IOVGGridConvention.inRange_(p_alp, -90.0, 90.0) && p_gam == xcent && M3IOVGGridConvention.inRange_(xcent, -180.0, 180.0) && M3IOVGGridConvention.inRange_(ycent, -90.0, 90.0);
                break;
            }
        }
        return result;
    }

    private static boolean isValidVG_(int vgtyp, double vgtop, double[] vglvls) {
        boolean result;
        switch (vgtyp) {
            case 1: 
            case 2: 
            case 3: {
                result = M3IOVGGridConvention.orderedFromTo_(vglvls, 1.0, 0.0);
                break;
            }
            case 4: {
                result = M3IOVGGridConvention.decreasesToward_(vglvls, vgtop);
                break;
            }
            case 5: {
                result = M3IOVGGridConvention.orderedWithin_(vglvls, -200.0, 100000.0);
                break;
            }
            case 6: {
                result = M3IOVGGridConvention.orderedWithin_(vglvls, 0.0, 100000.0);
                break;
            }
            default: {
                result = vgtyp == -9999 && vglvls.length == 2;
            }
        }
        return result;
    }

    private static double[] convertVGLevels_(int vgtyp, double vgtop, double[] vglvls) {
        boolean computeZAtLevels = false;
        int numberOfLevels = vglvls.length + -1;
        double[] result = new double[numberOfLevels];
        block7: for (int level = 0; level < numberOfLevels; ++level) {
            double valueAtLevel = (vglvls[level] + vglvls[level + 1]) * 0.5;
            double HEIGHT_OF_TERRAIN_IN_METERS = 0.0;
            switch (vgtyp) {
                case 1: 
                case 2: {
                    double pressure = M3IOVGGridConvention.pressureAtSigmaLevel_(valueAtLevel, vgtop * 0.01);
                    result[level] = M3IOVGGridConvention.heightAtPressure_(pressure);
                    continue block7;
                }
                case 3: {
                    result[level] = 0.0 + valueAtLevel * (vgtop - 0.0);
                    continue block7;
                }
                case 4: {
                    result[level] = M3IOVGGridConvention.heightAtPressure_(valueAtLevel * 0.01);
                    continue block7;
                }
                case 5: {
                    result[level] = valueAtLevel;
                    continue block7;
                }
                case 6: {
                    result[level] = valueAtLevel + 0.0;
                    continue block7;
                }
                default: {
                    result[level] = level;
                }
            }
        }
        return result;
    }

    private static double pressureAtSigmaLevel_(double sigmaLevel, double pressureAtTop) {
        return pressureAtTop + sigmaLevel * (1012.5 - pressureAtTop);
    }

    private static double heightAtPressure_(double pressure) {
        double pressureToHeightScaleFactor = -7200.0;
        return -7200.0 * Math.log(pressure / 1012.5);
    }

    private static boolean orderedFromTo_(double[] a, double first, double last) {
        boolean result;
        boolean increasing;
        int count = a.length;
        boolean bl = increasing = first <= last;
        boolean bl2 = increasing ? a[0] >= first && a[count - 1] <= last : (result = a[0] >= last && a[count - 1] <= first);
        if (increasing) {
            for (int index = 1; result && index < count; ++index) {
                result = M3IOVGGridConvention.inRange_(a[index], a[index - 1], last);
            }
        } else {
            for (int index = 1; result && index < count; ++index) {
                result = M3IOVGGridConvention.inRange_(a[index], last, a[index - 1]);
            }
        }
        return result;
    }

    private static boolean orderedWithin_(double[] a, double first, double last) {
        boolean result;
        boolean increasing;
        int count = a.length;
        boolean bl = increasing = first < last;
        boolean bl2 = increasing ? a[0] > first && a[count - 1] < last : (result = a[0] > last && a[count - 1] < first);
        if (increasing) {
            for (int index = 1; result && index < count; ++index) {
                double a_index = a[index];
                result = a_index > a[index - 1] && a_index < last;
            }
        } else {
            for (int index = 1; result && index < count; ++index) {
                double a_index = a[index];
                result = a_index > last && a_index < a[index - 1];
            }
        }
        return result;
    }

    private static boolean decreasesToward_(double[] a, double last) {
        int count = a.length;
        boolean result = true;
        for (int index = 1; result && index < count; ++index) {
            result = M3IOVGGridConvention.inRange_(a[index], last, a[index - 1]);
        }
        return result;
    }

    private static boolean inRangeI_(int x, int min, int max) {
        return x >= min && x <= max;
    }

    private static boolean inRange_(double x, double min, double max) {
        return x >= min && x <= max;
    }
}

