/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.unidata.geoloc.vertical.VerticalTransform;
import ucar.unidata.geoloc.vertical.WRFEta;
import ucar.unidata.util.Parameter;

public class WRFEtaTransformBuilder
extends AbstractCoordTransBuilder {
    private CoordinateSystem cs;

    public WRFEtaTransformBuilder() {
    }

    public WRFEtaTransformBuilder(CoordinateSystem cs) {
        this.cs = cs;
    }

    @Override
    public CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, Variable v) {
        VerticalCT.Type type = VerticalCT.Type.WRFEta;
        VerticalCT ct = new VerticalCT(type.toString(), this.getTransformName(), type, this);
        ct.addParameter(new Parameter("height formula", "height(x,y,z) = (PH(x,y,z) + PHB(x,y,z)) / 9.81"));
        ct.addParameter(new Parameter("perturbation_geopotential", "PH"));
        ct.addParameter(new Parameter("base_geopotential", "PHB"));
        ct.addParameter(new Parameter("pressure formula", "pressure(x,y,z) = P(x,y,z) + PB(x,y,z)"));
        ct.addParameter(new Parameter("perturbation_presure", "P"));
        ct.addParameter(new Parameter("base_presure", "PB"));
        if (this.cs.getXaxis() != null) {
            ct.addParameter(new Parameter("staggered_x", "" + this.isStaggered(this.cs.getXaxis())));
        } else {
            ct.addParameter(new Parameter("staggered_x", "" + this.isStaggered2(this.cs.getLonAxis(), 1)));
        }
        if (this.cs.getYaxis() != null) {
            ct.addParameter(new Parameter("staggered_y", "" + this.isStaggered(this.cs.getYaxis())));
        } else {
            ct.addParameter(new Parameter("staggered_y", "" + this.isStaggered2(this.cs.getLonAxis(), 0)));
        }
        ct.addParameter(new Parameter("staggered_z", "" + this.isStaggered(this.cs.getZaxis())));
        ct.addParameter(new Parameter("eta", "" + this.cs.getZaxis().getName()));
        return ct;
    }

    @Override
    public String getTransformName() {
        return "WRF_Eta";
    }

    @Override
    public TransformType getTransformType() {
        return TransformType.Vertical;
    }

    @Override
    public VerticalTransform makeMathTransform(NetcdfDataset ds, Dimension timeDim, VerticalCT vCT) {
        return new WRFEta(ds, timeDim, vCT.getParameters());
    }

    private boolean isStaggered(CoordinateAxis axis) {
        if (axis == null) {
            return false;
        }
        String name = axis.getName();
        if (name == null) {
            return false;
        }
        return name.endsWith("stag");
    }

    private boolean isStaggered2(CoordinateAxis axis, int dimIndex) {
        if (axis == null) {
            return false;
        }
        Dimension dim = axis.getDimension(dimIndex);
        if (dim == null) {
            return false;
        }
        return dim.getName().endsWith("stag");
    }
}

