/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.langdetect.lingo24;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.Response;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.tika.language.detect.LanguageConfidence;
import org.apache.tika.language.detect.LanguageDetector;
import org.apache.tika.language.detect.LanguageResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Lingo24LangDetector
extends LanguageDetector {
    private static final Logger LOG = LoggerFactory.getLogger(Lingo24LangDetector.class);
    private static final String LINGO24_TRANSLATE_URL_BASE = "https://api.lingo24.com/mt/v1/";
    private static final String LINGO24_LANGID_ACTION = "langid";
    private static final String LINGO24_SOURCELANG_ACTION = "sourcelangs";
    private static final String DEFAULT_KEY = "dummy-key";
    private WebClient client = WebClient.create((String)"https://api.lingo24.com/mt/v1/langid");
    private String userKey;
    private Set<String> languages;
    private boolean isAvailable = true;
    private CharArrayWriter writer;

    public Lingo24LangDetector() {
        Properties config = new Properties();
        try {
            config.load(Lingo24LangDetector.class.getResourceAsStream("langdetect.lingo24.properties"));
            this.userKey = config.getProperty("api.user-key");
            if (this.userKey.equals(DEFAULT_KEY)) {
                this.isAvailable = false;
            }
        }
        catch (Exception e) {
            LOG.warn("Couldn't load config", (Throwable)e);
            this.isAvailable = false;
        }
        this.writer = new CharArrayWriter();
        this.languages = this.getAllLanguages();
    }

    public LanguageDetector loadModels() throws IOException {
        return this;
    }

    public LanguageDetector loadModels(Set<String> set) throws IOException {
        return this;
    }

    public boolean hasModel(String language) {
        return this.languages.contains(language);
    }

    public LanguageDetector setPriors(Map<String, Float> languageProbabilities) throws IOException {
        return this;
    }

    public void reset() {
        this.writer.reset();
    }

    public void addText(char[] cbuf, int off, int len) {
        this.writer.write(cbuf, off, len);
        this.writer.write(32);
    }

    public List<LanguageResult> detectAll() {
        ArrayList<LanguageResult> result = new ArrayList<LanguageResult>();
        String language = this.detect(this.writer.toString());
        if (language != null) {
            result.add(new LanguageResult(language, LanguageConfidence.MEDIUM, 1.0f));
        } else {
            result.add(new LanguageResult(language, LanguageConfidence.NONE, 0.0f));
        }
        return result;
    }

    private String detect(String content) {
        String language = null;
        if (!this.isAvailable) {
            return language;
        }
        Form form = new Form();
        form.param("user_key", this.userKey);
        form.param("q", content);
        Response response = this.client.accept(new String[]{"application/json"}).form(form);
        String json = (String)response.readEntity(String.class);
        JsonNode element = null;
        try {
            element = new ObjectMapper().readTree(json);
        }
        catch (JsonProcessingException e) {
            LOG.warn("problem detecting ", (Throwable)e);
        }
        if (element.has("success") && element.get("success").asText().equals("true")) {
            language = element.get("lang").asText();
        }
        return language;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> getAllLanguages() {
        HashSet<String> languages = new HashSet<String>();
        if (!this.isAvailable) {
            return languages;
        }
        try (WebClient _client = null;){
            _client = WebClient.create((String)"https://api.lingo24.com/mt/v1/sourcelangs");
            Response response = _client.accept(new String[]{"application/json"}).query("user_key", new Object[]{this.userKey}).get();
            String json = (String)response.readEntity(String.class);
            JsonNode jsonArray = new ObjectMapper().readTree(json).get("source_langs");
            for (JsonNode jsonElement : jsonArray) {
                languages.add(jsonElement.get(0).asText());
            }
        }
        return languages;
    }

    public boolean isAvailable() {
        return this.isAvailable;
    }
}

