/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.langdetect;

import com.optimaize.langdetect.DetectedLanguage;
import com.optimaize.langdetect.LanguageDetector;
import com.optimaize.langdetect.LanguageDetectorBuilder;
import com.optimaize.langdetect.i18n.LdLocale;
import com.optimaize.langdetect.ngram.NgramExtractor;
import com.optimaize.langdetect.ngram.NgramExtractors;
import com.optimaize.langdetect.profiles.BuiltInLanguages;
import com.optimaize.langdetect.profiles.LanguageProfile;
import com.optimaize.langdetect.profiles.LanguageProfileReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tika.language.detect.LanguageConfidence;
import org.apache.tika.language.detect.LanguageNames;
import org.apache.tika.language.detect.LanguageResult;

public class OptimaizeLangDetector
extends org.apache.tika.language.detect.LanguageDetector {
    private static final int MAX_CHARS_FOR_DETECTION = 20000;
    private static final int MAX_CHARS_FOR_SHORT_DETECTION = 200;
    private LanguageDetector detector;
    private CharArrayWriter writer = new CharArrayWriter(20000);
    private Set<String> languages;
    private Map<String, Float> languageProbabilities;

    public org.apache.tika.language.detect.LanguageDetector loadModels() throws IOException {
        List languageProfiles = new LanguageProfileReader().readAllBuiltIn();
        this.languages = new HashSet<String>();
        for (LanguageProfile profile : languageProfiles) {
            this.languages.add(this.makeLanguageName(profile.getLocale()));
        }
        this.detector = this.createDetector(languageProfiles);
        return this;
    }

    private String makeLanguageName(LdLocale locale) {
        return LanguageNames.makeName((String)locale.getLanguage(), (String)((String)locale.getScript().orNull()), (String)((String)locale.getRegion().orNull()));
    }

    public org.apache.tika.language.detect.LanguageDetector loadModels(Set<String> languages) throws IOException {
        this.languages = new HashSet<String>(languages.size());
        for (String language : languages) {
            this.languages.add(LanguageNames.normalizeName((String)language));
        }
        HashSet<LdLocale> locales = new HashSet<LdLocale>();
        for (LdLocale locale : BuiltInLanguages.getLanguages()) {
            String languageName = this.makeLanguageName(locale);
            if (!this.languages.contains(languageName)) continue;
            locales.add(locale);
        }
        this.detector = this.createDetector(new LanguageProfileReader().readBuiltIn(locales));
        return this;
    }

    private LanguageDetector createDetector(List<LanguageProfile> languageProfiles) {
        LanguageDetectorBuilder builder = LanguageDetectorBuilder.create((NgramExtractor)NgramExtractors.standard()).shortTextAlgorithm(30).withProfiles(languageProfiles);
        if (this.languageProbabilities != null) {
            HashMap<LdLocale, Double> languageWeights = new HashMap<LdLocale, Double>(this.languageProbabilities.size());
            for (String language : this.languageProbabilities.keySet()) {
                Double priority = this.languageProbabilities.get(language).floatValue();
                languageWeights.put(LdLocale.fromString((String)language), priority);
            }
            builder.languagePriorities(languageWeights);
        }
        return builder.build();
    }

    public boolean hasModel(String language) {
        return this.languages.contains(language);
    }

    public org.apache.tika.language.detect.LanguageDetector setPriors(Map<String, Float> languageProbabilities) throws IOException {
        this.languageProbabilities = languageProbabilities;
        this.loadModels(languageProbabilities.keySet());
        return this;
    }

    public void reset() {
        this.writer.reset();
    }

    public void addText(char[] cbuf, int off, int len) {
        if (this.hasEnoughText()) {
            return;
        }
        this.writer.write(cbuf, off, len);
        this.writer.write(32);
    }

    public List<LanguageResult> detectAll() {
        ArrayList<LanguageResult> result = new ArrayList<LanguageResult>();
        List rawResults = this.detector.getProbabilities((CharSequence)this.writer.toString());
        for (DetectedLanguage rawResult : rawResults) {
            LanguageConfidence confidence = rawResult.getProbability() > 0.9 ? LanguageConfidence.HIGH : LanguageConfidence.MEDIUM;
            result.add(new LanguageResult(this.makeLanguageName(rawResult.getLocale()), confidence, (float)rawResult.getProbability()));
        }
        if (result.isEmpty()) {
            result.add(LanguageResult.NULL);
        }
        return result;
    }

    public boolean hasEnoughText() {
        return this.writer.size() >= this.getTextLimit();
    }

    private int getTextLimit() {
        int limit;
        int n = limit = this.shortText ? 200 : 20000;
        if (this.mixedLanguages) {
            limit *= 2;
        }
        return limit;
    }
}

