/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.gdal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TemporaryResources;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.external.ExternalParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GDALParser
extends AbstractParser {
    private static final long serialVersionUID = -3869130527323941401L;
    private static final Logger LOG = LoggerFactory.getLogger(GDALParser.class);
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.unmodifiableSet(new HashSet<MediaType>(Arrays.asList(MediaType.application((String)"x-netcdf"), MediaType.application((String)"vrt"), MediaType.image((String)"geotiff"), MediaType.image((String)"nitf"), MediaType.application((String)"x-rpf-toc"), MediaType.application((String)"x-ecrg-toc"), MediaType.image((String)"hfa"), MediaType.image((String)"sar-ceos"), MediaType.image((String)"ceos"), MediaType.application((String)"jaxa-pal-sar"), MediaType.application((String)"gff"), MediaType.application((String)"elas"), MediaType.application((String)"aig"), MediaType.application((String)"aaigrid"), MediaType.application((String)"grass-ascii-grid"), MediaType.application((String)"sdts-raster"), MediaType.application((String)"dted"), MediaType.image((String)"png"), MediaType.image((String)"jpeg"), MediaType.image((String)"raster"), MediaType.application((String)"jdem"), MediaType.image((String)"gif"), MediaType.image((String)"big-gif"), MediaType.image((String)"envisat"), MediaType.image((String)"fits"), MediaType.application((String)"fits"), MediaType.image((String)"bsb"), MediaType.application((String)"xpm"), MediaType.image((String)"bmp"), MediaType.image((String)"x-dimap"), MediaType.image((String)"x-airsar"), MediaType.application((String)"x-rs2"), MediaType.application((String)"x-pcidsk"), MediaType.application((String)"pcisdk"), MediaType.image((String)"x-pcraster"), MediaType.image((String)"ilwis"), MediaType.image((String)"sgi"), MediaType.application((String)"x-srtmhgt"), MediaType.application((String)"leveller"), MediaType.application((String)"terragen"), MediaType.application((String)"x-gmt"), MediaType.application((String)"x-isis3"), MediaType.application((String)"x-isis2"), MediaType.application((String)"x-pds"), MediaType.application((String)"x-til"), MediaType.application((String)"x-ers"), MediaType.application((String)"x-l1b"), MediaType.image((String)"fit"), MediaType.application((String)"x-grib"), MediaType.image((String)"jp2"), MediaType.application((String)"x-rmf"), MediaType.application((String)"x-wcs"), MediaType.application((String)"x-wms"), MediaType.application((String)"x-msgn"), MediaType.application((String)"x-wms"), MediaType.application((String)"x-wms"), MediaType.application((String)"x-rst"), MediaType.application((String)"x-ingr"), MediaType.application((String)"x-gsag"), MediaType.application((String)"x-gsbg"), MediaType.application((String)"x-gs7bg"), MediaType.application((String)"x-cosar"), MediaType.application((String)"x-tsx"), MediaType.application((String)"x-coasp"), MediaType.application((String)"x-r"), MediaType.application((String)"x-map"), MediaType.application((String)"x-pnm"), MediaType.application((String)"x-doq1"), MediaType.application((String)"x-doq2"), MediaType.application((String)"x-envi"), MediaType.application((String)"x-envi-hdr"), MediaType.application((String)"x-generic-bin"), MediaType.application((String)"x-p-aux"), MediaType.image((String)"x-mff"), MediaType.image((String)"x-mff2"), MediaType.image((String)"x-fujibas"), MediaType.application((String)"x-gsc"), MediaType.application((String)"x-fast"), MediaType.application((String)"x-bt"), MediaType.application((String)"x-lan"), MediaType.application((String)"x-cpg"), MediaType.image((String)"ida"), MediaType.application((String)"x-ndf"), MediaType.image((String)"eir"), MediaType.application((String)"x-dipex"), MediaType.application((String)"x-lcp"), MediaType.application((String)"x-gtx"), MediaType.application((String)"x-los-las"), MediaType.application((String)"x-ntv2"), MediaType.application((String)"x-ctable2"), MediaType.application((String)"x-ace2"), MediaType.application((String)"x-snodas"), MediaType.application((String)"x-kro"), MediaType.image((String)"arg"), MediaType.application((String)"x-rik"), MediaType.application((String)"x-usgs-dem"), MediaType.application((String)"x-gxf"), MediaType.application((String)"x-dods"), MediaType.application((String)"x-http"), MediaType.application((String)"x-bag"), MediaType.application((String)"x-hdf"), MediaType.image((String)"x-hdf5-image"), MediaType.application((String)"x-nwt-grd"), MediaType.application((String)"x-nwt-grc"), MediaType.image((String)"adrg"), MediaType.image((String)"x-srp"), MediaType.application((String)"x-blx"), MediaType.application((String)"x-rasterlite"), MediaType.application((String)"x-epsilon"), MediaType.application((String)"x-sdat"), MediaType.application((String)"x-kml"), MediaType.application((String)"x-xyz"), MediaType.application((String)"x-geo-pdf"), MediaType.image((String)"x-ozi"), MediaType.application((String)"x-ctg"), MediaType.application((String)"x-e00-grid"), MediaType.application((String)"x-zmap"), MediaType.application((String)"x-webp"), MediaType.application((String)"x-ngs-geoid"), MediaType.application((String)"x-mbtiles"), MediaType.application((String)"x-ppi"), MediaType.application((String)"x-cappi"))));
    private String command;

    public GDALParser() {
        this.setCommand("gdalinfo ${INPUT}");
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String processCommand(InputStream stream) {
        TikaInputStream tis = (TikaInputStream)stream;
        String pCommand = this.command;
        try {
            if (this.command.contains("${INPUT}")) {
                pCommand = this.command.replace("${INPUT}", tis.getFile().getPath());
            }
        }
        catch (Exception e) {
            LOG.warn("exception processing command", (Throwable)e);
        }
        return pCommand;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        if (!ExternalParser.check((String)"gdalinfo", (int[])new int[0])) {
            return;
        }
        TemporaryResources tmp = new TemporaryResources();
        TikaInputStream tis = TikaInputStream.get((InputStream)stream, (TemporaryResources)tmp);
        String runCommand = this.processCommand((InputStream)tis);
        String output = this.execCommand(new String[]{runCommand});
        this.extractMetFromOutput(output, metadata);
        this.applyPatternsToOutput(output, metadata, this.getPatterns());
        this.processOutput(handler, metadata, output);
    }

    private Map<Pattern, String> getPatterns() {
        HashMap<Pattern, String> patterns = new HashMap<Pattern, String>();
        this.addPatternWithColon("Driver", patterns);
        this.addPatternWithColon("Files", patterns);
        this.addPatternWithIs("Size", patterns);
        this.addPatternWithIs("Coordinate System", patterns);
        this.addBoundingBoxPattern("Upper Left", patterns);
        this.addBoundingBoxPattern("Lower Left", patterns);
        this.addBoundingBoxPattern("Upper Right", patterns);
        this.addBoundingBoxPattern("Lower Right", patterns);
        return patterns;
    }

    private void addPatternWithColon(String name, Map<Pattern, String> patterns) {
        patterns.put(Pattern.compile(name + "\\:\\s*([A-Za-z0-9/ _\\-\\.]+)\\s*"), name);
    }

    private void addPatternWithIs(String name, Map<Pattern, String> patterns) {
        patterns.put(Pattern.compile(name + " is ([A-Za-z0-9\\.,\\s`']+)"), name);
    }

    private void addBoundingBoxPattern(String name, Map<Pattern, String> patterns) {
        patterns.put(Pattern.compile(name + "\\s*\\(\\s*([0-9]+\\.[0-9]+\\s*,\\s*[0-9]+\\.[0-9]+\\s*)\\)\\s*"), name);
    }

    private void extractMetFromOutput(String output, Metadata met) {
        try (Scanner scanner = new Scanner(output);){
            String currentKey = null;
            String[] headings = new String[]{"Subdatasets", "Corner Coordinates"};
            StringBuilder metVal = new StringBuilder();
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                if (line.contains("=") || this.hasHeadings(line, headings)) {
                    if (currentKey != null) {
                        met.add(currentKey, metVal.toString());
                    }
                    metVal.setLength(0);
                    String[] lineToks = line.split("=");
                    currentKey = lineToks[0].trim();
                    if (lineToks.length != 2) continue;
                    metVal.append(lineToks[1]);
                    continue;
                }
                metVal.append(line);
            }
        }
    }

    private boolean hasHeadings(String line, String[] headings) {
        if (headings != null && headings.length > 0) {
            for (String heading : headings) {
                if (!line.contains(heading)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private void applyPatternsToOutput(String output, Metadata metadata, Map<Pattern, String> metadataPatterns) {
        try (Scanner scanner = new Scanner(output);){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                for (Pattern p : metadataPatterns.keySet()) {
                    Matcher m = p.matcher(line);
                    if (!m.find()) continue;
                    if (metadataPatterns.get(p) != null && !metadataPatterns.get(p).equals("")) {
                        metadata.add(metadataPatterns.get(p), m.group(1));
                        continue;
                    }
                    metadata.add(m.group(1), m.group(2));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String execCommand(String[] cmd) throws IOException {
        String output = null;
        Process process = cmd.length == 1 ? Runtime.getRuntime().exec(cmd[0]) : Runtime.getRuntime().exec(cmd);
        try {
            InputStream out = process.getInputStream();
            try {
                output = this.extractOutput(out);
            }
            catch (Exception e) {
                LOG.warn("Exception extracting output", (Throwable)e);
                output = "";
            }
        }
        finally {
            try {
                process.waitFor();
            }
            catch (InterruptedException interruptedException) {}
        }
        return output;
    }

    private String extractOutput(InputStream stream) throws SAXException, IOException {
        StringBuilder sb = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);){
            char[] buffer = new char[1024];
            int n = reader.read(buffer);
            while (n != -1) {
                sb.append(buffer, 0, n);
                n = reader.read(buffer);
            }
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOutput(ContentHandler handler, Metadata metadata, String output) throws SAXException, IOException {
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        ByteArrayInputStream stream = new ByteArrayInputStream(output.getBytes(StandardCharsets.UTF_8));
        try (InputStreamReader reader = new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8);){
            xhtml.startDocument();
            xhtml.startElement("p");
            char[] buffer = new char[1024];
            int n = reader.read(buffer);
            while (n != -1) {
                xhtml.characters(buffer, 0, n);
                n = reader.read(buffer);
            }
            xhtml.endElement("p");
        }
        finally {
            xhtml.endDocument();
        }
    }
}

