/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization;

import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;
import jj2000.j2k.util.ParameterList;

public class QuantTypeSpec
extends ModuleSpec {
    public QuantTypeSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public QuantTypeSpec(int nt, int nc, byte type, ParameterList pl) {
        super(nt, nc, type);
        String param = pl.getParameter("Qtype");
        if (param == null) {
            if (pl.getBooleanParameter("lossless")) {
                this.setDefault("reversible");
            } else {
                this.setDefault("expounded");
            }
            return;
        }
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecValType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        block10: while (stk.hasMoreTokens()) {
            String word = stk.nextToken().toLowerCase();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = QuantTypeSpec.parseIdx(word, this.nTiles);
                    if (curSpecValType == 1) {
                        curSpecValType = 3;
                        continue block10;
                    }
                    curSpecValType = 2;
                    continue block10;
                }
                case 'c': {
                    compSpec = QuantTypeSpec.parseIdx(word, this.nComp);
                    if (curSpecValType == 2) {
                        curSpecValType = 3;
                        continue block10;
                    }
                    curSpecValType = 1;
                    continue block10;
                }
                case 'd': 
                case 'e': 
                case 'r': {
                    int i;
                    if (!(word.equalsIgnoreCase("reversible") || word.equalsIgnoreCase("derived") || word.equalsIgnoreCase("expounded"))) {
                        throw new IllegalArgumentException("Unknown parameter for '-Qtype' option: " + word);
                    }
                    if (pl.getBooleanParameter("lossless") && (word.equalsIgnoreCase("derived") || word.equalsIgnoreCase("expounded"))) {
                        throw new IllegalArgumentException("Cannot use non reversible quantization with '-lossless' option");
                    }
                    if (curSpecValType == 0) {
                        this.setDefault(word);
                    } else if (curSpecValType == 2) {
                        for (i = tileSpec.length - 1; i >= 0; --i) {
                            if (!tileSpec[i]) continue;
                            this.setTileDef(i, word);
                        }
                    } else if (curSpecValType == 1) {
                        for (i = compSpec.length - 1; i >= 0; --i) {
                            if (!compSpec[i]) continue;
                            this.setCompDef(i, word);
                        }
                    } else {
                        for (i = tileSpec.length - 1; i >= 0; --i) {
                            for (int j = compSpec.length - 1; j >= 0; --j) {
                                if (!tileSpec[i] || !compSpec[j]) continue;
                                this.setTileCompVal(i, j, word);
                            }
                        }
                    }
                    curSpecValType = 0;
                    tileSpec = null;
                    compSpec = null;
                    continue block10;
                }
            }
            throw new IllegalArgumentException("Unknown parameter for '-Qtype' option: " + word);
        }
        if (this.getDefault() == null) {
            int t2;
            int ndefspec = 0;
            for (t2 = nt - 1; t2 >= 0; --t2) {
                for (int c = nc - 1; c >= 0; --c) {
                    if (this.specValType[t2][c] != 0) continue;
                    ++ndefspec;
                }
            }
            if (ndefspec != 0) {
                if (pl.getBooleanParameter("lossless")) {
                    this.setDefault("reversible");
                } else {
                    this.setDefault("expounded");
                }
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        for (int c = nc - 1; c >= 0; --c) {
                            if (this.specValType[0][c] != 2) continue;
                            this.specValType[0][c] = 0;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        for (t2 = nt - 1; t2 >= 0; --t2) {
                            if (this.specValType[t2][0] != 1) continue;
                            this.specValType[t2][0] = 0;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }

    public boolean isDerived(int t2, int c) {
        return ((String)this.getTileCompVal(t2, c)).equals("derived");
    }

    public boolean isReversible(int t2, int c) {
        return ((String)this.getTileCompVal(t2, c)).equals("reversible");
    }

    public boolean isFullyReversible() {
        if (((String)this.getDefault()).equals("reversible")) {
            for (int t2 = this.nTiles - 1; t2 >= 0; --t2) {
                for (int c = this.nComp - 1; c >= 0; --c) {
                    if (this.specValType[t2][c] == 0) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean isFullyNonReversible() {
        for (int t2 = this.nTiles - 1; t2 >= 0; --t2) {
            for (int c = this.nComp - 1; c >= 0; --c) {
                if (!((String)this.getSpec(t2, c)).equals("reversible")) continue;
                return false;
            }
        }
        return true;
    }
}

