/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.coverage.PointOutsideCoverageException;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.internal.feature.Resources;
import org.apache.sis.internal.util.Strings;
import org.apache.sis.util.StringBuilders;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class FractionalGridCoordinates
implements Serializable {
    private static final long serialVersionUID = 5652265407347129550L;
    final double[] coordinates;

    public FractionalGridCoordinates(int n) {
        this.coordinates = new double[n];
    }

    public FractionalGridCoordinates(FractionalGridCoordinates fractionalGridCoordinates) {
        this.coordinates = (double[])fractionalGridCoordinates.coordinates.clone();
    }

    public int getDimension() {
        return this.coordinates.length;
    }

    public long[] getCoordinateValues() {
        long[] lArray = new long[this.coordinates.length];
        for (int i = 0; i < lArray.length; ++i) {
            lArray[i] = this.getCoordinateValue(i);
        }
        return lArray;
    }

    public long getCoordinateValue(int n) {
        double d = this.coordinates[n];
        if (d >= -9.223372036854778E18 && d <= 9.223372036854778E18) {
            return Math.round(d);
        }
        throw new ArithmeticException(Resources.format((short)65, "long", d));
    }

    public double getCoordinateFractional(int n) {
        return this.coordinates[n];
    }

    public void setCoordinateValue(int n, long l) {
        this.coordinates[n] = l;
        if (this.coordinates[n] != (double)l) {
            throw new ArithmeticException(Resources.format((short)65, "double", l));
        }
    }

    public GridExtent toExtent(GridExtent gridExtent, long ... lArray) {
        return this.toExtent(gridExtent, lArray, false);
    }

    final GridExtent toExtent(GridExtent gridExtent, long[] lArray, boolean bl) {
        int n;
        int n2 = this.coordinates.length;
        if (gridExtent != null && (n = gridExtent.getDimension()) != n2) {
            throw new MismatchedDimensionException(Errors.format((short)81, "bounds", n2, n));
        }
        long[] lArray2 = GridExtent.allocate(n2);
        for (int i = 0; i < n2; ++i) {
            long l;
            long l2;
            double d = this.coordinates[i];
            if (!(d >= -9.223372036854776E18) || !(d <= 9.223372036854776E18)) {
                throw new ArithmeticException(Resources.format((short)65, "long", d));
            }
            long l3 = 0L;
            if (i < lArray.length && (l3 = lArray[i]) < 0L) {
                throw new IllegalArgumentException(Errors.format((short)92, Strings.toIndexed("size", i), l3));
            }
            long l4 = Math.round(d);
            if (l3 == 1L) {
                l = l2 = l4;
            } else {
                l = (long)Math.floor(d);
                l2 = (long)Math.ceil(d);
                if (l3 != 0L) {
                    assert ((l3 -= l2 - l + 1L) >= 0L) : l3;
                    if ((l3 & 1L) != 0L) {
                        if (l4 >= l2) {
                            l2 = Math.incrementExact(l2);
                        } else {
                            l = Math.decrementExact(l);
                        }
                    }
                    l = Math.subtractExact(l, l3 >>= 1);
                    l2 = Math.addExact(l2, l3);
                    l3 = 2L;
                }
            }
            if (gridExtent != null) {
                long l5;
                long l6 = gridExtent.getLow(i);
                long l7 = gridExtent.getHigh(i);
                if (l4 > l7 || l4 < l6) {
                    if (bl) {
                        return null;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    this.writeCoordinates(stringBuilder);
                    throw new PointOutsideCoverageException(Resources.format((short)21, gridExtent.getAxisIdentification(i, i), l6, l7, stringBuilder.toString()));
                }
                if (l2 > l7) {
                    if (l3 != 0L) {
                        l5 = l - Math.subtractExact(l2, l7);
                        l = l5 >= l6 && l5 <= l ? l5 : l6;
                    }
                    l2 = l7;
                }
                if (l < l6) {
                    if (l3 != 0L) {
                        l5 = l2 + Math.subtractExact(l6, l);
                        l2 = l5 <= l7 && l5 >= l2 ? l5 : l7;
                    }
                    l = l6;
                }
            }
            lArray2[i] = l;
            lArray2[i + n2] = l2;
        }
        return new GridExtent(gridExtent, lArray2);
    }

    public DirectPosition toPosition(MathTransform mathTransform) throws TransformException {
        return mathTransform.transform(new Position(this), null);
    }

    final String pointOutsideCoverage(GridExtent gridExtent) {
        if (gridExtent == null) {
            return null;
        }
        int n = 0;
        long l = 0L;
        long l2 = 0L;
        double d = 0.0;
        int n2 = gridExtent.getDimension();
        while (--n2 >= 0) {
            long l3 = gridExtent.getLow(n2);
            long l4 = gridExtent.getHigh(n2);
            double d2 = this.coordinates[n2];
            double d3 = (double)l3 - d2;
            if (!(d3 > d) && !((d3 = d2 - (double)l4) > d)) continue;
            n = n2;
            l = l3;
            l2 = l4;
            d = d3;
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.writeCoordinates(stringBuilder);
        return Resources.format((short)21, gridExtent.getAxisIdentification(n, n), l, l2, stringBuilder.toString());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("GridCoordinates[");
        this.writeCoordinates(stringBuilder);
        return stringBuilder.append(']').toString();
    }

    private void writeCoordinates(StringBuilder stringBuilder) {
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (i != 0) {
                stringBuilder.append(' ');
            }
            StringBuilders.trimFractionalPart(stringBuilder.append(this.coordinates[i]));
        }
    }

    public int hashCode() {
        return Arrays.hashCode(this.coordinates) ^ 0xE5277CCE;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object != null && object.getClass() == this.getClass()) {
            return Arrays.equals(((FractionalGridCoordinates)object).coordinates, this.coordinates);
        }
        return false;
    }

    static final class Position
    extends FractionalGridCoordinates
    implements DirectPosition {
        private static final long serialVersionUID = -7804151694395153401L;

        Position(int n) {
            super(n);
        }

        Position(FractionalGridCoordinates fractionalGridCoordinates) {
            super(fractionalGridCoordinates);
        }

        @Override
        public DirectPosition getDirectPosition() {
            return this;
        }

        @Override
        public CoordinateReferenceSystem getCoordinateReferenceSystem() {
            return null;
        }

        @Override
        public double[] getCoordinate() {
            return (double[])this.coordinates.clone();
        }

        @Override
        public double getOrdinate(int n) {
            return this.coordinates[n];
        }

        @Override
        public void setOrdinate(int n, double d) {
            this.coordinates[n] = d;
        }

        @Override
        public DirectPosition toPosition(MathTransform mathTransform) throws TransformException {
            return mathTransform.transform(this, null);
        }
    }
}

