/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.coverage.grid;

import java.awt.image.RenderedImage;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.DerivedGridCoverage;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;

final class TranslatedGridCoverage
extends DerivedGridCoverage {
    private final long[] translation;

    private TranslatedGridCoverage(GridCoverage gridCoverage, GridGeometry gridGeometry, long[] lArray) {
        super(gridCoverage, gridGeometry);
        this.translation = lArray;
    }

    static GridCoverage create(GridCoverage gridCoverage, GridGeometry gridGeometry, long[] lArray, boolean bl) {
        Object object;
        if (bl) {
            while (gridCoverage instanceof TranslatedGridCoverage) {
                object = (TranslatedGridCoverage)gridCoverage;
                long[] lArray2 = (long[])((TranslatedGridCoverage)object).translation.clone();
                long l = 0L;
                int n = Math.min(lArray2.length, lArray.length);
                while (--n >= 0) {
                    lArray2[n] = Math.addExact(lArray2[n], lArray[n]);
                    l |= lArray[n];
                }
                if (l == 0L) {
                    return object;
                }
                lArray = lArray2;
                gridCoverage = ((TranslatedGridCoverage)object).source;
            }
        }
        object = gridCoverage.getGridGeometry();
        if (gridGeometry == null) {
            gridGeometry = ((GridGeometry)object).shiftGrid(lArray);
        } else if (!gridGeometry.extent.isSameSize(((GridGeometry)object).extent)) {
            return null;
        }
        if (gridGeometry.equals(object)) {
            return gridCoverage;
        }
        return new TranslatedGridCoverage(gridCoverage, gridGeometry, lArray);
    }

    @Override
    protected final GridCoverage createConvertedValues(boolean bl) {
        GridCoverage gridCoverage = this.source.forConvertedValues(bl);
        return gridCoverage == this.source ? this : new TranslatedGridCoverage(gridCoverage, this.gridGeometry, this.translation);
    }

    @Override
    public RenderedImage render(GridExtent gridExtent) throws CannotEvaluateException {
        if (gridExtent == null) {
            gridExtent = this.gridGeometry.extent;
        }
        if (gridExtent != null) {
            gridExtent = gridExtent.translate(this.translation);
        }
        return this.source.render(gridExtent);
    }
}

