/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.apache.sis.geometry.AbstractEnvelope;
import org.apache.sis.geometry.MismatchedReferenceSystemException;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;

class ArrayEnvelope
extends AbstractEnvelope
implements Serializable {
    private static final long serialVersionUID = 3685400961133848112L;
    final double[] coordinates;
    CoordinateReferenceSystem crs;

    ArrayEnvelope(double[] dArray) {
        this.coordinates = dArray;
    }

    public ArrayEnvelope(DirectPosition directPosition, DirectPosition directPosition2) throws MismatchedDimensionException, MismatchedReferenceSystemException {
        this.crs = ArrayEnvelope.getCommonCRS(directPosition, directPosition2);
        int n = directPosition.getDimension();
        ArgumentChecks.ensureDimensionMatches("crs", n, this.crs);
        ArrayEnvelope.ensureSameDimension(n, directPosition2.getDimension());
        this.coordinates = new double[n * 2];
        for (int i = 0; i < n; ++i) {
            this.coordinates[i] = directPosition.getOrdinate(i);
            this.coordinates[i + n] = directPosition2.getOrdinate(i);
        }
        ArrayEnvelope.verifyRanges(this.crs, this.coordinates);
    }

    public ArrayEnvelope(double[] dArray, double[] dArray2) throws MismatchedDimensionException {
        ArgumentChecks.ensureNonNull("lowerCorner", dArray);
        ArgumentChecks.ensureNonNull("upperCorner", dArray2);
        ArrayEnvelope.ensureSameDimension(dArray.length, dArray2.length);
        this.coordinates = Arrays.copyOf(dArray, dArray.length + dArray2.length);
        System.arraycopy(dArray2, 0, this.coordinates, dArray.length, dArray2.length);
    }

    public ArrayEnvelope(int n) {
        this.coordinates = new double[n * 2];
    }

    public ArrayEnvelope(CoordinateReferenceSystem coordinateReferenceSystem) {
        ArgumentChecks.ensureNonNull("crs", coordinateReferenceSystem);
        this.coordinates = new double[coordinateReferenceSystem.getCoordinateSystem().getDimension() * 2];
        this.crs = coordinateReferenceSystem;
    }

    public ArrayEnvelope(Envelope envelope) {
        ArgumentChecks.ensureNonNull("envelope", envelope);
        this.crs = envelope.getCoordinateReferenceSystem();
        int n = envelope.getDimension();
        this.coordinates = new double[n * 2];
        DirectPosition directPosition = envelope.getLowerCorner();
        DirectPosition directPosition2 = envelope.getUpperCorner();
        for (int i = 0; i < n; ++i) {
            this.coordinates[i] = directPosition.getOrdinate(i);
            this.coordinates[i + n] = directPosition2.getOrdinate(i);
        }
        ArrayEnvelope.verifyRanges(this.crs, this.coordinates);
    }

    public ArrayEnvelope(GeographicBoundingBox geographicBoundingBox) {
        ArgumentChecks.ensureNonNull("box", geographicBoundingBox);
        this.coordinates = new double[]{geographicBoundingBox.getWestBoundLongitude(), geographicBoundingBox.getSouthBoundLatitude(), geographicBoundingBox.getEastBoundLongitude(), geographicBoundingBox.getNorthBoundLatitude()};
        if (Boolean.FALSE.equals(geographicBoundingBox.getInclusion())) {
            ArraysExt.swap(this.coordinates, 0, this.coordinates.length >>> 1);
            if (!Formulas.isPoleToPole(this.coordinates[1], this.coordinates[3])) {
                ArraysExt.swap(this.coordinates, 1, (this.coordinates.length >>> 1) + 1);
            }
        }
        this.crs = CommonCRS.defaultGeographic();
        ArrayEnvelope.verifyRanges(this.crs, this.coordinates);
    }

    /*
     * Unable to fully structure code
     */
    public ArrayEnvelope(CharSequence var1_1) throws IllegalArgumentException {
        super();
        ArgumentChecks.ensureNonNull("wkt", var1_1);
        var2_2 = 0;
        var3_3 = 0;
        var4_4 = 4;
        var5_5 = 0;
        var6_6 = CharSequences.skipTrailingWhitespaces(var1_1, 0, var1_1.length());
        var7_7 = new double[var4_4];
        var8_8 = new double[var4_4];
        var9_9 = 0;
        block12: for (var11_10 = CharSequences.skipLeadingWhitespaces(var1_1, 0, var6_6); var11_10 < var6_6; var11_10 += Character.charCount(var10_11)) {
            var10_11 = Character.codePointAt(var1_1, var11_10);
            if (!Character.isUnicodeIdentifierStart(var10_11)) ** GOTO lbl17
            while ((var11_10 += Character.charCount(var10_11)) < var6_6) {
                var10_11 = Character.codePointAt(var1_1, var11_10);
                if (Character.isUnicodeIdentifierPart(var10_11)) continue;
lbl17:
                // 2 sources

                if (Character.isSpaceChar(var10_11)) continue block12;
                switch (var10_11) {
                    case 44: {
                        var9_9 = 0;
                        continue block12;
                    }
                    case 40: {
                        ++var2_2;
                        var9_9 = 0;
                        continue block12;
                    }
                    case 91: {
                        ++var3_3;
                        var9_9 = 0;
                        continue block12;
                    }
                    case 41: {
                        if (--var2_2 < 0) {
                            ArrayEnvelope.fail(var1_1, '(');
                        }
                        var9_9 = 0;
                        continue block12;
                    }
                    case 93: {
                        if (--var3_3 < 0) {
                            ArrayEnvelope.fail(var1_1, '[');
                        }
                        var9_9 = 0;
                        continue block12;
                    }
                    default: {
                        var12_12 = var11_10;
                        var13_13 = false;
                        block14: while ((var11_10 += Character.charCount(var10_11)) < var6_6 && !Character.isSpaceChar(var10_11 = (int)var1_1.charAt(var11_10))) {
                            switch (var10_11) {
                                case 44: {
                                    var13_13 = true;
                                    break block14;
                                }
                                case 41: {
                                    if (--var2_2 < 0) {
                                        ArrayEnvelope.fail(var1_1, '(');
                                    }
                                    var13_13 = true;
                                    break block14;
                                }
                                case 93: {
                                    if (--var3_3 < 0) {
                                        ArrayEnvelope.fail(var1_1, '[');
                                    }
                                    var13_13 = true;
                                    break block14;
                                }
                                default: {
                                    continue block14;
                                }
                            }
                        }
                        var14_14 = Double.parseDouble(var1_1.subSequence(var12_12, var11_10).toString());
                        if (var9_9 == var5_5) {
                            if (var9_9 == var4_4) {
                                var7_7 = Arrays.copyOf(var7_7, var4_4 *= 2);
                                var8_8 = Arrays.copyOf(var8_8, var4_4);
                            }
                            var7_7[var9_9] = var8_8[var9_9] = var14_14;
                            var5_5 = ++var9_9;
                        } else {
                            if (var14_14 < var7_7[var9_9]) {
                                var7_7[var9_9] = var14_14;
                            }
                            if (var14_14 > var8_8[var9_9]) {
                                var8_8[var9_9] = var14_14;
                            }
                            ++var9_9;
                        }
                        if (!var13_13) continue block12;
                        var9_9 = 0;
                    }
                }
                continue block12;
            }
            break block12;
        }
        if (var2_2 != 0) {
            ArrayEnvelope.fail(var1_1, ')');
        }
        if (var3_3 != 0) {
            ArrayEnvelope.fail(var1_1, ']');
        }
        this.coordinates = ArraysExt.resize(var7_7, var5_5 << 1);
        System.arraycopy(var8_8, 0, this.coordinates, var5_5, var5_5);
    }

    private static void fail(CharSequence charSequence, char c) {
        throw new IllegalArgumentException(Errors.format((short)101, charSequence, Character.valueOf(c)));
    }

    static void ensureSameDimension(int n, int n2) throws MismatchedDimensionException {
        if (n != n2) {
            throw new MismatchedDimensionException(Errors.format((short)80, n, n2));
        }
    }

    static void verifyRanges(CoordinateReferenceSystem coordinateReferenceSystem, double[] dArray) {
        if (coordinateReferenceSystem != null) {
            int n = dArray.length >>> 1;
            for (int i = 0; i < n; ++i) {
                double d = dArray[i];
                double d2 = dArray[i + n];
                if (!(d > d2) || ArrayEnvelope.isWrapAround(coordinateReferenceSystem, i)) continue;
                throw new IllegalArgumentException(ArrayEnvelope.illegalRange(coordinateReferenceSystem, i, d, d2));
            }
        }
    }

    static String illegalRange(CoordinateReferenceSystem coordinateReferenceSystem, int n, double d, double d2) {
        Object object = IdentifiedObjects.getDisplayName(ArrayEnvelope.getAxis(coordinateReferenceSystem, n), null);
        if (object == null) {
            object = n;
        }
        return Errors.format((short)57, d, d2, object);
    }

    int beginIndex() {
        return 0;
    }

    int endIndex() {
        return this.coordinates.length >>> 1;
    }

    @Override
    public int getDimension() {
        return this.coordinates.length >>> 1;
    }

    @Override
    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        assert (this.crs == null || this.crs.getCoordinateSystem().getDimension() == this.getDimension());
        return this.crs;
    }

    @Override
    public double getLower(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.coordinates.length >>> 1, n);
        return this.coordinates[n];
    }

    @Override
    public double getUpper(int n) throws IndexOutOfBoundsException {
        int n2 = this.coordinates.length >>> 1;
        ArgumentChecks.ensureValidIndex(n2, n);
        return this.coordinates[n + n2];
    }

    @Override
    public double getMinimum(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex(), n);
        int n2 = n + this.beginIndex();
        double d = this.coordinates[n2];
        if (MathFunctions.isNegative(this.coordinates[n2 + (this.coordinates.length >>> 1)] - d)) {
            CoordinateSystemAxis coordinateSystemAxis = ArrayEnvelope.getAxis(this.crs, n);
            d = ArrayEnvelope.isWrapAround(coordinateSystemAxis) ? coordinateSystemAxis.getMinimumValue() : Double.NaN;
        }
        return d;
    }

    @Override
    public double getMaximum(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex(), n);
        int n2 = n + this.beginIndex();
        double d = this.coordinates[n2 + (this.coordinates.length >>> 1)];
        if (MathFunctions.isNegative(d - this.coordinates[n2])) {
            CoordinateSystemAxis coordinateSystemAxis = ArrayEnvelope.getAxis(this.crs, n);
            d = ArrayEnvelope.isWrapAround(coordinateSystemAxis) ? coordinateSystemAxis.getMaximumValue() : Double.NaN;
        }
        return d;
    }

    @Override
    public double getMedian(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex(), n);
        int n2 = n + this.beginIndex();
        double d = this.coordinates[n2];
        double d2 = this.coordinates[n2 + (this.coordinates.length >>> 1)];
        double d3 = 0.5 * (d + d2);
        if (MathFunctions.isNegative(d2 - d)) {
            d3 = ArrayEnvelope.fixMedian(ArrayEnvelope.getAxis(this.crs, n), d3);
        }
        return d3;
    }

    @Override
    public double getSpan(int n) throws IndexOutOfBoundsException {
        ArgumentChecks.ensureValidIndex(this.endIndex(), n);
        int n2 = n + this.beginIndex();
        double d = this.coordinates[n2 + (this.coordinates.length >>> 1)] - this.coordinates[n2];
        if (MathFunctions.isNegative(d)) {
            d = ArrayEnvelope.fixSpan(ArrayEnvelope.getAxis(this.crs, n), d);
        }
        return d;
    }

    @Override
    public boolean isEmpty() {
        int n;
        int n2 = this.beginIndex();
        if (n2 == (n = this.endIndex())) {
            return true;
        }
        int n3 = this.coordinates.length >>> 1;
        for (int i = n2; i < n; ++i) {
            double d = this.coordinates[i + n3] - this.coordinates[i];
            if (d > 0.0 || MathFunctions.isNegative(d) && ArrayEnvelope.isWrapAround(this.crs, i - n2)) continue;
            return true;
        }
        assert (!this.isAllNaN()) : this;
        return false;
    }

    @Override
    public boolean isAllNaN() {
        for (int i = 0; i < this.coordinates.length; ++i) {
            if (Double.isNaN(this.coordinates[i])) continue;
            return false;
        }
        assert (this.isEmpty()) : this;
        return true;
    }

    @Override
    public int hashCode() {
        int n = Arrays.hashCode(this.coordinates);
        if (this.crs != null) {
            n += this.crs.hashCode();
        }
        assert (n == this.hashCodeByAPI());
        return n;
    }

    final int hashCodeByAPI() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            ArrayEnvelope arrayEnvelope = (ArrayEnvelope)object;
            return Arrays.equals(this.coordinates, arrayEnvelope.coordinates) && Objects.equals(this.crs, arrayEnvelope.crs);
        }
        return false;
    }

    final boolean equalsByAPI(Object object) {
        return super.equals(object);
    }

    @Override
    public String toString() {
        return ArrayEnvelope.toString(this, ArraysExt.isSinglePrecision(this.coordinates));
    }
}

